/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.entities.DryingRackEntity;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import cn.foggyhillside.festival_delicacies.util.Utils;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.99f, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)15.99f, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99f, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)15.99f, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)});

    public DryingRackBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new DryingRackEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldStack = pPlayer.m_21120_(pHand);
        BlockEntity entity = pLevel.m_7702_(pPos);
        if (entity instanceof DryingRackEntity) {
            DryingRackEntity rackEntity = (DryingRackEntity)entity;
            int nextSlot = rackEntity.getNextEmptySlot();
            if (pPlayer.m_6144_()) {
                if (pHand.equals((Object)InteractionHand.MAIN_HAND) && heldStack.m_41619_() && !rackEntity.isEmpty()) {
                    NonNullList<ItemStack> list = rackEntity.getInventoryList();
                    Direction direction = ((Direction)pState.m_61143_((Property)FACING)).m_122428_();
                    for (ItemStack itemStack : list) {
                        Utils.dropItem(pLevel, itemStack.m_41620_(itemStack.m_41613_()), (float)pPos.m_123341_() + 0.5f, (float)pPos.m_123342_() + 1.0f, (float)pPos.m_123343_() + 0.5f, (float)direction.m_122429_() * 0.2f, 0.0, (float)direction.m_122431_() * 0.2f);
                    }
                    Arrays.fill(rackEntity.getProgressArray(), 0);
                    pLevel.m_46717_(pPos, (Block)this);
                    return InteractionResult.SUCCESS;
                }
            } else {
                ItemStack mainHandStack;
                if (nextSlot < 0) {
                    return InteractionResult.PASS;
                }
                if (pHand.equals((Object)InteractionHand.MAIN_HAND) ? rackEntity.addItem(heldStack, pPlayer, nextSlot) : (mainHandStack = pPlayer.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && rackEntity.addItem(heldStack, pPlayer, nextSlot)) {
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof DryingRackEntity) {
                DryingRackEntity rackEntity = (DryingRackEntity)blockEntity;
                Containers.m_19010_((Level)pLevel, (BlockPos)pPos, rackEntity.getInventoryList());
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 45;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 45;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return DryingRackBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.DRYING_RACK.get()), DryingRackEntity::tick);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof DryingRackEntity) {
            DryingRackEntity entity = (DryingRackEntity)blockEntity;
            int size = entity.getInventoryList().size();
            if (size < 12) {
                return size;
            }
            return 15;
        }
        return super.m_6782_(pState, pLevel, pPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

