/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.FruitBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    protected final Supplier<Block> fruitBlock;
    private static final int GROWTH_CHANCE = 10;
    public static final BooleanProperty FRUITED = BooleanProperty.m_61465_((String)"fruited");

    public FruitLeavesBlock(Supplier<Block> pBlock, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FRUITED, (Comparable)Boolean.valueOf(false)));
        this.fruitBlock = pBlock;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState newState = super.m_5573_(pContext);
        return (BlockState)newState.m_61124_((Property)FRUITED, (Comparable)Boolean.valueOf(false));
    }

    private boolean isFruited(Level pLevel, BlockPos pPos) {
        return pLevel.m_8055_(pPos.m_7495_()).m_60713_(this.fruitBlock.get());
    }

    public boolean m_6724_(BlockState pState) {
        return ((Integer)pState.m_61143_((Property)f_54418_) == 7 || (Boolean)pState.m_61143_((Property)FRUITED) == false) && (Boolean)pState.m_61143_((Property)f_54419_) == false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213898_(pState, pLevel, pPos, pRandom);
        if ((Integer)pState.m_61143_((Property)f_54418_) == 7) {
            return;
        }
        if (!this.isFruited((Level)pLevel, pPos) && pRandom.m_188503_(10) < 1 && pLevel.m_8055_(pPos.m_7495_()).m_60795_() && ((FruitBlock)this.fruitBlock.get()).m_7898_(pState, (LevelReader)pLevel, pPos.m_7494_())) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)FRUITED, (Comparable)Boolean.valueOf(true)));
            pLevel.m_7731_(pPos.m_7495_(), this.fruitBlock.get().m_49966_(), 2);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
        boolean isFruited = belowState.m_60713_(this.fruitBlock.get());
        if ((Boolean)pState.m_61143_((Property)FRUITED) != isFruited) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)FRUITED, (Comparable)Boolean.valueOf(isFruited)), 2);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState newState = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        BlockState belowState = pLevel.m_8055_(pCurrentPos.m_7495_());
        boolean isFruited = belowState.m_60713_(this.fruitBlock.get());
        if ((Boolean)pState.m_61143_((Property)FRUITED) != isFruited) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return newState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FRUITED});
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return true;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        if (this.isFruited((Level)pLevel, pPos)) {
            BlockState fruitState = pLevel.m_8055_(pPos.m_7495_());
            BonemealableBlock growable = (BonemealableBlock)pLevel.m_8055_(pPos.m_7494_()).m_60734_();
            if (growable.m_7370_((LevelReader)pLevel, pPos.m_7494_(), fruitState, false)) {
                growable.m_214148_(pLevel, pLevel.f_46441_, pPos.m_7494_(), fruitState);
            }
        } else if (pRandom.m_188503_(10) < 1) {
            pLevel.m_7731_(pPos.m_7495_(), this.fruitBlock.get().m_49966_(), 2);
        }
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

