/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.LotusAerialPartBlock;
import cn.foggyhillside.festival_delicacies.blocks.LotusStalkBlock;
import cn.foggyhillside.festival_delicacies.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class LotusBlock
extends LotusStalkBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SHAPE_1 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE_2 = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final VoxelShape SHAPE_3 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public LotusBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_STALK, (Comparable)Boolean.valueOf(false)));
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    public int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    public final boolean isMaxAge(BlockState pState) {
        return this.getAge(pState) >= this.getMaxAge();
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch (this.getAge(pState)) {
            case 0 -> SHAPE_1;
            case 3 -> SHAPE_3;
            default -> SHAPE_2;
        };
    }

    @Override
    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_204336_(BlockTags.f_144274_) || pState.m_60713_(Blocks.f_50093_);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{this.getAgeProperty()});
    }

    @Override
    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        float f = 10.0f;
        if (pLevel.m_45524_(pPos, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
            if (this.isMaxAge(pState)) {
                BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
                FluidState fluidState = pLevel.m_6425_(pPos.m_7494_());
                LotusStalkBlock stalk = (LotusStalkBlock)((Object)ModBlocks.LOTUS_STALK.get());
                LotusAerialPartBlock aerialPart = (LotusAerialPartBlock)((Object)ModBlocks.LOTUS_AERIAL_PART.get());
                if (fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8 && stalk.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                    pLevel.m_7731_(pPos.m_7494_(), stalk.m_49966_(), 2);
                } else if (aboveState.m_60795_() && aerialPart.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                    pLevel.m_7731_(pPos.m_7494_(), aerialPart.m_49966_(), 2);
                }
            } else {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getAge(pState) + 1)), 2);
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    @Override
    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int growAge = Math.min(this.getAge(pState) + this.getBonemealAgeIncrease((Level)pLevel), 7);
        if (growAge <= this.getMaxAge()) {
            pLevel.m_46597_(pPos, this.getStateForAge(growAge));
        } else {
            BonemealableBlock growable;
            BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
            FluidState fluidState = pLevel.m_6425_(pPos.m_7494_());
            if (!((Boolean)pState.m_61143_((Property)HAS_STALK)).booleanValue()) {
                LotusStalkBlock stalk = (LotusStalkBlock)((Object)ModBlocks.LOTUS_STALK.get());
                LotusAerialPartBlock aerialPart = (LotusAerialPartBlock)((Object)ModBlocks.LOTUS_AERIAL_PART.get());
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge())));
                if (fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8 && stalk.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                    pLevel.m_7731_(pPos.m_7494_(), stalk.m_49966_(), 2);
                } else if (aboveState.m_60795_() && aerialPart.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                    int ageLeft = growAge - this.getMaxAge() - 1;
                    pLevel.m_7731_(pPos.m_7494_(), (BlockState)aerialPart.m_49966_().m_61124_((Property)LotusAerialPartBlock.LOTUS_AGE, (Comparable)Integer.valueOf(ageLeft)), 2);
                }
            } else if ((aboveState.m_60734_().equals(ModBlocks.LOTUS_STALK.get()) || aboveState.m_60734_().equals(ModBlocks.LOTUS_AERIAL_PART.get())) && (growable = (BonemealableBlock)pLevel.m_8055_(pPos.m_7494_()).m_60734_()).m_7370_((LevelReader)pLevel, pPos.m_7494_(), aboveState, false)) {
                growable.m_214148_(pLevel, pLevel.f_46441_, pPos.m_7494_(), aboveState);
            }
        }
    }
}

