/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.LotusAerialPartBlock;
import cn.foggyhillside.festival_delicacies.registry.ModBlockStateProperties;
import cn.foggyhillside.festival_delicacies.registry.ModBlocks;
import cn.foggyhillside.festival_delicacies.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class LotusStalkBlock
extends BushBlock
implements BonemealableBlock,
LiquidBlockContainer {
    public static final BooleanProperty HAS_STALK = ModBlockStateProperties.HAS_STALK;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public LotusStalkBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HAS_STALK, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{HAS_STALK});
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)HAS_STALK) == false;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        float f = 10.0f;
        if (pLevel.m_45524_(pPos, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
            BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
            FluidState fluidState = pLevel.m_6425_(pPos.m_7494_());
            LotusAerialPartBlock aerialPart = (LotusAerialPartBlock)((Object)ModBlocks.LOTUS_AERIAL_PART.get());
            if (!LotusStalkBlock.isMaxHeight(pLevel, pPos) && fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8 && this.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                pLevel.m_7731_(pPos.m_7494_(), this.m_49966_(), 2);
            } else if (aboveState.m_60795_() && aerialPart.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                pLevel.m_7731_(pPos.m_7494_(), aerialPart.m_49966_(), 2);
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)ModItems.LOTUS_SEEDS.get());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluid = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76186_() == 8 ? super.m_5573_(pContext) : null;
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_60713_((Block)ModBlocks.LOTUS.get()) || pState.m_60713_((Block)ModBlocks.LOTUS_STALK.get());
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        FluidState fluid = pLevel.m_6425_(pPos);
        return super.m_7898_(pState, pLevel, pPos) && fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76186_() == 8;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState newState = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (!newState.m_60795_()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
            if (pFacing.equals((Object)Direction.UP)) {
                return (BlockState)newState.m_61124_((Property)HAS_STALK, (Comparable)Boolean.valueOf(pFacingState.m_60713_((Block)ModBlocks.LOTUS_AERIAL_PART.get()) || pFacingState.m_60713_((Block)ModBlocks.LOTUS_STALK.get())));
            }
        }
        return newState;
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
        if (aboveState.m_60713_((Block)ModBlocks.LOTUS_AERIAL_PART.get()) || aboveState.m_60713_((Block)ModBlocks.LOTUS_STALK.get())) {
            BonemealableBlock aboveBlock = (BonemealableBlock)aboveState.m_60734_();
            return aboveBlock.m_7370_(pLevel, pPos.m_7494_(), aboveState, pIsClient);
        }
        return true;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return Mth.m_216271_((RandomSource)pLevel.f_46441_, (int)1, (int)4);
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BonemealableBlock growable;
        BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
        FluidState fluidState = pLevel.m_6425_(pPos.m_7494_());
        if (!((Boolean)pState.m_61143_((Property)HAS_STALK)).booleanValue()) {
            LotusAerialPartBlock aerialPart = (LotusAerialPartBlock)((Object)ModBlocks.LOTUS_AERIAL_PART.get());
            if (!LotusStalkBlock.isMaxHeight(pLevel, pPos) && fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() == 8 && this.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                pLevel.m_7731_(pPos.m_7494_(), this.m_49966_(), 2);
            } else if (aboveState.m_60795_() && aerialPart.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                pLevel.m_7731_(pPos.m_7494_(), (BlockState)aerialPart.m_49966_().m_61124_((Property)LotusAerialPartBlock.LOTUS_AGE, (Comparable)Integer.valueOf(this.getBonemealAgeIncrease((Level)pLevel) - 1)), 2);
            }
        } else if ((aboveState.m_60734_().equals(ModBlocks.LOTUS_STALK.get()) || aboveState.m_60734_().equals(ModBlocks.LOTUS_AERIAL_PART.get())) && (growable = (BonemealableBlock)pLevel.m_8055_(pPos.m_7494_()).m_60734_()).m_7370_((LevelReader)pLevel, pPos.m_7494_(), aboveState, false)) {
            growable.m_214148_(pLevel, pLevel.f_46441_, pPos.m_7494_(), aboveState);
        }
    }

    public FluidState m_5888_(BlockState pState) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return false;
    }

    private static boolean isMaxHeight(ServerLevel pLevel, BlockPos pPos) {
        int h = 0;
        for (int i = -1; i < 3; ++i) {
            if (i != 0 && !pLevel.m_8055_(pPos.m_6625_(i)).m_60713_((Block)ModBlocks.LOTUS_STALK.get()) && !pLevel.m_8055_(pPos.m_6625_(i)).m_60713_((Block)ModBlocks.LOTUS.get())) continue;
            ++h;
        }
        return h >= 3;
    }
}

