/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.RiceEarBlock;
import cn.foggyhillside.festival_delicacies.registry.ModBlocks;
import cn.foggyhillside.festival_delicacies.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class RiceBlock
extends BushBlock
implements BonemealableBlock,
LiquidBlockContainer {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty HAS_EAR = BooleanProperty.m_61465_((String)"has_ear");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public RiceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)HAS_EAR, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)AGE)];
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        FluidState fluid = pLevel.m_6425_(pPos);
        return super.m_7898_(pState, pLevel, pPos) && fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76186_() == 8;
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)ModItems.RICE.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
        pBuilder.m_61104_(new Property[]{HAS_EAR});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluid = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76186_() == 8 ? super.m_5573_(pContext) : null;
    }

    public boolean m_6724_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)HAS_EAR) == false;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        BlockState newState = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (!newState.m_60795_()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
            if (pFacing.equals((Object)Direction.UP)) {
                return (BlockState)newState.m_61124_((Property)HAS_EAR, (Comparable)Boolean.valueOf(pFacingState.m_60713_((Block)ModBlocks.RICE_EAR.get())));
            }
        }
        return newState;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9) {
            int i = (Integer)pState.m_61143_((Property)AGE);
            float f = 10.0f;
            if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                if (i < 3) {
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                } else {
                    RiceEarBlock riceEar = (RiceEarBlock)((Object)ModBlocks.RICE_EAR.get());
                    BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
                    if (aboveState.m_60795_() && riceEar.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                        pLevel.m_7731_(pPos.m_7494_(), riceEar.m_49966_(), 2);
                    }
                }
                ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
        Block block = aboveState.m_60734_();
        if (block instanceof RiceEarBlock) {
            RiceEarBlock riceEarBlock = (RiceEarBlock)block;
            return !riceEarBlock.m_52307_(aboveState);
        }
        return true;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    protected int getBonemealAgeIncrease(Level pLevel) {
        return Mth.m_216271_((RandomSource)pLevel.f_46441_, (int)1, (int)4);
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int growAge = Math.min((Integer)pState.m_61143_((Property)AGE) + this.getBonemealAgeIncrease((Level)pLevel), 7);
        if (growAge <= 3) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(growAge)));
        } else {
            BonemealableBlock growable;
            BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
            if (!((Boolean)pState.m_61143_((Property)HAS_EAR)).booleanValue()) {
                RiceEarBlock riceEar = (RiceEarBlock)((Object)ModBlocks.RICE_EAR.get());
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)));
                if (aboveState.m_60795_() && riceEar.m_7898_(aboveState, (LevelReader)pLevel, pPos.m_7494_())) {
                    int ageLeft = growAge - 3 - 1;
                    pLevel.m_7731_(pPos.m_7494_(), (BlockState)riceEar.m_49966_().m_61124_((Property)RiceEarBlock.RICE_AGE, (Comparable)Integer.valueOf(ageLeft)), 2);
                }
            } else if (aboveState.m_60734_().equals(ModBlocks.RICE_EAR.get()) && (growable = (BonemealableBlock)pLevel.m_8055_(pPos.m_7494_()).m_60734_()).m_7370_((LevelReader)pLevel, pPos.m_7494_(), aboveState, false)) {
                growable.m_214148_(pLevel, pLevel.f_46441_, pPos.m_7494_(), aboveState);
            }
        }
    }

    public FluidState m_5888_(BlockState pState) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return false;
    }
}

