/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks;

import cn.foggyhillside.festival_delicacies.blocks.entities.WoodenPlateEntity;
import cn.foggyhillside.festival_delicacies.registry.ModBlockStateProperties;
import cn.foggyhillside.festival_delicacies.registry.ModItems;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WoodenPlateBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty PLATE_ITEM_TYPE = ModBlockStateProperties.PLATE_ITEM_TYPE;
    public static final IntegerProperty AMOUNT = ModBlockStateProperties.AMOUNT;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public WoodenPlateBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)PLATE_ITEM_TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        BlockState newState = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof WoodenPlateEntity) {
            WoodenPlateEntity entity = (WoodenPlateEntity)blockEntity;
            return entity.getLastPlateState(newState);
        }
        return newState;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        ItemStack heldStack = pPlayer.m_21120_(pHand);
        if (blockEntity instanceof WoodenPlateEntity) {
            WoodenPlateEntity plateEntity = (WoodenPlateEntity)blockEntity;
            if (pHand.equals((Object)InteractionHand.MAIN_HAND)) {
                if (!heldStack.m_41619_() && !plateEntity.isFull() && (heldStack.m_204117_(ModTags.DUMPLING) || heldStack.m_150930_((Item)ModItems.QINGTUAN.get()) || heldStack.m_204117_(ModTags.MOONCAKE))) {
                    if (plateEntity.addItem(heldStack, pPlayer)) {
                        pLevel.m_46597_(pPos, plateEntity.getLastPlateState(pState));
                        return InteractionResult.SUCCESS;
                    }
                } else if (heldStack.m_41619_() && !plateEntity.isEmpty() && plateEntity.extractItem(pPlayer, pHand)) {
                    pLevel.m_46597_(pPos, plateEntity.getLastPlateState(pState));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof WoodenPlateEntity) {
                WoodenPlateEntity plate = (WoodenPlateEntity)blockEntity;
                Containers.m_19010_((Level)pLevel, (BlockPos)pPos, plate.getInventoryList());
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public boolean m_48673_(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{PLATE_ITEM_TYPE});
        builder.m_61104_(new Property[]{AMOUNT});
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof WoodenPlateEntity) {
            WoodenPlateEntity plateEntity = (WoodenPlateEntity)blockEntity;
            if (plateEntity.isFull()) {
                return 15;
            }
            if (plateEntity.isEmpty()) {
                return 0;
            }
            return 15 / plateEntity.getMaxAmount() * plateEntity.getItemAmount();
        }
        return 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new WoodenPlateEntity(pPos, pState);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }
}

