/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities;

import cn.foggyhillside.festival_delicacies.blocks.entities.SyncedBlockEntity;
import cn.foggyhillside.festival_delicacies.blocks.entities.inventory.ChoppingBlockItemHandler;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChoppingBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new ChoppingBlockItemHandler((IItemHandlerModifiable)this.inventory));

    public ChoppingBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CHOPPING_BLOCK.get(), pPos, pBlockState);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                ChoppingBlockEntity.this.inventoryChanged();
            }
        };
    }

    public ItemStack getItemStack() {
        return this.inventory.getStackInSlot(0).m_41777_();
    }

    public void itemHurt(Level pLevel, BlockPos pPos) {
        if (this.inventory.getStackInSlot(0).m_220157_(1, pLevel.f_46441_, null)) {
            this.inventory.getStackInSlot(0).m_41764_(0);
            pLevel.m_6263_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("Inventory"));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap.equals((Object)ForgeCapabilities.ITEM_HANDLER) ? this.inputHandler.cast() : super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    public boolean addItem(ItemStack itemStack, Player player) {
        if (this.inventory.getStackInSlot(0).m_41619_() && !itemStack.m_41619_()) {
            if (!player.m_150110_().f_35937_) {
                this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            } else {
                this.inventory.setStackInSlot(0, itemStack.m_255036_(1));
            }
            return true;
        }
        return false;
    }

    public boolean extractItem(Player player, InteractionHand hand) {
        if (!this.inventory.getStackInSlot(0).m_41619_() && player.m_21120_(hand).m_41619_()) {
            ItemStack itemStack = this.inventory.getStackInSlot(0);
            player.m_21008_(hand, itemStack.m_41620_(1));
            return true;
        }
        return false;
    }
}

