/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities;

import cn.foggyhillside.festival_delicacies.blocks.DryingRackBlock;
import cn.foggyhillside.festival_delicacies.blocks.entities.SyncedBlockEntity;
import cn.foggyhillside.festival_delicacies.blocks.entities.inventory.DryingRackItemHandler;
import cn.foggyhillside.festival_delicacies.recipe.DryingRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import cn.foggyhillside.festival_delicacies.util.Utils;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DryingRackEntity
extends SyncedBlockEntity {
    private final int MAX_PROGRESS = 600;
    private final int SLOTS = 12;
    private final ItemStackHandler inventory;
    private final LazyOptional<IItemHandler> inputItemHandler;
    private final LazyOptional<IItemHandler> outputItemHandler;
    private final int[] progressArray = new int[12];

    public DryingRackEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.DRYING_RACK.get(), pPos, pBlockState);
        this.inventory = this.createHandler();
        this.inputItemHandler = LazyOptional.of(() -> new DryingRackItemHandler((IItemHandlerModifiable)this.inventory, Direction.UP));
        this.outputItemHandler = LazyOptional.of(() -> new DryingRackItemHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN));
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(12){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                DryingRackEntity.this.inventoryChanged();
            }
        };
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(pTag.m_128469_("Inventory"));
        }
        if (pTag.m_128425_("Progress", 11)) {
            int[] arrayProgress = pTag.m_128465_("Progress");
            System.arraycopy(arrayProgress, 0, this.progressArray, 0, Math.min(this.progressArray.length, arrayProgress.length));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        pTag.m_128385_("Progress", this.progressArray);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.inputItemHandler.cast();
            }
            if (side.equals((Object)Direction.DOWN)) {
                return this.outputItemHandler.cast();
            }
            return this.inputItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputItemHandler.invalidate();
        this.outputItemHandler.invalidate();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DryingRackEntity rackEntity) {
        if (level.f_46443_) {
            return;
        }
        ItemStackHandler rackInventory = rackEntity.inventory;
        Direction direction = ((Direction)state.m_61143_((Property)DryingRackBlock.FACING)).m_122428_();
        for (int i = 0; i < rackInventory.getSlots(); ++i) {
            ItemStack stack = rackInventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            SimpleContainer container = new SimpleContainer(new ItemStack[]{stack});
            Optional recipe = level.m_7465_().m_44015_((RecipeType)DryingRecipe.Type.INSTANCE, (Container)container, level);
            if (recipe.isPresent()) {
                if (rackEntity.progressArray[i] < rackEntity.MAX_PROGRESS) {
                    int n = i;
                    rackEntity.progressArray[n] = rackEntity.progressArray[n] + 1;
                    DryingRackEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                    continue;
                }
                rackInventory.setStackInSlot(i, ((DryingRecipe)recipe.get()).m_8043_(level.m_9598_()).m_41777_());
                Utils.dropItem(level, rackInventory.getStackInSlot(i).m_41620_(rackInventory.getStackInSlot(i).m_41613_()), (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 0.5f, (float)direction.m_122429_() * 0.2f, 0.0, (float)direction.m_122431_() * 0.2f);
                rackEntity.progressArray[i] = 0;
                DryingRackEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                continue;
            }
            Utils.dropItem(level, stack.m_41620_(stack.m_41613_()), (float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.0f, (float)pos.m_123343_() + 0.5f, (float)direction.m_122429_() * 0.2f, 0.0, (float)direction.m_122431_() * 0.2f);
            DryingRackEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public int[] getProgressArray() {
        return this.progressArray;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getInventoryList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 12; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            list.add(stack);
        }
        NonNullList nonNullList = NonNullList.m_122780_((int)list.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            nonNullList.set(i, (Object)((ItemStack)list.get(i)));
        }
        return nonNullList;
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack heldStack, Player player, int nextSlot) {
        if (!heldStack.m_41619_() && heldStack.m_204117_(ModTags.DRYING_RACK_ALLOWED)) {
            if (!player.m_150110_().f_35937_) {
                this.inventory.setStackInSlot(nextSlot, heldStack.m_41620_(1));
            } else {
                this.inventory.setStackInSlot(nextSlot, heldStack.m_255036_(1));
            }
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }
}

