/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities;

import cn.foggyhillside.festival_delicacies.blocks.FermentationJarBlock;
import cn.foggyhillside.festival_delicacies.blocks.entities.SyncedBlockEntity;
import cn.foggyhillside.festival_delicacies.blocks.entities.inventory.MenuBlockItemHandler;
import cn.foggyhillside.festival_delicacies.blocks.screen.FermentationJarMenu;
import cn.foggyhillside.festival_delicacies.recipe.FermentingRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import cn.foggyhillside.festival_delicacies.util.Utils;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationJarEntity
extends SyncedBlockEntity
implements MenuProvider,
RecipeHolder {
    private static final int CONTAINER_INPUT = 6;
    private static final int RESULT_OUTPUT = 7;
    public static final int SLOTS = 8;
    private int progress = 0;
    private int maxProgress;
    private boolean hasLastSignal;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker;
    protected final ContainerData data;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> playerItemHandler = LazyOptional.of(() -> new MenuBlockItemHandler((IItemHandlerModifiable)this.inventory, null, 6, 7));
    private final LazyOptional<IItemHandler> inputItemHandler = LazyOptional.of(() -> new MenuBlockItemHandler((IItemHandlerModifiable)this.inventory, Direction.UP, 6, 7));
    private final LazyOptional<IItemHandler> outputItemHandler = LazyOptional.of(() -> new MenuBlockItemHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN, 6, 7));

    public FermentationJarEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FERMENTATION_JAR.get(), pPos, pBlockState);
        this.usedRecipeTracker = new Object2IntOpenHashMap();
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> FermentationJarEntity.this.progress;
                    case 1 -> FermentationJarEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        FermentationJarEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        FermentationJarEntity.this.maxProgress = value;
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        };
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                FermentationJarEntity.this.inventoryChanged();
            }
        };
    }

    public void m_142466_(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.progress = nbt.m_128451_("Progress");
        this.maxProgress = nbt.m_128451_("MaxProgress");
        CompoundTag compoundRecipes = nbt.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
        super.m_142466_(nbt);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("Progress", this.progress);
        nbt.m_128405_("MaxProgress", this.maxProgress);
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        nbt.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.playerItemHandler.cast();
            }
            if (side.equals((Object)Direction.UP)) {
                return this.inputItemHandler.cast();
            }
            return this.outputItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputItemHandler.invalidate();
        this.outputItemHandler.invalidate();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FermentationJarEntity jarEntity) {
        if (level.f_46443_) {
            return;
        }
        int redstone = (Integer)state.m_61143_((Property)FermentationJarBlock.RED_STONE);
        if (FermentationJarEntity.isStartButtonDown(level, pos, state, jarEntity, redstone)) {
            Optional recipe = level.m_7465_().m_44015_((RecipeType)FermentingRecipe.Type.INSTANCE, (Container)FermentationJarEntity.getOrderedInventoryContainer(jarEntity), level);
            if (recipe.isPresent() && FermentationJarEntity.canOutput(level, jarEntity, (FermentingRecipe)recipe.get())) {
                ++jarEntity.progress;
                jarEntity.maxProgress = ((FermentingRecipe)recipe.get()).getCookTime();
                FermentationJarEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (jarEntity.progress >= ((FermentingRecipe)recipe.get()).getCookTime()) {
                    FermentationJarEntity.craftItem(level, jarEntity, (FermentingRecipe)recipe.get());
                }
            } else {
                jarEntity.resetProgress();
                jarEntity.resetStartButton(level, pos);
                FermentationJarEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else {
            jarEntity.resetProgress();
            FermentationJarEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        jarEntity.hasLastSignal = level.m_276867_(pos);
    }

    private static boolean isStartButtonDown(Level level, BlockPos pos, BlockState state, FermentationJarEntity entity, int redstone) {
        return switch ((Integer)state.m_61143_((Property)FermentationJarBlock.START_BUTTON)) {
            case 0 -> {
                if (redstone == 1 && !entity.hasLastSignal && level.m_276867_(pos)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)FermentationJarBlock.START_BUTTON, (Comparable)Integer.valueOf(1)));
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (redstone == 1 && !entity.hasLastSignal && level.m_276867_(pos)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)FermentationJarBlock.START_BUTTON, (Comparable)Integer.valueOf(0)));
                    yield false;
                }
                yield true;
            }
            default -> throw new IllegalStateException("Unexpected value: " + state.m_61143_((Property)FermentationJarBlock.START_BUTTON));
        };
    }

    private static SimpleContainer getOrderedInventoryContainer(FermentationJarEntity entity) {
        SimpleContainer container = new SimpleContainer(entity.inventory.getSlots());
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = entity.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            container.m_6836_(i, stack);
        }
        return container;
    }

    private static void craftItem(Level level, FermentationJarEntity entity, FermentingRecipe recipe) {
        ItemStack stack;
        int i;
        ItemStack result = recipe.m_8043_(level.m_9598_());
        int m = 1;
        int t = 0;
        for (i = 0; i < 7; ++i) {
            stack = entity.inventory.getStackInSlot(i);
            if (stack.equals(ItemStack.f_41583_)) continue;
            m = stack.m_41613_();
            t = i + 1;
            break;
        }
        for (i = t; i < 7; ++i) {
            stack = entity.inventory.getStackInSlot(i);
            if (stack.equals(ItemStack.f_41583_)) continue;
            m = Math.min(m, stack.m_41613_());
        }
        m = Math.min(m, result.m_41741_());
        if (!entity.inventory.getStackInSlot(7).equals(ItemStack.f_41583_)) {
            i = (result.m_41741_() - entity.inventory.getStackInSlot(7).m_41613_()) / result.m_41613_();
            m = Math.min(m, i);
        }
        for (i = 0; i < 7; ++i) {
            stack = entity.inventory.getStackInSlot(i);
            if (stack.equals(ItemStack.f_41583_)) continue;
            if (stack.hasCraftingRemainingItem()) {
                ItemStack remaining = stack.getCraftingRemainingItem();
                remaining.m_41764_(m);
                FermentationJarEntity.spawnItem(entity, level, remaining);
            }
            entity.inventory.extractItem(i, m, false);
        }
        entity.inventory.setStackInSlot(7, new ItemStack((ItemLike)result.m_41720_(), entity.inventory.getStackInSlot(7).m_41613_() + result.m_41613_() * m));
        while (m != 0) {
            entity.m_6029_(recipe);
            --m;
        }
        entity.resetProgress();
    }

    private static void spawnItem(FermentationJarEntity entity, Level level, ItemStack itemStack) {
        Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)FermentationJarBlock.FACING)).m_122428_();
        double x = (float)entity.f_58858_.m_123341_() + 0.5f + (float)direction.m_122429_() * 0.25f;
        double y = (float)entity.f_58858_.m_123342_() + 0.7f;
        double z = (float)entity.f_58858_.m_123343_() + 0.5f + (float)direction.m_122431_() * 0.25f;
        Utils.dropItem(level, itemStack, x, y, z, (float)direction.m_122429_() * 0.06f, 0.2f, (float)direction.m_122431_() * 0.06f);
    }

    private static boolean canOutput(Level level, FermentationJarEntity entity, FermentingRecipe recipe) {
        ItemStack resultSlot = entity.inventory.getStackInSlot(7);
        ItemStack recipeResult = recipe.m_8043_(level.m_9598_());
        return resultSlot.equals(ItemStack.f_41583_) || resultSlot.m_41720_().equals(recipeResult.m_41720_()) && recipeResult.m_41741_() - resultSlot.m_41613_() >= recipeResult.m_41613_();
    }

    private void resetProgress() {
        this.progress = 0;
        this.inventoryChanged();
    }

    private void resetStartButton(Level level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)this.m_58900_().m_61124_((Property)FermentationJarBlock.START_BUTTON, (Comparable)Integer.valueOf(0)));
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public SimpleContainer getInventoryContainer() {
        SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            container.m_19173_(stack);
        }
        return container;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.festival_delicacies.fermentation_jar");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FermentationJarMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation recipeID = pRecipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player pPlayer, List<ItemStack> pItems) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(pPlayer.m_9236_(), pPlayer.m_20182_());
        pPlayer.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                Utils.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((FermentingRecipe)recipe).getExperience());
            });
        }
        return list;
    }
}

