/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities;

import cn.foggyhillside.festival_delicacies.blocks.StoveBlock;
import cn.foggyhillside.festival_delicacies.blocks.entities.SyncedBlockEntity;
import cn.foggyhillside.festival_delicacies.blocks.entities.inventory.MenuBlockItemHandler;
import cn.foggyhillside.festival_delicacies.blocks.screen.StoveMenu;
import cn.foggyhillside.festival_delicacies.config.CommonConfigs;
import cn.foggyhillside.festival_delicacies.items.DumplingItem;
import cn.foggyhillside.festival_delicacies.recipe.StoveRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import cn.foggyhillside.festival_delicacies.util.Utils;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoveEntity
extends SyncedBlockEntity
implements MenuProvider,
RecipeHolder {
    private static final int CONTAINER_INPUT = 9;
    private static final int RESULT_OUTPUT = 10;
    public final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandlerModifiable> playerInputHandler = LazyOptional.of(() -> new MenuBlockItemHandler((IItemHandlerModifiable)this.inventory, null, 9, 10));
    private final LazyOptional<IItemHandlerModifiable> inputHandler = LazyOptional.of(() -> new MenuBlockItemHandler((IItemHandlerModifiable)this.inventory, Direction.UP, 9, 10));
    private final LazyOptional<IItemHandlerModifiable> outputHandler = LazyOptional.of(() -> new MenuBlockItemHandler((IItemHandlerModifiable)this.inventory, Direction.DOWN, 9, 10));
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> StoveEntity.this.progress;
                case 1 -> StoveEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    StoveEntity.this.progress = value;
                    break;
                }
                case 1: {
                    StoveEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress;
    private boolean hasLastSignal;

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(11){

            protected void onContentsChanged(int slot) {
                StoveEntity.this.inventoryChanged();
            }
        };
    }

    public StoveEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STOVE.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.playerInputHandler.cast();
            }
            if (side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.festival_delicacies.stove");
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128405_("Progress", this.progress);
        nbt.m_128405_("MaxProgress", this.maxProgress);
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        nbt.m_128365_("RecipesUsed", (Tag)compoundRecipes);
    }

    public void m_142466_(CompoundTag nbt) {
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.progress = nbt.m_128451_("Progress");
        this.maxProgress = nbt.m_128451_("MaxProgress");
        CompoundTag compoundRecipes = nbt.m_128469_("RecipesUsed");
        for (String key : compoundRecipes.m_128431_()) {
            this.usedRecipeTracker.put((Object)new ResourceLocation(key), compoundRecipes.m_128451_(key));
        }
        super.m_142466_(nbt);
    }

    public SimpleContainer getInventoryContainer() {
        SimpleContainer container = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            container.m_19173_(this.inventory.getStackInSlot(i));
        }
        return container;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StoveEntity entity) {
        if (level.f_46443_) {
            return;
        }
        int type = (Integer)state.m_61143_((Property)StoveBlock.COOKING_TYPE);
        int start = (Integer)state.m_61143_((Property)StoveBlock.START_BUTTON);
        int redstone = (Integer)state.m_61143_((Property)StoveBlock.RED_STONE);
        if (type >= 1 && type <= 4) {
            if (start == 1) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)StoveBlock.START_BUTTON, (Comparable)Integer.valueOf(0)));
            }
            Optional recipe = level.m_7465_().m_44015_((RecipeType)StoveRecipe.Type.INSTANCE, (Container)StoveEntity.getOrderedInventoryContainer(entity), level);
            int cookingType = (Integer)state.m_61143_((Property)StoveBlock.COOKING_TYPE);
            if (recipe.isPresent() && StoveEntity.canCook(level, cookingType, entity, state, (StoveRecipe)recipe.get())) {
                ++entity.progress;
                entity.maxProgress = ((StoveRecipe)recipe.get()).getCookTime();
                StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (entity.progress >= ((StoveRecipe)recipe.get()).getCookTime()) {
                    StoveEntity.craftItem(level, entity, (StoveRecipe)recipe.get());
                }
            } else {
                entity.resetProgress();
                StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else if (entity.inventory.getStackInSlot(9).m_204117_(ModTags.DOUGH)) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            int count = 0;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = entity.inventory.getStackInSlot(i).m_41777_();
                if (!(!((Boolean)CommonConfigs.NESTING_DUMPLING.get()).booleanValue() && stack.m_204117_(ModTags.DUMPLING) || Utils.checkItemAndTag(ModTags.BANNED_DUMPLING_INGREDIENTS_CRAFTING, CommonConfigs.BANNED_DUMPLING_INGREDIENTS_CRAFTING, CommonConfigs.BANNED_INGREDIENT_TAGS_CRAFTING, stack))) {
                    stack.m_41764_(1);
                    if (stack.m_41619_()) continue;
                    ++count;
                    if (!stack.m_41720_().m_41472_() && !stack.m_150930_(Items.f_42589_) && (!((Boolean)CommonConfigs.ALLOW_INEDIBLE_INGREDIENTS.get()).booleanValue() || !Utils.checkItemAndTag(ModTags.ALLOWED_INEDIBLE_CRAFTING, CommonConfigs.ALLOWED_INEDIBLE_CRAFTING, CommonConfigs.ALLOWED_INEDIBLE_CRAFTING_TAGS, stack))) continue;
                    list.add(stack);
                    continue;
                }
                return;
            }
            ItemStack result = DumplingItem.of((Integer)entity.m_58900_().m_61143_((Property)StoveBlock.COOKING_TYPE), list);
            if (!list.isEmpty() && list.size() == count && StoveEntity.canCookDumpling(level, pos, entity, state, result, redstone)) {
                ++entity.progress;
                entity.maxProgress = (Integer)CommonConfigs.DUMPLING_COOKING_TIME.get();
                StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                if (entity.progress >= entity.maxProgress) {
                    StoveEntity.craftDumpling(level, entity, result);
                }
            } else {
                entity.resetProgress();
                entity.resetStartButton(level, pos);
                StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            }
        } else {
            entity.resetProgress();
            entity.resetStartButton(level, pos);
            StoveEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        entity.hasLastSignal = level.m_276867_(pos);
    }

    private static boolean canCook(Level level, int cookingType, StoveEntity entity, BlockState state, StoveRecipe recipe) {
        boolean isSameType = cookingType == recipe.getCookingType();
        return isSameType && StoveEntity.isLit(state) && StoveEntity.canOutput(level, entity, recipe);
    }

    private static boolean canCookDumpling(Level level, BlockPos pos, StoveEntity entity, BlockState state, ItemStack result, int redstone) {
        return StoveEntity.isLit(state) && StoveEntity.canOutputDumpling(entity, result) && StoveEntity.isStartButtonDown(level, pos, state, entity, redstone);
    }

    private static boolean canOutput(Level level, StoveEntity entity, StoveRecipe recipe) {
        RegistryAccess registryAccess = level.m_9598_();
        ItemStack resultSlot = entity.inventory.getStackInSlot(10);
        ItemStack recipeResult = recipe.m_8043_(registryAccess);
        return resultSlot == ItemStack.f_41583_ || resultSlot.m_41720_() == recipeResult.m_41720_() && recipeResult.m_41741_() - resultSlot.m_41613_() >= recipeResult.m_41613_();
    }

    private static boolean canOutputDumpling(StoveEntity entity, ItemStack result) {
        ItemStack resultSlot = entity.inventory.getStackInSlot(10);
        return resultSlot == ItemStack.f_41583_ || ItemStack.m_150942_((ItemStack)resultSlot, (ItemStack)result) && result.m_41741_() - resultSlot.m_41613_() >= result.m_41613_();
    }

    private static boolean isLit(BlockState state) {
        return (Boolean)state.m_61143_((Property)StoveBlock.LIT);
    }

    private static boolean isStartButtonDown(Level level, BlockPos pos, BlockState state, StoveEntity entity, int redstone) {
        return switch ((Integer)state.m_61143_((Property)StoveBlock.START_BUTTON)) {
            case 0 -> {
                if (redstone == 1 && !entity.hasLastSignal && level.m_276867_(pos)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)StoveBlock.START_BUTTON, (Comparable)Integer.valueOf(1)));
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (redstone == 1 && !entity.hasLastSignal && level.m_276867_(pos)) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)StoveBlock.START_BUTTON, (Comparable)Integer.valueOf(0)));
                    yield false;
                }
                yield true;
            }
            default -> throw new IllegalStateException("Unexpected value: " + state.m_61143_((Property)StoveBlock.START_BUTTON));
        };
    }

    private void resetProgress() {
        this.progress = 0;
        this.inventoryChanged();
    }

    private void resetStartButton(Level level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)this.m_58900_().m_61124_((Property)StoveBlock.START_BUTTON, (Comparable)Integer.valueOf(0)));
    }

    private static SimpleContainer getOrderedInventoryContainer(StoveEntity entity) {
        SimpleContainer container = new SimpleContainer(entity.inventory.getSlots());
        for (int i = 0; i < 11; ++i) {
            ItemStack stack = entity.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            container.m_6836_(i, stack);
        }
        return container;
    }

    private static void craftItem(Level level, StoveEntity entity, StoveRecipe recipe) {
        for (int i = 0; i < 10; ++i) {
            if (entity.inventory.getStackInSlot(i) == ItemStack.f_41583_) continue;
            if (entity.inventory.getStackInSlot(i).hasCraftingRemainingItem()) {
                StoveEntity.spawnItem(entity, level, entity.inventory.getStackInSlot(i).getCraftingRemainingItem());
            }
            entity.inventory.extractItem(i, 1, false);
        }
        entity.inventory.setStackInSlot(10, new ItemStack((ItemLike)recipe.m_8043_(level.m_9598_()).m_41720_(), entity.inventory.getStackInSlot(10).m_41613_() + recipe.m_8043_(level.m_9598_()).m_41613_()));
        entity.m_6029_(recipe);
        entity.resetProgress();
    }

    private static void craftDumpling(Level level, StoveEntity entity, ItemStack result) {
        for (int i = 0; i < 10; ++i) {
            if (entity.inventory.getStackInSlot(i) == ItemStack.f_41583_) continue;
            if (entity.inventory.getStackInSlot(i).hasCraftingRemainingItem()) {
                StoveEntity.spawnItem(entity, level, entity.inventory.getStackInSlot(i).getCraftingRemainingItem());
            } else if (entity.inventory.getStackInSlot(i).m_150930_(Items.f_42589_)) {
                StoveEntity.spawnItem(entity, level, new ItemStack((ItemLike)Items.f_42590_, 1));
            } else if (entity.inventory.getStackInSlot(i).m_41720_() instanceof SuspiciousStewItem || entity.inventory.getStackInSlot(i).m_41720_() instanceof BowlFoodItem) {
                StoveEntity.spawnItem(entity, level, new ItemStack((ItemLike)Items.f_42399_, 1));
            }
            entity.inventory.extractItem(i, 1, false);
        }
        ItemStack resultSlot = entity.inventory.getStackInSlot(10);
        if (resultSlot == ItemStack.f_41583_) {
            entity.inventory.setStackInSlot(10, result);
        } else {
            ItemStack stack = result.m_41777_();
            stack.m_41764_(resultSlot.m_41613_() + result.m_41613_());
            entity.inventory.setStackInSlot(10, stack);
        }
        entity.resetProgress();
    }

    private static void spawnItem(StoveEntity entity, Level level, ItemStack itemStack) {
        Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)StoveBlock.FACING)).m_122428_();
        double x = (float)entity.f_58858_.m_123341_() + 0.5f + (float)direction.m_122429_() * 0.25f;
        double y = (float)entity.f_58858_.m_123342_() + 1.0f;
        double z = (float)entity.f_58858_.m_123343_() + 0.5f + (float)direction.m_122431_() * 0.25f;
        Utils.dropItem(level, itemStack, x, y, z, (float)direction.m_122429_() * 0.06f, 0.2f, (float)direction.m_122431_() * 0.06f);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new StoveMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation recipeID = pRecipe.m_6423_();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_58395_(Player pPlayer, List<ItemStack> pItems) {
        List<Recipe<?>> usedRecipes = this.getUsedRecipesAndPopExperience(pPlayer.m_9236_(), pPlayer.m_20182_());
        pPlayer.m_7281_(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<Recipe<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                Utils.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((StoveRecipe)recipe).getExperience());
            });
        }
        return list;
    }
}

