/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities;

import cn.foggyhillside.festival_delicacies.blocks.WoodenPlateBlock;
import cn.foggyhillside.festival_delicacies.blocks.entities.SyncedBlockEntity;
import cn.foggyhillside.festival_delicacies.blocks.entities.inventory.WoodenPlateItemHandler;
import cn.foggyhillside.festival_delicacies.registry.ModBlockEntities;
import cn.foggyhillside.festival_delicacies.registry.ModItems;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodenPlateEntity
extends SyncedBlockEntity {
    private final Map<Item, Integer> ITEM_MAP = Map.of((Item)ModItems.BOILED_DUMPLING.get(), 1, (Item)ModItems.STEAMED_DUMPLING.get(), 2, (Item)ModItems.BAOZI.get(), 3, (Item)ModItems.QINGTUAN.get(), 4, (Item)ModItems.FIVE_NUTS_MOONCAKE.get(), 5, (Item)ModItems.HAWTHORN_WITH_JUJUBE_PASTE_MOONCAKE.get(), 6, (Item)ModItems.LOTUS_SEED_PASTE_WITH_SALTED_YOLK_MOONCAKE.get(), 7, (Item)ModItems.PRESERVED_MEAT_MOONCAKE.get(), 8);
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new WoodenPlateItemHandler((IItemHandlerModifiable)this.inventory));

    public WoodenPlateEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.WOODEN_PLATE.get(), pPos, pBlockState);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                WoodenPlateEntity.this.inventoryChanged();
            }
        };
    }

    public int getMaxAmount() {
        if (this.inventory.getStackInSlot(0).m_204117_(ModTags.DUMPLING)) {
            return 6;
        }
        return 5;
    }

    public int getItemAmount() {
        int amount = 0;
        for (int i = 0; i < this.getMaxAmount(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            ++amount;
        }
        return amount;
    }

    public NonNullList<ItemStack> getInventoryList() {
        int maxAmount = this.getMaxAmount();
        NonNullList list = NonNullList.m_122780_((int)maxAmount, (Object)ItemStack.f_41583_);
        for (int i = 0; i < maxAmount; ++i) {
            list.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        return list;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("Inventory"));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap.equals((Object)ForgeCapabilities.ITEM_HANDLER) ? this.inputHandler.cast() : super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    private BlockState updateItemTypeState(BlockState pState, ItemStack stack) {
        int i;
        int n = i = this.ITEM_MAP.get(stack.m_41720_()) == null ? 0 : this.ITEM_MAP.get(stack.m_41720_());
        if (!((Integer)pState.m_61143_((Property)WoodenPlateBlock.PLATE_ITEM_TYPE)).equals(i)) {
            return (BlockState)pState.m_61124_((Property)WoodenPlateBlock.PLATE_ITEM_TYPE, (Comparable)Integer.valueOf(i));
        }
        return pState;
    }

    public BlockState getLastPlateState(BlockState pState) {
        BlockState newState = this.updateItemTypeState(pState, this.inventory.getStackInSlot(0));
        int amount = this.getItemAmount();
        if (!((Integer)newState.m_61143_((Property)WoodenPlateBlock.AMOUNT)).equals(amount)) {
            return (BlockState)newState.m_61124_((Property)WoodenPlateBlock.AMOUNT, (Comparable)Integer.valueOf(amount));
        }
        return newState;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 6; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (int i = 0; i < 6; ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean addItem(ItemStack itemStack, Player player) {
        if (!this.isFull() && !itemStack.m_41619_() && (this.inventory.getStackInSlot(0).m_41619_() || itemStack.m_150930_(this.inventory.getStackInSlot(0).m_41720_()))) {
            for (int i = 0; i < this.getMaxAmount(); ++i) {
                if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
                if (!player.m_150110_().f_35937_) {
                    this.inventory.setStackInSlot(i, itemStack.m_41620_(1));
                } else {
                    this.inventory.setStackInSlot(i, itemStack.m_255036_(1));
                }
                return true;
            }
        }
        return false;
    }

    public boolean extractItem(Player player, InteractionHand hand) {
        if (!this.isEmpty()) {
            for (int i = this.getMaxAmount() - 1; i >= 0; --i) {
                if (this.getInventory().getStackInSlot(i).m_41619_()) continue;
                player.m_21008_(hand, this.getInventory().getStackInSlot(i).m_41620_(1));
                return true;
            }
        }
        return false;
    }
}

