/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.entities.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class MenuBlockItemHandler
implements IItemHandlerModifiable {
    private final int containerInput;
    private final int resultInput;
    private final IItemHandlerModifiable itemHandler;
    private final Direction side;

    public MenuBlockItemHandler(IItemHandlerModifiable itemHandler, @Nullable Direction side, int containerInput, int resultInput) {
        this.itemHandler = itemHandler;
        this.side = side;
        this.containerInput = containerInput;
        this.resultInput = resultInput;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.side == null) {
            return slot <= this.containerInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        if (this.side.equals((Object)Direction.UP)) {
            return slot < this.containerInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        return slot == this.containerInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.side == null) {
            return slot <= this.resultInput ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }
        if (this.side.equals((Object)Direction.UP)) {
            return slot < this.containerInput ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }
        return slot == this.resultInput ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return slot >= 0 && slot <= this.containerInput;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }
}

