/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.blocks.screen;

import cn.foggyhillside.festival_delicacies.blocks.StoveBlock;
import cn.foggyhillside.festival_delicacies.blocks.entities.StoveEntity;
import cn.foggyhillside.festival_delicacies.blocks.entities.container.MenuResultSlot;
import cn.foggyhillside.festival_delicacies.registry.ModBlocks;
import cn.foggyhillside.festival_delicacies.registry.ModMenuTypes;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class StoveMenu
extends AbstractContainerMenu {
    public final StoveEntity entity;
    private final Level level;
    private final ContainerData data;

    public StoveMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, StoveMenu.getBlockEntity(inventory, extraData), (ContainerData)new SimpleContainerData(2));
    }

    public StoveMenu(int id, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.STOVE_MENU.get(), id);
        StoveMenu.m_38869_((Container)inventory, (int)11);
        this.entity = (StoveEntity)entity;
        this.level = inventory.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerHotbar(inventory);
        this.addPlayerInventory(inventory);
        this.entity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 30, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 48, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 66, 17));
            this.m_38897_((Slot)new SlotItemHandler(handler, 3, 30, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 4, 48, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 5, 66, 35));
            this.m_38897_((Slot)new SlotItemHandler(handler, 6, 30, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 7, 48, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 8, 66, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 9, 93, 17));
            this.m_38897_((Slot)new MenuResultSlot(inventory.f_35978_, (RecipeHolder)entity, (IItemHandler)handler, 10, 124, 36));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxprogress = this.data.m_6413_(1);
        int progressArrowSize = 24;
        return maxprogress != 0 && progress != 0 ? progress * progressArrowSize / maxprogress : 0;
    }

    public ItemStack m_7648_(Player player, int id) {
        int containerInput = 45;
        int output = 46;
        int startPlayerInv = 0;
        int endPlayerInv = 35;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(id);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (id == output) {
                if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv + 1, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (id <= endPlayerInv) {
                if ((Integer)this.entity.m_58900_().m_61143_((Property)StoveBlock.COOKING_TYPE) >= 1 && (Integer)this.entity.m_58900_().m_61143_((Property)StoveBlock.COOKING_TYPE) <= 4 ? (itemstack1.m_150930_(Items.f_42399_) || itemstack1.m_150930_(Items.f_42590_)) && !this.m_38903_(itemstack1, containerInput, containerInput + 1, false) : itemstack1.m_204117_(ModTags.DOUGH) && !this.m_38903_(itemstack1, containerInput, containerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(itemstack1, containerInput - 9, containerInput, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return StoveMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.entity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.STOVE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private static StoveEntity getBlockEntity(Inventory inventory, FriendlyByteBuf extraData) {
        Objects.requireNonNull(inventory, "inventory cannot be null");
        Objects.requireNonNull(extraData, "extraData cannot be null");
        BlockEntity blockEntity = inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_());
        if (blockEntity instanceof StoveEntity) {
            return (StoveEntity)blockEntity;
        }
        throw new IllegalStateException("Block entity is not correct! " + blockEntity);
    }
}

