/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.items;

import cn.foggyhillside.festival_delicacies.FoodList;
import cn.foggyhillside.festival_delicacies.ModCompat;
import cn.foggyhillside.festival_delicacies.config.CommonConfigs;
import cn.foggyhillside.festival_delicacies.items.DumplingItemHandler;
import cn.foggyhillside.festival_delicacies.items.TooltipItem;
import cn.foggyhillside.festival_delicacies.registry.ModItems;
import cn.foggyhillside.festival_delicacies.registry.ModTags;
import cn.foggyhillside.festival_delicacies.util.Utils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.FoodValues;

public class DumplingItem
extends TooltipItem {
    public DumplingItem(Item.Properties pProperties) {
        super(pProperties);
        this.hasTooltip = false;
    }

    public DumplingItem(Item.Properties pProperties, boolean hasTooltip) {
        super(pProperties);
        this.hasTooltip = hasTooltip;
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        List<ItemStack> list = DumplingItemHandler.deserializeNBTS(pStack.m_41698_("BlockEntityTag").m_128437_("Dumpling", 10));
        for (ItemStack itemStack : list) {
            if (!itemStack.m_41720_().m_41472_() && !Utils.checkItemAndTag(ModTags.ALLOWED_INEDIBLE_CONSUMPTION, CommonConfigs.ALLOWED_INEDIBLE_CONSUMPTION, CommonConfigs.ALLOWED_INEDIBLE_CONSUMPTION_TAGS, itemStack) || Utils.checkItemAndTag(ModTags.BANNED_DUMPLING_INGREDIENTS_CONSUMPTION, CommonConfigs.BANNED_DUMPLING_INGREDIENTS_CONSUMPTION, CommonConfigs.BANNED_INGREDIENT_TAGS_CONSUMPTION, itemStack)) continue;
            if (((Boolean)CommonConfigs.NO_FURTHER_NESTING.get()).booleanValue()) {
                this.finishUsingItemNoTag(itemStack, pLevel, pLivingEntity);
                continue;
            }
            if (itemStack.m_204117_(ModTags.DUMPLING) && !((Boolean)CommonConfigs.NESTING_DUMPLING.get()).booleanValue()) {
                this.finishUsingItemNoTag(itemStack, pLevel, pLivingEntity);
                continue;
            }
            itemStack.m_41671_(pLevel, pLivingEntity);
        }
        ItemStack stackNoTag = new ItemStack((ItemLike)pStack.m_41720_(), pStack.m_41613_());
        stackNoTag = super.m_5922_(stackNoTag, pLevel, pLivingEntity);
        pStack.m_41774_(pStack.m_41613_() - stackNoTag.m_41613_());
        return pStack;
    }

    private void finishUsingItemNoTag(ItemStack itemStack, Level pLevel, LivingEntity pLivingEntity) {
        ItemStack stackNoTag = new ItemStack((ItemLike)itemStack.m_41720_(), 1);
        stackNoTag.m_41671_(pLevel, pLivingEntity);
    }

    public Component m_7626_(ItemStack pStack) {
        if (pStack.m_41788_()) {
            return super.m_7626_(pStack);
        }
        return this.getDisplayName(pStack);
    }

    public Component getDisplayName(ItemStack pStack) {
        List<ItemStack> stackList = DumplingItemHandler.deserializeNBTS(pStack.m_41698_("BlockEntityTag").m_128437_("Dumpling", 10));
        ArrayList componentList = new ArrayList();
        Object type = pStack.m_41720_() == ModItems.BOILED_DUMPLING.get() ? "boiled_dumpling" : (pStack.m_41720_() == ModItems.STEAMED_DUMPLING.get() ? "steamed_dumpling" : "baozi");
        stackList.stream().collect(Collectors.groupingBy(item -> DumplingItem.getFullName(item).m_6879_())).forEach((item, list) -> componentList.add(item));
        if (componentList.size() > 3) {
            return this.translate((String)type, new Object[0]);
        }
        type = "ingredients." + (String)type;
        return this.translate((String)type, Component.m_237110_((String)"item.festival_delicacies.ingredients.%s".formatted(componentList.size()), (Object[])componentList.toArray()));
    }

    public Component translate(String type, Object ... args) {
        return Component.m_237110_((String)"item.%s.%s".formatted("festival_delicacies", type), (Object[])args);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        List<ItemStack> list = DumplingItemHandler.deserializeNBTS(stack.m_41698_("BlockEntityTag").m_128437_("Dumpling", 10));
        list.stream().collect(Collectors.groupingBy(item -> DumplingItem.getFullName(item).m_6879_(), LinkedHashMap::new, Collectors.counting())).forEach((item, count) -> {
            if (count > 1L) {
                tooltip.add((Component)Component.m_237110_((String)"%s.%s".formatted("festival_delicacies", "tooltip.ingredient_count"), (Object[])new Object[]{item, count}).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)item.m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    private int getTotalNutrition(List<ItemStack> list) {
        int nutrition = FoodList.FOOD_2_0$3.m_38744_();
        for (ItemStack item : list) {
            nutrition += this.getFood(item).m_38744_();
        }
        return nutrition;
    }

    private float getSaturationMod(List<ItemStack> list) {
        float t = (float)FoodList.FOOD_2_0$3.m_38744_() * FoodList.FOOD_2_0$3.m_38745_();
        for (ItemStack item : list) {
            t += this.getFood(item).m_38745_() * (float)this.getFood(item).m_38744_();
        }
        return t / (float)this.getTotalNutrition(list);
    }

    private FoodProperties getFood(ItemStack stack) {
        Item item = stack.m_41720_();
        FoodProperties.Builder builder = new FoodProperties.Builder();
        if (item == Items.f_42589_) {
            for (MobEffectInstance effectInstance : PotionUtils.m_43547_((ItemStack)stack)) {
                builder.m_38762_(effectInstance, 1.0f).m_38767_();
            }
            return builder.m_38767_();
        }
        if (stack.m_41614_()) {
            if (ModCompat.isFarmersDelightLoaded() && (item == Items.f_42400_ || item == Items.f_42734_ || item == Items.f_42699_)) {
                FoodProperties.Builder foodBuilder = new FoodProperties.Builder().m_38760_(item.m_41473_().m_38744_()).m_38758_(item.m_41473_().m_38745_());
                for (Pair pair : ((FoodProperties)FoodValues.VANILLA_SOUP_EFFECTS.get(item)).m_38749_()) {
                    foodBuilder.m_38762_((MobEffectInstance)pair.getFirst(), ((Float)pair.getSecond()).floatValue());
                }
                return foodBuilder.m_38767_();
            }
            return stack.getFoodProperties(null);
        }
        return builder.m_38767_();
    }

    private void addEffect(List<Pair<MobEffectInstance, Float>> effectList, Pair<MobEffectInstance, Float> pair) {
        if (effectList.isEmpty()) {
            effectList.add(pair);
        } else {
            int id = 0;
            boolean hasSameEffect = false;
            for (int i = 0; i < effectList.size(); ++i) {
                Pair<MobEffectInstance, Float> listPair = effectList.get(i);
                if (!((Float)listPair.getSecond()).equals(Float.valueOf(1.0f)) || !((Float)pair.getSecond()).equals(Float.valueOf(1.0f)) || ((MobEffectInstance)listPair.getFirst()).m_19544_() != ((MobEffectInstance)pair.getFirst()).m_19544_()) continue;
                hasSameEffect = true;
                id = i;
                break;
            }
            if (!hasSameEffect) {
                effectList.add(pair);
            } else if (((MobEffectInstance)effectList.get(id).getFirst()).m_19564_() < ((MobEffectInstance)pair.getFirst()).m_19564_()) {
                effectList.set(id, pair);
            } else if (((MobEffectInstance)effectList.get(id).getFirst()).m_19564_() == ((MobEffectInstance)pair.getFirst()).m_19564_() && ((MobEffectInstance)effectList.get(id).getFirst()).m_19557_() < ((MobEffectInstance)pair.getFirst()).m_19557_()) {
                effectList.set(id, pair);
            }
        }
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        List<ItemStack> list = DumplingItemHandler.deserializeNBTS(stack.m_41698_("BlockEntityTag").m_128437_("Dumpling", 10));
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(this.getTotalNutrition(list)).m_38758_(this.getSaturationMod(list));
        ArrayList<Pair<MobEffectInstance, Float>> effectList = new ArrayList<Pair<MobEffectInstance, Float>>();
        for (ItemStack itemStack : list) {
            for (Pair pair : this.getFood(itemStack).m_38749_()) {
                this.addEffect(effectList, (Pair<MobEffectInstance, Float>)pair);
            }
        }
        for (Pair pair : effectList) {
            if (pair.getFirst() == null) continue;
            builder.m_38762_((MobEffectInstance)pair.getFirst(), ((Float)pair.getSecond()).floatValue());
        }
        return builder.m_38767_();
    }

    public static Component getFullName(ItemStack itemStack) {
        return itemStack.m_41786_();
    }

    public static ItemStack makeDumpling(int type, ItemLike ... items) {
        return DumplingItem.makeDumpling(type, (ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeDumpling(int type, ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.addAll(Arrays.asList(items));
        return DumplingItem.of(type, list);
    }

    public static ItemStack of(int type, List<ItemStack> items) {
        ArrayList<ItemStack> flattenedItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item.m_41613_() != 1) {
                throw new IllegalArgumentException();
            }
            if (!((Boolean)CommonConfigs.NESTING_DUMPLING.get()).booleanValue() && item.m_204117_(ModTags.DUMPLING)) continue;
            flattenedItems.add(item);
        }
        Item itemType = switch (type) {
            case 6 -> (Item)ModItems.STEAMED_DUMPLING.get();
            case 7 -> (Item)ModItems.BAOZI.get();
            default -> (Item)ModItems.BOILED_DUMPLING.get();
        };
        ItemStack result = new ItemStack((ItemLike)itemType, 1);
        result.m_41698_("BlockEntityTag").m_128365_("Dumpling", (Tag)DumplingItemHandler.serializeItems(flattenedItems));
        return result;
    }
}

