/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class DumplingItemHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<ListTag>,
Iterable<ItemStack> {
    protected final List<ItemStack> items = new ArrayList<ItemStack>();
    protected FoodProperties foodProperties = new FoodProperties.Builder().m_38767_();

    public List<ItemStack> getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void add(ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        this.items.add(stack);
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public int getSlots() {
        return this.items.size();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        this.validateSlotIndex(slot);
        this.items.set(slot, stack);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.items.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    public ListTag serializeNBT() {
        return DumplingItemHandler.serializeItems(this.items);
    }

    public static ListTag serializeItems(List<ItemStack> items) {
        ListTag result = new ListTag();
        for (ItemStack stack : items) {
            result.add((Object)stack.m_41739_(new CompoundTag()));
        }
        return result;
    }

    public void deserializeNBT(ListTag listTag) {
        this.items.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            this.items.add(ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i)));
        }
    }

    public static List<ItemStack> deserializeNBTS(ListTag listTag) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = 0; i < listTag.size(); ++i) {
            stackList.add(ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i)));
        }
        return stackList;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.items.iterator();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.items.size()) {
            throw new IndexOutOfBoundsException("Slot " + slot + " not in valid range - [0," + this.items.size() + ")");
        }
    }
}

