/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.jei;

import cn.foggyhillside.festival_delicacies.jei.JEIPlugin;
import cn.foggyhillside.festival_delicacies.recipe.StoveRecipe;
import cn.foggyhillside.festival_delicacies.registry.ModBlocks;
import cn.foggyhillside.festival_delicacies.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StoveRecipeCategory
implements IRecipeCategory<StoveRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("festival_delicacies", "stove");
    public static final ResourceLocation TEXTURE = new ResourceLocation("festival_delicacies", "textures/gui/stove_gui_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable type_default;
    private final IDrawable type_steam;
    private final IDrawable type_fry;
    private final IDrawable type_bake;
    private final IDrawable arrow;
    private final IDrawable containerSlot;

    public StoveRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 29, 16, 114, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.STOVE.get()));
        this.type_default = helper.createDrawable(TEXTURE, 176, 17, 19, 17);
        this.type_steam = helper.createDrawable(TEXTURE, 176, 34, 19, 17);
        this.type_fry = helper.createDrawable(TEXTURE, 176, 51, 19, 17);
        this.type_bake = helper.createDrawable(TEXTURE, 176, 68, 19, 17);
        this.arrow = helper.drawableBuilder(TEXTURE, 176, 0, 24, 17).buildAnimated(100, IDrawableAnimated.StartDirection.LEFT, false);
        this.containerSlot = helper.createDrawable(TEXTURE, 199, 0, 18, 18);
    }

    public RecipeType<StoveRecipe> getRecipeType() {
        return JEIPlugin.STOVE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.festival_delicacies.stove");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(StoveRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 60, 19);
        if (recipe.getContainer() == ItemStack.f_41583_) {
            this.containerSlot.draw(guiGraphics, 62, 0);
        }
        if (recipe.getCookingType() == 1) {
            this.type_default.draw(guiGraphics, 62, 36);
        } else if (recipe.getCookingType() == 2) {
            this.type_steam.draw(guiGraphics, 62, 36);
        } else if (recipe.getCookingType() == 3) {
            this.type_fry.draw(guiGraphics, 62, 36);
        } else if (recipe.getCookingType() == 4) {
            this.type_bake.draw(guiGraphics, 62, 36);
        }
    }

    public List<Component> getTooltipStrings(StoveRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (62.0 <= mouseX && mouseX < 81.0 && 36.0 <= mouseY && mouseY < 53.0) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            int type = recipe.getCookingType();
            if (type == 1) {
                tooltip.add((Component)Component.m_237115_((String)"gui.festival_delicacies.stove.button.default"));
            } else if (type == 2) {
                tooltip.add((Component)Component.m_237115_((String)"gui.festival_delicacies.stove.button.steam"));
            } else if (type == 3) {
                tooltip.add((Component)Component.m_237115_((String)"gui.festival_delicacies.stove.button.fry"));
            } else if (type == 4) {
                tooltip.add((Component)Component.m_237115_((String)"gui.festival_delicacies.stove.button.bake"));
            }
            return tooltip;
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StoveRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        if (recipe.m_7527_().size() > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(1)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 37, 1).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(2)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(3)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(4)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 37, 19).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(5)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 37).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(6)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 19, 37).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(7)).m_43908_()));
        }
        if (recipe.m_7527_().size() > 8) {
            builder.addSlot(RecipeIngredientRole.INPUT, 37, 37).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(8)).m_43908_()));
        }
        if (recipe.getContainer() != ItemStack.f_41583_) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 64, 1).addItemStack(recipe.getContainer());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 20).addItemStack(Utils.getResultItem(recipe));
    }
}

