/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.recipe;

import cn.foggyhillside.festival_delicacies.util.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class ChoppingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack input;
    private final NonNullList<ItemStack> results;

    public ChoppingRecipe(ResourceLocation id, ItemStack input, NonNullList<ItemStack> results) {
        this.id = id;
        this.input = input;
        this.results = results;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public NonNullList<ItemStack> getResultsList() {
        NonNullList list = NonNullList.m_122779_();
        this.results.forEach(itemStack -> list.add((Object)itemStack.m_41777_()));
        return list;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return pContainer.m_6643_() == 1 && pContainer.m_8020_(0).m_150930_(this.input.m_41720_());
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return (ItemStack)this.results.get(0);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return (ItemStack)this.results.get(0);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ChoppingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ChoppingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack input = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"), (boolean)true);
            if (input.m_41619_()) {
                throw new JsonParseException("No ingredient for chopping recipe");
            }
            NonNullList<ItemStack> results = Utils.readResults(GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"results"));
            if (results.size() > 3) {
                throw new JsonParseException("Too many results for chopping recipe! The maximum is 3");
            }
            if (results.isEmpty()) {
                throw new JsonParseException("There is no result for chopping recipe!");
            }
            return new ChoppingRecipe(pRecipeId, input, results);
        }

        @Nullable
        public ChoppingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack input = pBuffer.m_130267_();
            int i = pBuffer.readInt();
            NonNullList results = NonNullList.m_122779_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemStack = pBuffer.m_130267_();
                if (itemStack.m_41619_()) continue;
                results.add((Object)itemStack);
            }
            return new ChoppingRecipe(pRecipeId, input, (NonNullList<ItemStack>)results);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ChoppingRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.input);
            int size = pRecipe.results.size();
            pBuffer.writeInt(size);
            for (ItemStack stack : pRecipe.results) {
                pBuffer.m_130055_(stack);
            }
        }
    }

    public static class Type
    implements RecipeType<ChoppingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

