/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.Nullable;

public class DryingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack input;
    private final ItemStack result;

    public DryingRecipe(ResourceLocation id, ItemStack input, ItemStack result) {
        this.id = id;
        this.input = input;
        this.result = result;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return pContainer.m_6643_() == 1 && pContainer.m_8020_(0).m_150930_(this.input.m_41720_());
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<DryingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public DryingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack input = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"), (boolean)true);
            if (input.m_41619_()) {
                throw new JsonParseException("No ingredient for drying recipe");
            }
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"result"), (boolean)true);
            if (result.m_41619_()) {
                throw new JsonParseException("There is no result for drying recipe!");
            }
            return new DryingRecipe(pRecipeId, input, result);
        }

        @Nullable
        public DryingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ItemStack input = pBuffer.m_130267_();
            ItemStack result = pBuffer.m_130267_();
            return new DryingRecipe(pRecipeId, input, result);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, DryingRecipe pRecipe) {
            pBuffer.m_130055_(pRecipe.input);
            pBuffer.m_130055_(pRecipe.result);
        }
    }

    public static class Type
    implements RecipeType<DryingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

