/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.recipe;

import cn.foggyhillside.festival_delicacies.util.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;

public class FermentingRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final ItemStack container;
    private final NonNullList<Ingredient> ingredients;
    private final float experience;
    private final int cookTime;

    public FermentingRecipe(ResourceLocation id, ItemStack output, ItemStack container, NonNullList<Ingredient> ingredients, float experience, int cookTime) {
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
        this.container = container;
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.f_46443_) {
            return false;
        }
        ItemStack inputContainer = pContainer.m_8020_(6);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            ItemStack itemstack = pContainer.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.ingredients.size() && RecipeMatcher.findMatches(inputs, this.ingredients) != null && this.container.m_41720_() == inputContainer.m_41720_();
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<FermentingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public FermentingRecipe fromJson(ResourceLocation location, JsonObject json) {
            NonNullList<Ingredient> ingredients = Utils.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for fermentation recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for fermentation recipe! The max is 6");
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true) : ItemStack.f_41583_;
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            return new FermentingRecipe(location, output, container, ingredients, experience, cookTime);
        }

        @Nullable
        public FermentingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            inputItemsIn.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack output = buffer.m_130267_();
            ItemStack container = buffer.m_130267_();
            float experience = buffer.readFloat();
            int cookTime = buffer.m_130242_();
            return new FermentingRecipe(id, container, output, (NonNullList<Ingredient>)inputItemsIn, experience, cookTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, FermentingRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130055_(recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.m_130130_(recipe.cookTime);
        }
    }

    public static class Type
    implements RecipeType<FermentingRecipe> {
        public static final Type INSTANCE = new Type();
    }
}

