/*
 * Decompiled with CFR 0.152.
 */
package cn.foggyhillside.festival_delicacies.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    @OnlyIn(value=Dist.CLIENT)
    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_8043_(registryAccess);
    }

    public static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < ingredientArray.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static NonNullList<ItemStack> readResults(JsonArray resultArray) {
        NonNullList results = NonNullList.m_122779_();
        for (JsonElement element : resultArray) {
            ItemStack result = CraftingHelper.getItemStack((JsonObject)element.getAsJsonObject(), (boolean)true);
            if (result.m_41619_()) continue;
            results.add((Object)result);
        }
        return results;
    }

    public static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.m_14143_((float)((float)craftedAmount * experience));
        float expFraction = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (expFraction != 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public static boolean checkItem(ForgeConfigSpec.ConfigValue<List<? extends String>> config, ItemStack itemStack) {
        for (String str : (List)config.get()) {
            ResourceLocation id = ResourceLocation.m_135820_((String)str);
            if (id == null) continue;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            return item == itemStack.m_41720_();
        }
        return false;
    }

    public static boolean checkTag(ForgeConfigSpec.ConfigValue<List<? extends String>> config, ItemStack itemStack) {
        for (String str : (List)config.get()) {
            ResourceLocation id = ResourceLocation.m_135820_((String)str);
            if (id == null) continue;
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)id);
            return itemStack.m_204117_(tag);
        }
        return false;
    }

    public static boolean checkItemAndTag(TagKey<Item> itemTag, ForgeConfigSpec.ConfigValue<List<? extends String>> configItem, ForgeConfigSpec.ConfigValue<List<? extends String>> configTag, ItemStack itemStack) {
        ResourceLocation locationItem = null;
        ResourceLocation locationTag = null;
        if (itemStack.m_204117_(itemTag)) {
            return true;
        }
        for (String str : (List)configItem.get()) {
            locationItem = ResourceLocation.m_135820_((String)str);
        }
        for (String str : (List)configTag.get()) {
            locationTag = ResourceLocation.m_135820_((String)str);
        }
        if (locationItem != null) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(locationItem);
            if (item == itemStack.m_41720_()) {
                return true;
            }
            if (locationTag != null) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)locationTag);
                return itemStack.m_204117_(tag);
            }
        }
        return false;
    }

    public static void dropItem(Level level, ItemStack stack, double x, double y, double z, double xMotion, double yMotion, double zMotion) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        entity.m_20334_(xMotion, yMotion, zMotion);
        level.m_7967_((Entity)entity);
    }

    public static List<Item> getItemsByTag(RegistryAccess registryAccess, TagKey<Item> tagKey) {
        try {
            Registry registry = registryAccess.m_175515_(ForgeRegistries.ITEMS.getRegistryKey());
            return ((HolderSet.Named)registry.m_203431_(tagKey).orElseThrow(() -> new IllegalStateException("Tag not found: " + tagKey.f_203868_()))).m_203614_().map(Holder::m_203334_).collect(Collectors.toList());
        }
        catch (IllegalStateException e) {
            return new ArrayList<Item>();
        }
    }
}

