/*
 * Decompiled with CFR 0.152.
 */
package net.ivqrydev.valcon.block.entity;

import net.ivqrydev.valcon.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SoulForgeBlockEntity
extends BlockEntity {
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            SoulForgeBlockEntity.this.setChanged();
            if (!SoulForgeBlockEntity.this.level.isClientSide()) {
                SoulForgeBlockEntity.this.level.sendBlockUpdated(SoulForgeBlockEntity.this.getBlockPos(), SoulForgeBlockEntity.this.getBlockState(), SoulForgeBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private float rotation;

    public SoulForgeBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.SOUL_FORGE_BE.get(), pos, blockState);
    }

    public float getRenderingRotation() {
        this.rotation += 0.35f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }
}

