/*
 * Decompiled with CFR 0.152.
 */
package net.ivqrydev.valcon.block;

import java.util.function.Supplier;
import net.ivqrydev.valcon.block.custom.BastStatueBlock;
import net.ivqrydev.valcon.block.custom.SoulForgeBlock;
import net.ivqrydev.valcon.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"valcon");
    public static final DeferredBlock<Block> SOUL_FORGE = ModBlocks.registerBlock("soul_forge", () -> new SoulForgeBlock(BlockBehaviour.Properties.of().strength(4.5f, 3.0f).requiresCorrectToolForDrops().mapColor(MapColor.COLOR_BLACK).sound(SoundType.NETHERITE_BLOCK).lightLevel(state -> 15)));
    public static final DeferredBlock<Block> BAST_STATUE = ModBlocks.registerBlock("bast_statue", () -> new BastStatueBlock(BlockBehaviour.Properties.of().strength(3.0f, 1024.0f).requiresCorrectToolForDrops().noOcclusion().mapColor(MapColor.SAND).sound(SoundType.STONE)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block, boolean registerItem) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        if (registerItem) {
            ModBlocks.registerBlockItem(name, toReturn);
        }
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

