/*
 * Decompiled with CFR 0.152.
 */
package net.ivqrydev.valcon.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.ivqrydev.valcon.block.entity.SoulForgeBlockEntity;
import net.ivqrydev.valcon.item.ModItems;
import net.ivqrydev.valcon.sound.ModSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class SoulForgeBlock
extends BaseEntityBlock {
    public static final MapCodec<SoulForgeBlock> CODEC = SoulForgeBlock.simpleCodec(SoulForgeBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public SoulForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (!state.hasProperty((Property)FACING)) {
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Rotation rotation = mirror.getRotation(facing);
        return this.rotate(state, rotation);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SoulForgeBlockEntity(blockPos, blockState);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof SoulForgeBlockEntity) {
            SoulForgeBlockEntity soulForgeBlockEntity = (SoulForgeBlockEntity)blockEntity;
            soulForgeBlockEntity.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SoulForgeBlockEntity) {
            ItemStack ingotStack;
            SoulForgeBlockEntity soulForgeBlockEntity = (SoulForgeBlockEntity)blockEntity;
            ItemStack stored = soulForgeBlockEntity.inventory.getStackInSlot(0);
            if (stored.isEmpty() && !stack.isEmpty()) {
                if (stack.isDamageableItem()) {
                    soulForgeBlockEntity.inventory.insertItem(0, stack.copy(), false);
                    stack.shrink(1);
                    level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.valcon.soul_forge.tooltip.unworthy"), true);
                }
            } else if (stack.isEmpty()) {
                ItemStack extracted = soulForgeBlockEntity.inventory.extractItem(0, 1, false);
                if (!extracted.isEmpty()) {
                    player.setItemInHand(hand, extracted);
                    soulForgeBlockEntity.clearContents();
                    level.playSound(player, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else if (!stored.isEmpty() && !stack.isEmpty() && (ingotStack = stack).getItem() == ModItems.SOUL_STEEL_INGOT.get()) {
                if (stored.isDamageableItem()) {
                    stored.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                    soulForgeBlockEntity.inventory.setStackInSlot(0, stored);
                    ingotStack.shrink(1);
                    level.playSound(player, pos, ModSounds.SOUL_FORGE_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.valcon.soul_forge.tooltip.success"), true);
                    for (int i = 0; i < 20; ++i) {
                        double offsetX = level.random.nextGaussian() * 0.1;
                        double offsetY = level.random.nextDouble() * 0.1;
                        double offsetZ = level.random.nextGaussian() * 0.1;
                        double x = (double)pos.getX() + 0.5;
                        double y = pos.getY() + 1;
                        double z = (double)pos.getZ() + 0.5;
                        level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, y, z, offsetX, offsetY, offsetZ);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"tooltip.valcon.soul_forge.tooltip.unworthy"), true);
                }
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.valcon.soul_forge.tooltip.description").withStyle(ChatFormatting.GRAY));
    }
}

