/*
 * Decompiled with CFR 0.152.
 */
package net.ivqrydev.valcon.sound;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModSounds {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"valcon");
    public static final Supplier<SoundEvent> SOUL_FORGE_USE = ModSounds.registerSoundEvent("soul_forge_use");
    public static final Supplier<SoundEvent> STAR_TAKER = ModSounds.registerSoundEvent("star_taker");
    public static final ResourceKey<JukeboxSong> STAR_TAKER_KEY = ModSounds.createSong("star_taker");
    public static final Supplier<SoundEvent> DEVIL_TRIGGER = ModSounds.registerSoundEvent("devil_trigger");
    public static final ResourceKey<JukeboxSong> DEVIL_TRIGGER_KEY = ModSounds.createSong("devil_trigger");

    private static Supplier<SoundEvent> registerSoundEvent(String name) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"valcon", (String)name);
        return SOUND_EVENTS.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
    }

    private static ResourceKey<JukeboxSong> createSong(String name) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"valcon", (String)name));
    }

    public static void register(IEventBus eventBus) {
        SOUND_EVENTS.register(eventBus);
    }
}

