/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.blockentity.NightSporeBlockEntity;
import com.belgie.creaking_expanded.registry.BlockEntityRegistry;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.ParticleRegistry;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NightSporeBlock
extends BaseEntityBlock {
    public static final MapCodec<NightSporeBlock> CODEC = NightSporeBlock.simpleCodec(NightSporeBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape FLIPPED_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    private static final int ADD_PARTICLE_ATTEMPTS = 14;
    private static final int PARTICLE_XZ_RADIUS = 10;
    private static final int PARTICLE_Y_MAX = 10;
    public static BooleanProperty BLOOMING = BlockStateProperties.BLOOM;
    public static BooleanProperty HANGING = BlockStateProperties.HANGING;

    public MapCodec<NightSporeBlock> codec() {
        return CODEC;
    }

    public NightSporeBlock(BlockBehaviour.Properties p_154697_) {
        super(p_154697_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)blockstate.setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(context.getLevel().isMoonVisible()));
        }
        return null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NightSporeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return NightSporeBlock.createTickerHelper(blockEntityType, BlockEntityRegistry.NIGHT_SPORE.get(), NightSporeBlockEntity::tick);
    }

    protected boolean propagatesSkylightDown(BlockState p_380235_) {
        return true;
    }

    protected boolean canSurvive(BlockState p_380096_, LevelReader p_379969_, BlockPos p_380283_) {
        return this.canStayAtPosition((BlockGetter)p_379969_, p_380283_);
    }

    private boolean canStayAtPosition(BlockGetter p_379546_, BlockPos p_379355_) {
        BlockState blockstate1;
        BlockPos blockpos = p_379355_.relative(Direction.UP);
        BlockState blockstate = p_379546_.getBlockState(blockpos);
        BlockPos blockpos1 = p_379355_.relative(Direction.DOWN);
        return MultifaceBlock.canAttachTo((BlockGetter)p_379546_, (Direction)Direction.DOWN, (BlockPos)blockpos1, (BlockState)(blockstate1 = p_379546_.getBlockState(blockpos1))) || MultifaceBlock.canAttachTo((BlockGetter)p_379546_, (Direction)Direction.UP, (BlockPos)blockpos, (BlockState)blockstate);
    }

    protected BlockState updateShape(BlockState p_380182_, LevelReader p_380219_, ScheduledTickAccess p_380011_, BlockPos p_380024_, Direction p_380101_, BlockPos p_380258_, BlockState p_379654_, RandomSource p_379547_) {
        if (!this.canStayAtPosition((BlockGetter)p_380219_, p_380024_)) {
            p_380011_.scheduleTick(p_380024_, (Block)this, 1);
        }
        return p_380182_;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? SHAPE : FLIPPED_SHAPE;
    }

    protected void tick(BlockState p_381085_, ServerLevel p_381014_, BlockPos p_381010_, RandomSource p_380962_) {
        this.tryChangingState(p_381085_, p_381014_, p_381010_, p_380962_);
        if (!this.canStayAtPosition((BlockGetter)p_381014_, p_381010_)) {
            p_381014_.destroyBlock(p_381010_, true);
        }
    }

    protected void randomTick(BlockState p_382824_, ServerLevel p_382831_, BlockPos p_382957_, RandomSource p_382888_) {
        this.tryChangingState(p_382824_, p_382831_, p_382957_, p_382888_);
        super.randomTick(p_382824_, p_382831_, p_382957_, p_382888_);
    }

    private void tryChangingState(BlockState p_383235_, ServerLevel p_383091_, BlockPos p_383073_, RandomSource p_383038_) {
        p_383091_.setBlock(p_383073_, !p_383091_.isMoonVisible() ? (BlockState)((BlockState)((Block)BlockRegistry.NIGHTBLOSSOM.get()).defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(true))).setValue((Property)HANGING, (Comparable)((Boolean)p_383235_.getValue((Property)HANGING))) : (BlockState)((BlockState)((Block)BlockRegistry.NIGHTBLOSSOM.get()).defaultBlockState().setValue((Property)BLOOMING, (Comparable)Boolean.valueOf(false))).setValue((Property)HANGING, (Comparable)((Boolean)p_383235_.getValue((Property)HANGING))), 3);
        p_383091_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_383073_, GameEvent.Context.of((BlockState)p_383235_));
        BlockPos.betweenClosed((BlockPos)p_383073_.offset(-3, -2, -3), (BlockPos)p_383073_.offset(3, 2, 3)).forEach(p_383198_ -> {
            BlockState blockstate = p_383091_.getBlockState(p_383198_);
            if (blockstate == p_383235_) {
                double d0 = Math.sqrt(p_383073_.distSqr((Vec3i)p_383198_));
                int i = p_383038_.nextIntBetweenInclusive((int)(d0 * 5.0), (int)(d0 * 10.0));
                p_383091_.scheduleTick(p_383198_, p_383235_.getBlock(), i);
            }
        });
    }

    public void animateTick(BlockState p_222503_, Level p_222504_, BlockPos p_222505_, RandomSource p_222506_) {
        BlockState blockstate;
        int i = p_222505_.getX();
        int j = p_222505_.getY();
        int k = p_222505_.getZ();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        if (((Boolean)p_222503_.getValue((Property)BLOOMING)).booleanValue() && !((Boolean)p_222503_.getValue((Property)HANGING)).booleanValue()) {
            for (int l = 0; l < 2; ++l) {
                blockpos$mutableblockpos.set(i + Mth.nextInt((RandomSource)p_222506_, (int)-10, (int)10), j - p_222506_.nextInt(10), k + Mth.nextInt((RandomSource)p_222506_, (int)-10, (int)10));
                BlockState blockstate2 = p_222504_.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (blockstate2.isCollisionShapeFullBlock((BlockGetter)p_222504_, (BlockPos)blockpos$mutableblockpos)) continue;
                if (p_222504_.getBlockState(p_222505_.below()).is(Blocks.GRASS_BLOCK) || p_222504_.getBlockState(p_222505_.below()).is(Blocks.PALE_MOSS_BLOCK)) {
                    p_222504_.addParticle((ParticleOptions)ParticleRegistry.CREAKING_EYES.get(), (double)blockpos$mutableblockpos.getX() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getY() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getZ() + p_222506_.nextDouble(), 0.0, 0.0, 0.0);
                    continue;
                }
                if (p_222504_.getBlockState(p_222505_.below()).is(Blocks.PALE_OAK_LEAVES)) {
                    p_222504_.addParticle((ParticleOptions)ParticleRegistry.PALE_MOTH.get(), (double)blockpos$mutableblockpos.getX() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getY() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getZ() + p_222506_.nextDouble(), 0.0, 0.0, 0.0);
                    continue;
                }
                if (!p_222504_.getBlockState(p_222505_.below()).is(Blocks.RESIN_BLOCK)) continue;
                p_222504_.addParticle((ParticleOptions)ParticleRegistry.RESIN_MOTH.get(), (double)blockpos$mutableblockpos.getX() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getY() + p_222506_.nextDouble(), (double)blockpos$mutableblockpos.getZ() + p_222506_.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
        if (p_222506_.nextInt(500) == 0 && ((blockstate = p_222504_.getBlockState(p_222505_.above())).is(BlockTags.PALE_OAK_LOGS) || blockstate.is(Blocks.PALE_OAK_LEAVES))) {
            p_222504_.playLocalSound((double)p_222505_.getX(), (double)p_222505_.getY(), (double)p_222505_.getZ(), SoundEvents.PALE_HANGING_MOSS_IDLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BLOOMING, HANGING});
    }
}

