/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.ItemRegistry;
import com.belgie.creaking_expanded.util.CustomBucketable;
import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class SpritelingEntity
extends PathfinderMob
implements CustomBucketable {
    private static final EntityDataAccessor<Boolean> CAN_MOVE;
    private static final EntityDataAccessor<Boolean> HAS_FOOD;
    private static final EntityDataAccessor<Boolean> HAS_WATER;
    private static final EntityDataAccessor<Integer> STAGE;
    private static final EntityDataAccessor<Integer> DELAY_TO_STAGE;
    private static final EntityDataAccessor<Boolean> READY_TO_STAGE;
    @VisibleForTesting
    public static int ticksToBeFrog;
    private int age;
    private int StageDelay;

    public SpritelingEntity(EntityType<? extends SpritelingEntity> p_380212_, Level p_379294_) {
        super(p_380212_, p_379294_);
        this.lookControl = new CreakingLookControl(this);
        this.moveControl = new CreakingMoveControl(this);
        this.jumpControl = new CreakingJumpControl(this);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.getNavigation();
        groundpathnavigation.setCanFloat(true);
        this.xpReward = 0;
    }

    protected BodyRotationControl createBodyControl() {
        return new CreakingBodyRotationControl(this);
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        p_379982_.define(CAN_MOVE, (Object)false);
        p_379982_.define(HAS_WATER, (Object)true);
        p_379982_.define(HAS_FOOD, (Object)true);
        p_379982_.define(STAGE, (Object)0);
        p_379982_.define(READY_TO_STAGE, (Object)false);
        p_379982_.define(DELAY_TO_STAGE, (Object)-1);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.4f).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0625);
    }

    public boolean canMove() {
        return (Boolean)this.entityData.get(CAN_MOVE);
    }

    public boolean hasFood() {
        return (Boolean)this.entityData.get(HAS_FOOD);
    }

    public boolean hasWater() {
        return (Boolean)this.entityData.get(HAS_WATER);
    }

    public void sethasWater(boolean water) {
        this.entityData.set(HAS_WATER, (Object)water);
    }

    public boolean isReadyToStage() {
        return (Boolean)this.entityData.get(READY_TO_STAGE);
    }

    public void setReadyToStage(boolean water) {
        this.entityData.set(READY_TO_STAGE, (Object)water);
    }

    public boolean WantsToLevelUp() {
        return this.age == 6000 || this.age == 12000 || this.age == 18000;
    }

    public void tick() {
        if (this.WantsToLevelUp()) {
            this.sethasWater(false);
            this.sethasFood(false);
            this.setAge(this.getAge() + 1);
            this.setReadyToStage(true);
        }
        if (this.isReadyToStage() && this.hasWater() && this.hasFood() && this.getDelayStage() == 0) {
            this.setDelayStage(1);
        }
        if (this.getDelayStage() != 0) {
            this.setDelayStage(this.getDelayStage() + 1);
        }
        if (this.getDelayStage() == 250) {
            this.setStage(this.getStage() + 1);
            this.setReadyToStage(false);
            this.setDelayStage(0);
        }
        super.tick();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is((Item)ItemRegistry.DAWN_BERRIES.get()) && !this.hasFood()) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.sethasFood(true);
            this.level().playSound((Entity)player, (Entity)this, (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.is(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER).getItem()) && !this.hasWater()) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.sethasWater(true);
            this.level().playSound((Entity)player, (Entity)this, (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return CustomBucketable.bucketMobPickup(player, hand, this).orElse(super.mobInteract(player, hand));
    }

    public void sethasFood(boolean water) {
        this.entityData.set(HAS_FOOD, (Object)water);
    }

    public void setStage(int water) {
        this.entityData.set(STAGE, (Object)water);
    }

    public int getStage() {
        return (Integer)this.entityData.get(STAGE);
    }

    public void setDelayStage(int water) {
        this.entityData.set(DELAY_TO_STAGE, (Object)water);
    }

    public int getDelayStage() {
        return (Integer)this.entityData.get(DELAY_TO_STAGE);
    }

    public boolean isPushable() {
        return false;
    }

    public void push(double p_388562_, double p_388936_, double p_387604_) {
        if (this.canMove()) {
            super.push(p_388562_, p_388936_, p_387604_);
        }
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean canBeNameTagged() {
        return false;
    }

    protected boolean canAddPassenger(Entity p_389469_) {
        return false;
    }

    protected boolean couldAcceptPassenger() {
        return false;
    }

    protected void addPassenger(Entity p_389484_) {
        throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
    }

    public boolean canUsePortal(boolean p_389552_) {
        return false;
    }

    public void knockback(double p_379489_, double p_380324_, double p_379735_) {
        if (this.canMove()) {
            super.knockback(p_379489_, p_380324_, p_379735_);
        }
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("HasFood", this.hasFood());
        compound.putBoolean("HasWater", this.hasWater());
        compound.putInt("Age", this.age);
        compound.putInt("Stage", this.getStage());
        compound.putBoolean("ReadyToStage", this.isReadyToStage());
        compound.putInt("StageDelay", this.getDelayStage());
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isBaby() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_363316_, @Nullable SpawnGroupData p_146749_) {
        return super.finalizeSpawn(p_146746_, p_146747_, p_363316_, p_146749_);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.hasFood() && this.hasWater()) {
            this.setAge(this.age + 1);
        }
    }

    @Override
    public boolean fromBucket() {
        return true;
    }

    @Override
    public void setFromBucket(boolean fromBucket) {
    }

    @Override
    public void saveToBucketTag(ItemStack stack) {
        CustomBucketable.saveDefaultDataToBucketTag((Mob)this, stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, p_331788_ -> {
            p_331788_.putInt("Age", this.getAge());
            p_331788_.putInt("Stage", this.getStage());
            p_331788_.putBoolean("ReadyToStage", this.isReadyToStage());
            p_331788_.putInt("StageDelay", this.getDelayStage());
        });
    }

    @Override
    public void loadFromBucketTag(CompoundTag tag) {
        CustomBucketable.loadDefaultDataFromBucketTag((Mob)this, tag);
        if (tag.contains("Age")) {
            this.setAge(tag.getIntOr("Age", 0));
        }
        if (tag.contains("Stage")) {
            this.setStage(tag.getIntOr("Stage", 0));
        }
        if (tag.contains("ReadyToStage")) {
            this.setReadyToStage(tag.getBooleanOr("ReadyToStage", false));
        }
        if (tag.contains("StageDelay")) {
            this.setDelayStage(tag.getIntOr("StageDelay", 0));
        }
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)ItemRegistry.SPRITELING_BUCKET.get());
    }

    @Override
    public SoundEvent getPickupSound() {
        return SoundEvents.AZALEA_LEAVES_BREAK;
    }

    private int getAge() {
        return this.age;
    }

    private void ageUp(int offset) {
        this.setAge(this.age + offset * 20);
    }

    private void setAge(int age) {
        this.age = age;
        if (this.age >= ticksToBeFrog) {
            this.ageUp();
        }
    }

    private void ageUp() {
        Level var2;
        if (ForgeEventFactory.canLivingConvert((LivingEntity)this, EntityRegistry.ANCIENT_SPRITE.get(), timer -> {}) && (var2 = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var2;
            this.convertTo(EntityRegistry.ANCIENT_SPRITE.get(), ConversionParams.single((Mob)this, (boolean)false, (boolean)false), p_390228_ -> {
                ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)p_390228_);
                p_390228_.finalizeSpawn((ServerLevelAccessor)serverlevel, this.level().getCurrentDifficultyAt(p_390228_.blockPosition()), EntitySpawnReason.CONVERSION, null);
                p_390228_.setPersistenceRequired();
                p_390228_.fudgePositionAfterSizeChange(this.getDimensions(this.getPose()));
                this.playSound(SoundEvents.TADPOLE_GROW_UP, 0.15f, 1.0f);
            });
        }
    }

    public void readAdditionalSaveData(ValueInput compound) {
        this.sethasFood(compound.getBooleanOr("HasFood", false));
        this.sethasWater(compound.getBooleanOr("HasWater", false));
        this.setAge(compound.getIntOr("Age", 0));
        this.setStage(compound.getIntOr("Stage", 0));
        this.setReadyToStage(compound.getBooleanOr("ReadyToStage", false));
        this.setDelayStage(compound.getIntOr("StageDelay", 0));
        super.readAdditionalSaveData(compound);
    }

    public float getWalkTargetValue(BlockPos p_379756_, LevelReader p_380102_) {
        return 0.0f;
    }

    static {
        ticksToBeFrog = Math.abs(-24000);
        CAN_MOVE = SynchedEntityData.defineId(SpritelingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        HAS_FOOD = SynchedEntityData.defineId(SpritelingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        HAS_WATER = SynchedEntityData.defineId(SpritelingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        STAGE = SynchedEntityData.defineId(SpritelingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        READY_TO_STAGE = SynchedEntityData.defineId(SpritelingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DELAY_TO_STAGE = SynchedEntityData.defineId(SpritelingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    class CreakingLookControl
    extends LookControl {
        public CreakingLookControl(SpritelingEntity p_379883_) {
            super((Mob)p_379883_);
        }

        public void tick() {
            if (SpritelingEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingMoveControl
    extends MoveControl {
        public CreakingMoveControl(SpritelingEntity p_380148_) {
            super((Mob)p_380148_);
        }

        public void tick() {
            if (SpritelingEntity.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingJumpControl
    extends JumpControl {
        public CreakingJumpControl(SpritelingEntity p_379900_) {
            super((Mob)p_379900_);
        }

        public void tick() {
            if (SpritelingEntity.this.canMove()) {
                super.tick();
            } else {
                SpritelingEntity.this.setJumping(false);
            }
        }
    }

    class CreakingBodyRotationControl
    extends BodyRotationControl {
        public CreakingBodyRotationControl(SpritelingEntity p_380382_) {
            super((Mob)p_380382_);
        }

        public void clientTick() {
            if (SpritelingEntity.this.canMove()) {
                super.clientTick();
            }
        }
    }

    public static enum State implements StringRepresentable
    {
        IDLING(0),
        SLEEPING(1),
        EATING(2),
        WAKE_UP(3);

        public static final StringRepresentable.EnumCodec<State> CODEC;
        public static final IntFunction<State> BY_ID;
        public static final StreamCodec<ByteBuf, State> STREAM_CODEC;
        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        static State byName(String p_364149_) {
            return (State)CODEC.byName(p_364149_, (Enum)IDLING);
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(State::values);
            BY_ID = ByIdMap.continuous(State::id, (Object[])State.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, State::id);
        }
    }
}

