/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.items;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class CustomBucketItem
extends Item
implements DispensibleContainerItem {
    public final Fluid content;

    public CustomBucketItem(Fluid content, Item.Properties properties) {
        super(properties);
        this.content = content;
    }

    public InteractionResult use(Level p_40703_, Player p_40704_, InteractionHand p_40705_) {
        ItemStack itemstack = p_40704_.getItemInHand(p_40705_);
        BlockHitResult blockhitresult = CustomBucketItem.getPlayerPOVHitResult((Level)p_40703_, (Player)p_40704_, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (!p_40703_.mayInteract((Entity)p_40704_, blockpos) || !p_40704_.mayUseItemAt(blockpos1, direction, itemstack)) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = p_40703_.getBlockState(blockpos);
        BlockPos blockpos2 = this.canBlockContainFluid(p_40704_, p_40703_, blockpos, blockstate) ? blockpos : blockpos1;
        this.checkExtraContent((LivingEntity)p_40704_, p_40703_, itemstack, blockpos2);
        if (p_40704_ instanceof ServerPlayer) {
            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)p_40704_, blockpos2, itemstack);
        }
        p_40704_.awardStat(Stats.ITEM_USED.get((Object)this));
        ItemStack itemstack1 = ItemUtils.createFilledResult((ItemStack)itemstack, (Player)p_40704_, (ItemStack)CustomBucketItem.getEmptySuccessItem(itemstack, p_40704_));
        return InteractionResult.SUCCESS.heldItemTransformedTo(itemstack1);
    }

    public static ItemStack getEmptySuccessItem(ItemStack bucketStack, Player player) {
        return !player.hasInfiniteMaterials() ? new ItemStack((ItemLike)Items.BUCKET) : bucketStack;
    }

    public boolean emptyContents(@Nullable LivingEntity livingEntity, Level level, BlockPos blockPos, @Nullable BlockHitResult blockHitResult) {
        return this.emptyContents((Player)livingEntity, level, blockPos, blockHitResult, null);
    }

    public boolean emptyContents(@javax.annotation.Nullable Player player, Level level, BlockPos pos, @javax.annotation.Nullable BlockHitResult result, @javax.annotation.Nullable ItemStack container) {
        LiquidBlockContainer liquidblockcontainer1;
        boolean flag2;
        Fluid fluid = this.content;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid flowingfluid = (FlowingFluid)fluid;
        BlockState blockstate = level.getBlockState(pos);
        Block $$7 = blockstate.getBlock();
        boolean $$8 = blockstate.canBeReplaced(this.content);
        boolean flag1 = flag2 = true;
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!flag1) {
            return result != null && this.emptyContents(player, level, result.getBlockPos().relative(result.getDirection()), null, container);
        }
        if (containedFluidStack.isPresent() && this.content.getFluidType().isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            this.content.getFluidType().onVaporize((LivingEntity)player, level, pos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (level.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int l = pos.getX();
            int i = pos.getY();
            int j = pos.getZ();
            level.playSound((Entity)player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if ($$7 instanceof LiquidBlockContainer && (liquidblockcontainer1 = (LiquidBlockContainer)$$7).canPlaceLiquid((LivingEntity)player, (BlockGetter)level, pos, blockstate, this.content)) {
            liquidblockcontainer1.placeLiquid((LevelAccessor)level, pos, blockstate, flowingfluid.getSource(false));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.isClientSide() && $$8 && !blockstate.liquid()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, this.content.defaultFluidState().createLegacyBlock(), 11) && !blockstate.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    protected void playEmptySound(@javax.annotation.Nullable Player player, LevelAccessor level, BlockPos pos) {
        SoundEvent soundevent;
        SoundEvent soundEvent = soundevent = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        if (soundevent == null) {
            soundevent = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        level.playSound((Entity)player, pos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, pos);
    }

    protected boolean canBlockContainFluid(@javax.annotation.Nullable Player player, Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.getBlock() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.getBlock()).canPlaceLiquid((LivingEntity)player, (BlockGetter)worldIn, posIn, blockstate, this.content);
    }
}

