/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.variants;

import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.CreakingGuardVariant;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;

public class PaleEyeVariant {
    public static final Codec<PaleEyeVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.Texture), (App)ResourceLocation.CODEC.fieldOf("eye_texture").forGetter(p_335261_ -> p_335261_.EyeTexture), (App)ResourceLocation.CODEC.fieldOf("beam_texture").forGetter(p_335261_ -> p_335261_.BeamTexture), (App)Codec.BOOL.fieldOf("takes_damage_when_closed").forGetter(p_335263_ -> p_335263_.TakesDamageWhenClosed), (App)Codec.BOOL.fieldOf("opens_at_day").forGetter(p_335263_ -> p_335263_.OpensAtDay), (App)Codec.BOOL.fieldOf("can_teleport").forGetter(p_335263_ -> p_335263_.CanTeleport)).apply((Applicative)p_332779_, PaleEyeVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaleEyeVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PaleEyeVariant::Texture, (StreamCodec)ResourceLocation.STREAM_CODEC, PaleEyeVariant::EyeTexture, (StreamCodec)ResourceLocation.STREAM_CODEC, PaleEyeVariant::BeamTexture, (StreamCodec)ByteBufCodecs.BOOL, PaleEyeVariant::TakesDamageWhenClosed, (StreamCodec)ByteBufCodecs.BOOL, PaleEyeVariant::OpensAtDay, (StreamCodec)ByteBufCodecs.BOOL, PaleEyeVariant::CanTeleport, PaleEyeVariant::new);
    public static final Codec<Holder<PaleEyeVariant>> CODEC = RegistryFileCodec.create(VariantsRegistry.PALE_EYE_VARIANT_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PaleEyeVariant>> STREAM_CODEC = ByteBufCodecs.holder(VariantsRegistry.PALE_EYE_VARIANT_REGISTRY_KEY, DIRECT_STREAM_CODEC);
    public final ResourceLocation Texture;
    public final ResourceLocation EyeTexture;
    public final ResourceLocation BeamTexture;
    public final boolean TakesDamageWhenClosed;
    public final boolean OpensAtDay;
    public final boolean CanTeleport;
    public final ResourceLocation TextureFull;
    public final ResourceLocation EyeTextureFull;
    public final ResourceLocation BeamTextureFull;

    public PaleEyeVariant(ResourceLocation texture, ResourceLocation eyetexture, ResourceLocation beamtexture, boolean TakesDamageWhenClosed, boolean OpensAtDay, boolean CanTeleport) {
        this.Texture = texture;
        this.TextureFull = PaleEyeVariant.fullTextureId(texture);
        this.EyeTexture = eyetexture;
        this.EyeTextureFull = PaleEyeVariant.fullTextureId(eyetexture);
        this.BeamTexture = beamtexture;
        this.BeamTextureFull = PaleEyeVariant.fullTextureId(beamtexture);
        this.TakesDamageWhenClosed = TakesDamageWhenClosed;
        this.CanTeleport = CanTeleport;
        this.OpensAtDay = OpensAtDay;
    }

    public static ResourceLocation fullTextureId(ResourceLocation texture) {
        return texture.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public ResourceLocation Texture() {
        return this.TextureFull;
    }

    public ResourceLocation EyeTexture() {
        return this.EyeTextureFull;
    }

    public ResourceLocation BeamTexture() {
        return this.BeamTextureFull;
    }

    public boolean TakesDamageWhenClosed() {
        return this.TakesDamageWhenClosed;
    }

    public boolean CanTeleport() {
        return this.CanTeleport;
    }

    public boolean OpensAtDay() {
        return this.OpensAtDay;
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (other == this) {
            return true;
        }
        if (other instanceof CreakingGuardVariant) {
            CreakingGuardVariant CreakingVariant = (CreakingGuardVariant)other;
            var10000 = Objects.equals(this.Texture, CreakingVariant.Texture);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.Texture.hashCode();
        return i;
    }
}

