/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.variants;

import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;

public class PaleSpiderVariant {
    public static final Codec<PaleSpiderVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.Texture), (App)ResourceLocation.CODEC.fieldOf("eye_texture").forGetter(p_335261_ -> p_335261_.EyeTexture), (App)ResourceLocation.CODEC.fieldOf("core_texture").forGetter(p_335261_ -> p_335261_.CoreTexture), (App)Codec.BOOL.fieldOf("attacks_near_creakings").forGetter(p_335263_ -> p_335263_.item)).apply((Applicative)p_332779_, PaleSpiderVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaleSpiderVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PaleSpiderVariant::Texture, (StreamCodec)ResourceLocation.STREAM_CODEC, PaleSpiderVariant::EyeTexture, (StreamCodec)ResourceLocation.STREAM_CODEC, PaleSpiderVariant::CoreTexture, (StreamCodec)ByteBufCodecs.BOOL, PaleSpiderVariant::Item, PaleSpiderVariant::new);
    public static final Codec<Holder<PaleSpiderVariant>> CODEC = RegistryFileCodec.create(VariantsRegistry.PALE_SPIDER_VARIANT_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PaleSpiderVariant>> STREAM_CODEC = ByteBufCodecs.holder(VariantsRegistry.PALE_SPIDER_VARIANT_REGISTRY_KEY, DIRECT_STREAM_CODEC);
    public final ResourceLocation Texture;
    public final boolean item;
    public final ResourceLocation TextureFull;
    public final ResourceLocation EyeTexture;
    public final ResourceLocation EyeTextureFull;
    public final ResourceLocation CoreTexture;
    public final ResourceLocation CoreTextureFull;

    public PaleSpiderVariant(ResourceLocation texture, ResourceLocation eyetexture, ResourceLocation coretexture, boolean item) {
        this.Texture = texture;
        this.TextureFull = PaleSpiderVariant.fullTextureId(texture);
        this.EyeTexture = eyetexture;
        this.EyeTextureFull = PaleSpiderVariant.fullTextureId(eyetexture);
        this.CoreTexture = coretexture;
        this.CoreTextureFull = PaleSpiderVariant.fullTextureId(coretexture);
        this.item = item;
    }

    public static ResourceLocation fullTextureId(ResourceLocation texture) {
        return texture.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public ResourceLocation Texture() {
        return this.TextureFull;
    }

    public ResourceLocation EyeTexture() {
        return this.EyeTextureFull;
    }

    public ResourceLocation CoreTexture() {
        return this.CoreTextureFull;
    }

    public boolean Item() {
        return this.item;
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (other == this) {
            return true;
        }
        if (other instanceof PaleSpiderVariant) {
            PaleSpiderVariant CreakingVariant = (PaleSpiderVariant)other;
            var10000 = Objects.equals(this.Texture, CreakingVariant.Texture) && Objects.equals(this.item, CreakingVariant.item);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.Texture.hashCode();
        return i;
    }
}

