/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.AI;

import com.belgie.creaking_expanded.entity.renderstate.AncientSpriteRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.LivingEntityEmissiveLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AncientSpriteEmissiveLayer<S extends AncientSpriteRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final LivingEntityEmissiveLayer.AlphaFunction<S> alphaFunction;
    private final LivingEntityEmissiveLayer.DrawSelector<S, M> drawSelector;
    private final Function<ResourceLocation, RenderType> bufferProvider;
    private final boolean alwaysVisible;

    public AncientSpriteEmissiveLayer(RenderLayerParent<S, M> p_379642_, LivingEntityEmissiveLayer.AlphaFunction<S> p_380124_, LivingEntityEmissiveLayer.DrawSelector<S, M> p_379846_, Function<ResourceLocation, RenderType> p_380046_, boolean p_388482_) {
        super(p_379642_);
        this.alphaFunction = p_380124_;
        this.drawSelector = p_379846_;
        this.bufferProvider = p_380046_;
        this.alwaysVisible = p_388482_;
    }

    public void render(PoseStack p_380055_, MultiBufferSource p_379364_, int p_380349_, S p_379499_, float p_379823_, float p_380346_) {
        if ((!((AncientSpriteRenderState)((Object)p_379499_)).isInvisible || this.alwaysVisible) && this.onlyDrawSelectedParts(p_379499_)) {
            VertexConsumer vertexconsumer = p_379364_.getBuffer(this.bufferProvider.apply(((AncientSpriteRenderState)((Object)p_379499_)).eye_texture));
            float f = this.alphaFunction.apply(p_379499_, ((AncientSpriteRenderState)((Object)p_379499_)).ageInTicks);
            int i = ARGB.color((int)Mth.floor((float)(f * 255.0f)), (int)255, (int)255, (int)255);
            this.getParentModel().renderToBuffer(p_380055_, vertexconsumer, p_380349_, LivingEntityRenderer.getOverlayCoords(p_379499_, (float)0.0f), i);
            this.resetDrawForAllParts();
        }
    }

    private boolean onlyDrawSelectedParts(S p_379774_) {
        List list = this.drawSelector.getPartsToDraw(this.getParentModel(), p_379774_);
        if (list.isEmpty()) {
            return false;
        }
        this.getParentModel().allParts().forEach(p_379465_ -> {
            p_379465_.skipDraw = true;
        });
        list.forEach(p_379767_ -> {
            p_379767_.skipDraw = false;
        });
        return true;
    }

    private void resetDrawForAllParts() {
        this.getParentModel().allParts().forEach(p_379339_ -> {
            p_379339_.skipDraw = false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface DrawSelector<S extends LivingEntityRenderState, M extends EntityModel<S>> {
        public List<ModelPart> getPartsToDraw(M var1, S var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AlphaFunction<S extends LivingEntityRenderState> {
        public float apply(S var1, float var2);
    }
}

