/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity.model;

import com.belgie.creaking_expanded.entity.renderstate.PaleCreeperRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaleCreeperModel
extends EntityModel<PaleCreeperRenderState> {
    private final ModelPart head;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public PaleCreeperModel(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.leftHindLeg = root.getChild("right_hind_leg");
        this.rightHindLeg = root.getChild("left_hind_leg");
        this.leftFrontLeg = root.getChild("right_front_leg");
        this.rightFrontLeg = root.getChild("left_front_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, cubeDeformation);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-2.0f, (float)18.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)2.0f, (float)18.0f, (float)4.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-2.0f, (float)18.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)2.0f, (float)18.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(PaleCreeperRenderState p_361457_) {
        super.setupAnim((EntityRenderState)p_361457_);
        this.head.yRot = p_361457_.yRot * ((float)Math.PI / 180);
        this.head.xRot = p_361457_.xRot * ((float)Math.PI / 180);
        float f = p_361457_.walkAnimationSpeed;
        float f1 = p_361457_.walkAnimationPos;
        this.rightHindLeg.xRot = Mth.cos((float)(f1 * 0.6662f)) * 1.4f * f;
        this.leftHindLeg.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 1.4f * f;
        this.rightFrontLeg.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 1.4f * f;
        this.leftFrontLeg.xRot = Mth.cos((float)(f1 * 0.6662f)) * 1.4f * f;
    }
}

