/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.variants;

import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.CreakingGuardVariant;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class PaleCreeperVariant {
    public static final Codec<PaleCreeperVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.Texture), (App)ResourceLocation.CODEC.fieldOf("charged_texture").forGetter(p_335261_ -> p_335261_.PowerTexture), (App)MobEffect.CODEC.fieldOf("non_safe_biome_effect").forGetter(p_335263_ -> p_335263_.effect), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("placed_feature").forGetter(p_335263_ -> p_335263_.feature), (App)ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("safe_biome").forGetter(p_335263_ -> p_335263_.biome), (App)ExtraCodecs.POSITIVE_INT.fieldOf("particle_colour").forGetter(p_335263_ -> p_335263_.particle)).apply((Applicative)p_332779_, PaleCreeperVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PaleCreeperVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, PaleCreeperVariant::Texture, (StreamCodec)ResourceLocation.STREAM_CODEC, PaleCreeperVariant::PowerTexture, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), PaleCreeperVariant::Effect, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.CONFIGURED_FEATURE), PaleCreeperVariant::Feature, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BIOME), PaleCreeperVariant::Biome, (StreamCodec)ByteBufCodecs.INT, PaleCreeperVariant::Particle, PaleCreeperVariant::new);
    public static final Codec<Holder<PaleCreeperVariant>> CODEC = RegistryFileCodec.create(VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<PaleCreeperVariant>> STREAM_CODEC = ByteBufCodecs.holder(VariantsRegistry.PALE_CREEPER_VARIANT_REGISTRY_KEY, DIRECT_STREAM_CODEC);
    public final ResourceLocation Texture;
    public final ResourceLocation PowerTexture;
    public final int particle;
    public final Holder<MobEffect> effect;
    public final ResourceKey<ConfiguredFeature<?, ?>> feature;
    public final ResourceKey<Biome> biome;
    public final ResourceLocation TextureFull;
    public final ResourceLocation PowerTextureFull;

    public PaleCreeperVariant(ResourceLocation texture, ResourceLocation powertexture, Holder<MobEffect> effect, ResourceKey<ConfiguredFeature<?, ?>> feature, ResourceKey<Biome> biome, int particle) {
        this.Texture = texture;
        this.TextureFull = PaleCreeperVariant.fullTextureId(texture);
        this.PowerTexture = powertexture;
        this.PowerTextureFull = PaleCreeperVariant.fullTextureId(powertexture);
        this.effect = effect;
        this.feature = feature;
        this.biome = biome;
        this.particle = particle;
    }

    public static ResourceLocation fullTextureId(ResourceLocation texture) {
        return texture.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public ResourceLocation Texture() {
        return this.TextureFull;
    }

    public ResourceLocation PowerTexture() {
        return this.PowerTextureFull;
    }

    public Holder<MobEffect> Effect() {
        return this.effect;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> Feature() {
        return this.feature;
    }

    public ResourceKey<Biome> Biome() {
        return this.biome;
    }

    public int Particle() {
        return this.particle;
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (other == this) {
            return true;
        }
        if (other instanceof CreakingGuardVariant) {
            CreakingGuardVariant CreakingVariant = (CreakingGuardVariant)other;
            var10000 = Objects.equals(this.Texture, CreakingVariant.Texture);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.Texture.hashCode();
        return i;
    }
}

