/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.blocks;

import com.belgie.creaking_expanded.entity.CreakingGolem;
import com.belgie.creaking_expanded.registry.BlockRegistry;
import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.CreakingGuardVariant;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PaleCarvedPumpkin
extends HorizontalDirectionalBlock {
    public static final MapCodec<PaleCarvedPumpkin> CODEC = PaleCarvedPumpkin.simpleCodec(PaleCarvedPumpkin::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty EASTER_EGG = BlockRegistry.EASTER_EGG;
    @Nullable
    private BlockPattern snowGolemFull;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = p_51396_ -> p_51396_ != null && (p_51396_.is((Block)BlockRegistry.CARVED_PALE_PUMPKIN.get()) || p_51396_.is((Block)BlockRegistry.PALE_JACK_O_LANTERN.get()));

    public MapCodec<? extends PaleCarvedPumpkin> codec() {
        return CODEC;
    }

    public PaleCarvedPumpkin(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)EASTER_EGG, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.trySpawnGolem(level, pos);
        }
    }

    private void trySpawnGolem(Level level, BlockPos pos) {
        CreakingGolem snowgolem;
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.getOrCreateSnowGolemFull().find((LevelReader)level, pos);
        if (blockpattern$blockpatternmatch != null && (snowgolem = (CreakingGolem)EntityRegistry.FRIENDLY_CREAKING.get().create(level, EntitySpawnReason.TRIGGERED)) != null) {
            PaleCarvedPumpkin.spawnGolemInWorld(level, blockpattern$blockpatternmatch, (Entity)snowgolem, blockpattern$blockpatternmatch.getBlock(0, 2, 0).getPos());
            snowgolem.setTransient(pos);
            Registry holder = level.registryAccess().lookupOrThrow(VariantsRegistry.CREAKING_GOLEM_VARIANT_REGISTRY_KEY);
            if (holder.getRandom(level.random).isPresent()) {
                snowgolem.setVariant((Holder<CreakingGuardVariant>)((Holder)holder.getRandom(level.random).get()));
            }
        }
    }

    private static void spawnGolemInWorld(Level level, BlockPattern.BlockPatternMatch patternMatch, Entity golem, BlockPos pos) {
        PaleCarvedPumpkin.clearPatternBlocks(level, patternMatch);
        golem.snapTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.05, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity(golem);
        for (ServerPlayer serverplayer : level.getEntitiesOfClass(ServerPlayer.class, golem.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverplayer, golem);
        }
        PaleCarvedPumpkin.updatePatternBlocks(level, patternMatch);
    }

    public static void clearPatternBlocks(Level level, BlockPattern.BlockPatternMatch patternMatch) {
        for (int i = 0; i < patternMatch.getWidth(); ++i) {
            for (int j = 0; j < patternMatch.getHeight(); ++j) {
                BlockInWorld blockinworld = patternMatch.getBlock(i, j, 0);
                level.setBlock(blockinworld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                level.levelEvent(2001, blockinworld.getPos(), Block.getId((BlockState)blockinworld.getState()));
            }
        }
    }

    public static void updatePatternBlocks(Level level, BlockPattern.BlockPatternMatch patternMatch) {
        for (int i = 0; i < patternMatch.getWidth(); ++i) {
            for (int j = 0; j < patternMatch.getHeight(); ++j) {
                BlockInWorld blockinworld = patternMatch.getBlock(i, j, 0);
                level.setBlockAndUpdate(blockinworld.getPos(), Blocks.AIR.defaultBlockState());
            }
        }
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean p_387561_) {
        return PaleCarvedPumpkin.setLightOnStack(super.getCloneItemStack(level, pos, state, p_387561_), (Boolean)state.getValue((Property)EASTER_EGG));
    }

    public static ItemStack setLightOnStack(ItemStack stack, boolean light) {
        stack.set(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY.with((Property)EASTER_EGG, (Comparable)Boolean.valueOf(light)));
        return stack;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, EASTER_EGG});
    }

    private BlockPattern getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = BlockPatternBuilder.start().aisle(new String[]{"^", "E", "#"}).where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('E', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.CREAKING_HEART))).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.PALE_OAK_LOG))).build();
        }
        return this.snowGolemFull;
    }
}

