/*
 * Decompiled with CFR 0.152.
 */
package com.belgie.creaking_expanded.entity;

import com.belgie.creaking_expanded.registry.EntityRegistry;
import com.belgie.creaking_expanded.registry.TagRegistry;
import com.belgie.creaking_expanded.registry.VariantsRegistry;
import com.belgie.creaking_expanded.variants.CreakingGuardVariant;
import com.belgie.creaking_expanded.variants.CreakingGuardVariants;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CreakingGolem
extends Monster {
    private static final EntityDataAccessor<Boolean> CAN_MOVE;
    private static final EntityDataAccessor<Boolean> IS_ACTIVE;
    private static final EntityDataAccessor<Boolean> IS_TEARING_DOWN;
    private static final EntityDataAccessor<Boolean> IS_SHIELDING;
    protected static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_OWNERUUID_ID;
    private static final EntityDataAccessor<Integer> SHIELDING_COOLDOWN;
    private static final EntityDataAccessor<Holder<CreakingGuardVariant>> DATA_VARIANT_ID;
    private static final EntityDataAccessor<Optional<BlockPos>> HOME_POS;
    private int attackAnimationRemainingTicks;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState invulnerabilityAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    private int invulnerabilityAnimationRemainingTicks;
    private boolean eyesGlowing;
    private int nextFlickerTime;

    public CreakingGolem(EntityType<? extends CreakingGolem> p_380212_, Level p_379294_) {
        super(p_380212_, p_379294_);
        this.lookControl = new CreakingGolemLookControl(this);
        this.moveControl = new CreakingGolemMoveControl(this);
        this.jumpControl = new CreakingGolemJumpControl(this);
        GroundPathNavigation groundpathnavigation = (GroundPathNavigation)this.getNavigation();
        groundpathnavigation.setCanFloat(true);
        this.xpReward = 0;
    }

    public Holder<CreakingGuardVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT_ID);
    }

    public void setVariant(Holder<CreakingGuardVariant> p_332777_) {
        this.entityData.set(DATA_VARIANT_ID, p_332777_);
    }

    public ResourceLocation getTexture() {
        CreakingGuardVariant variant = (CreakingGuardVariant)this.getVariant().value();
        return variant.Texture();
    }

    public ResourceLocation getShieldTexture() {
        CreakingGuardVariant variant = (CreakingGuardVariant)this.getVariant().value();
        return variant.ShieldTexture();
    }

    public void setTransient(BlockPos p_389674_) {
        this.setHomePos(p_389674_);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
    }

    public boolean isHeartBound() {
        return this.getHomePos() != null;
    }

    protected BodyRotationControl createBodyControl() {
        return new CreakingGolemBodyRotationControl(this);
    }

    public boolean hurtServer(ServerLevel p_389623_, DamageSource p_389564_, float p_389723_) {
        if (this.isShielded() && !p_389564_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            if (!this.isInvulnerableTo(p_389623_, p_389564_) && this.invulnerabilityAnimationRemainingTicks <= 0 && !this.isDeadOrDying()) {
                Player player = this.blameSourceForDamage(p_389564_);
                Entity entity = p_389564_.getDirectEntity();
                if (!(entity instanceof LivingEntity) && !(entity instanceof Projectile) && player == null) {
                    return false;
                }
                this.invulnerabilityAnimationRemainingTicks = 8;
                this.level().broadcastEntityEvent((Entity)this, (byte)66);
                this.playSound(SoundEvents.CREAKING_SWAY);
                return true;
            }
            return false;
        }
        return super.hurtServer(p_389623_, p_389564_, p_389723_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_379982_) {
        super.defineSynchedData(p_379982_);
        p_379982_.define(CAN_MOVE, (Object)true);
        p_379982_.define(IS_ACTIVE, (Object)false);
        p_379982_.define(IS_TEARING_DOWN, (Object)false);
        p_379982_.define(IS_SHIELDING, (Object)false);
        p_379982_.define(SHIELDING_COOLDOWN, (Object)0);
        p_379982_.define(HOME_POS, Optional.empty());
        p_379982_.define(DATA_OWNERUUID_ID, Optional.empty());
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(VariantsRegistry.CREAKING_GOLEM_VARIANT_REGISTRY_KEY);
        EntityDataAccessor<Holder<CreakingGuardVariant>> var10001 = DATA_VARIANT_ID;
        Optional var10002 = registry.get(CreakingGuardVariants.DEFAULT);
        Objects.requireNonNull(registry);
        p_379982_.define(var10001, (Object)((Holder)var10002.or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.MOVEMENT_SPEED, 0.3000000059604645).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.STEP_HEIGHT, 1.0625);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new CreakingMeleeGoal(this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, (p_28879_, p_376412_) -> p_28879_ instanceof Enemy && this.canMove() && !p_28879_.getType().is(TagRegistry.CREAKING_GUARD_CANT_ATTACK)));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(((CreakingGuardVariant)this.getVariant().value()).Item()) && this.shieldingCooldown() == 0 && !this.isShielded()) {
            if (!player.isCreative()) {
                itemstack.shrink(1);
            }
            this.setOwner((LivingEntity)player);
            this.setIsShielding(true);
            this.level().playSound((Entity)player, (Entity)this, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.NEUTRAL, 2.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public int shieldingCooldown() {
        return (Integer)this.entityData.get(SHIELDING_COOLDOWN);
    }

    public void SetshieldingCooldown(int cool) {
        this.entityData.set(SHIELDING_COOLDOWN, (Object)cool);
    }

    public boolean canMove() {
        return (Boolean)this.entityData.get(CAN_MOVE);
    }

    public boolean isShielded() {
        return (Boolean)this.entityData.get(IS_SHIELDING);
    }

    public void setIsShielding(boolean cool) {
        this.entityData.set(IS_SHIELDING, (Object)cool);
    }

    public boolean doHurtTarget(ServerLevel p_379943_, Entity p_379911_) {
        if (!(p_379911_ instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 15;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(p_379943_, p_379911_);
    }

    public Player blameSourceForDamage(DamageSource p_389629_) {
        this.resolveMobResponsibleForDamage(p_389629_);
        return this.resolvePlayerResponsibleForDamage(p_389629_);
    }

    public boolean isPushable() {
        return super.isPushable() && this.canMove();
    }

    public void push(double p_388562_, double p_388936_, double p_387604_) {
        if (this.canMove()) {
            super.push(p_388562_, p_388936_, p_387604_);
        }
    }

    public void aiStep() {
        if (this.invulnerabilityAnimationRemainingTicks > 0) {
            --this.invulnerabilityAnimationRemainingTicks;
        }
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        if (!this.level().isClientSide()) {
            boolean flag = (Boolean)this.entityData.get(CAN_MOVE);
            boolean flag1 = this.checkCanMove();
            if (flag1 != flag) {
                this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
                if (flag1) {
                    this.makeSound(SoundEvents.CREAKING_UNFREEZE);
                } else {
                    this.stopInPlace();
                    this.makeSound(SoundEvents.CREAKING_FREEZE);
                }
            }
            this.entityData.set(CAN_MOVE, (Object)flag1);
        }
        super.aiStep();
    }

    @Nullable
    public Boolean isOwnerAlive(Level level) {
        EntityReference<LivingEntity> ref = this.getOwnerReference();
        if (ref != null) {
            LivingEntity owner = (LivingEntity)ref.getEntity(level, LivingEntity.class);
            return owner != null && owner.isAlive();
        }
        return false;
    }

    public void tick() {
        if (this.isShielded() && this.getOwnerReference() != null && !this.isOwnerAlive(this.level()).booleanValue()) {
            this.setIsShielding(false);
            this.setOwner(null);
        }
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
            this.checkEyeBlink();
        }
    }

    protected void tickDeath() {
        this.tearDown();
    }

    protected void updateWalkAnimation(float p_382793_) {
        float f = Math.min(p_382793_ * 25.0f, 3.0f);
        this.walkAnimation.update(f, 0.4f, 1.0f);
    }

    private void setupAnimationStates() {
        this.attackAnimationState.animateWhen(this.attackAnimationRemainingTicks > 0, this.tickCount);
        this.invulnerabilityAnimationState.animateWhen(this.invulnerabilityAnimationRemainingTicks > 0, this.tickCount);
        this.deathAnimationState.animateWhen(this.isTearingDown(), this.tickCount);
    }

    public void tearDown() {
        Level var2 = this.level();
        if (var2 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var2;
            AABB aabb = this.getBoundingBox();
            Vec3 vec3 = aabb.getCenter();
            double d0 = aabb.getXsize() * 0.3;
            double d1 = aabb.getYsize() * 0.3;
            double d2 = aabb.getZsize() * 0.3;
            serverlevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, Blocks.PALE_OAK_WOOD.defaultBlockState()), vec3.x, vec3.y, vec3.z, 100, d0, d1, d2, 0.0);
            serverlevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_CRUMBLE, (BlockState)Blocks.CREAKING_HEART.defaultBlockState().setValue((Property)CreakingHeartBlock.STATE, (Comparable)CreakingHeartState.AWAKE)), vec3.x, vec3.y, vec3.z, 10, d0, d1, d2, 0.0);
        }
        this.makeSound(this.getDeathSound());
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void handleEntityEvent(byte p_379620_) {
        if (p_379620_ == 66) {
            this.invulnerabilityAnimationRemainingTicks = 8;
            this.deathAnimationState.startIfStopped(this.tickCount);
            this.playHurtSound(this.damageSources().generic());
        } else if (p_379620_ == 4) {
            this.attackAnimationRemainingTicks = 15;
            this.playAttackSound();
        } else {
            super.handleEntityEvent(p_379620_);
        }
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean canBeNameTagged() {
        return false;
    }

    protected boolean canAddPassenger(Entity p_389469_) {
        return false;
    }

    protected boolean couldAcceptPassenger() {
        return false;
    }

    protected void addPassenger(Entity p_389484_) {
        if (this.isHeartBound()) {
            throw new IllegalStateException("Should never addPassenger without checking couldAcceptPassenger()");
        }
    }

    public boolean canUsePortal(boolean p_389552_) {
        return false;
    }

    protected PathNavigation createNavigation(Level p_389684_) {
        return new CreakingGolemPathNavigation(this, p_389684_);
    }

    public boolean checkCanMove() {
        Player player;
        ServerLevel serverLevel = (ServerLevel)this.level();
        List list = serverLevel.getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(32.0));
        boolean flag = this.isActive();
        if (list.isEmpty()) {
            if (flag) {
                this.deactivate();
            }
            if (!this.level().isMoonVisible()) {
                this.deactivate();
            }
            return true;
        }
        boolean flag1 = false;
        Iterator var4 = list.iterator();
        while (true) {
            if (!var4.hasNext()) {
                if (!flag1 && flag) {
                    this.deactivate();
                }
                return true;
            }
            player = (Player)var4.next();
            if (!this.canAttack((LivingEntity)player) || this.isAlliedTo((Entity)player)) continue;
            flag1 = true;
            if (flag && !LivingEntity.PLAYER_NOT_WEARING_DISGUISE_ITEM_FOR_TARGET.test(player, this) || !this.isLookingAtMe((LivingEntity)player, 0.5, false, true, new double[]{this.getEyeY(), this.getY() + 0.5 * (double)this.getScale(), (this.getEyeY() + this.getY()) / 2.0})) continue;
            if (flag) {
                return false;
            }
            if (player.distanceToSqr((Entity)this) < 144.0) break;
        }
        this.activate(player);
        return false;
    }

    public void setHomePos(BlockPos p_390421_) {
        this.entityData.set(HOME_POS, Optional.of(p_390421_));
    }

    @Nullable
    public BlockPos getHomePos() {
        return ((Optional)this.entityData.get(HOME_POS)).orElse(null);
    }

    public void setTearingDown() {
        this.entityData.set(IS_TEARING_DOWN, (Object)true);
    }

    public boolean isTearingDown() {
        return (Boolean)this.entityData.get(IS_TEARING_DOWN);
    }

    public boolean hasGlowingEyes() {
        return this.eyesGlowing;
    }

    public void checkEyeBlink() {
        if (this.deathTime > this.nextFlickerTime) {
            this.nextFlickerTime = this.deathTime + this.getRandom().nextIntBetweenInclusive(this.eyesGlowing ? 2 : this.deathTime / 4, this.eyesGlowing ? 8 : this.deathTime / 2);
            this.eyesGlowing = !this.eyesGlowing;
        }
    }

    public void addAdditionalSaveData(ValueOutput compound) {
        super.addAdditionalSaveData(compound);
        if (((Boolean)this.entityData.get(IS_SHIELDING)).booleanValue()) {
            compound.putBoolean("Shielded", true);
        }
        compound.putInt("ShieldingTime", this.shieldingCooldown());
        EntityReference<LivingEntity> entityreference = this.getOwnerReference();
        if (entityreference != null) {
            entityreference.store(compound, "Owner");
        }
        this.getVariant().unwrapKey().ifPresent(p_344339_ -> compound.putString("variant", p_344339_.location().toString()));
    }

    public void readAdditionalSaveData(ValueInput compound) {
        super.readAdditionalSaveData(compound);
        VariantUtils.readVariant((ValueInput)compound, VariantsRegistry.CREAKING_GOLEM_VARIANT_REGISTRY_KEY).ifPresent(this::setVariant);
        super.readAdditionalSaveData(compound);
        this.entityData.set(IS_SHIELDING, (Object)compound.getBooleanOr("Shielded", false));
        this.SetshieldingCooldown(compound.getIntOr("ShieldingTime", 0));
        EntityReference entityreference = EntityReference.readWithOldOwnerConversion((ValueInput)compound, (String)"Owner", (Level)this.level());
        if (entityreference != null) {
            try {
                this.entityData.set(DATA_OWNERUUID_ID, Optional.of(entityreference));
            }
            catch (Throwable throwable) {}
        } else {
            this.entityData.set(DATA_OWNERUUID_ID, Optional.empty());
        }
    }

    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwner(@Nullable LivingEntity p_392796_) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(EntityReference.of((UniquelyIdentifyable)p_392796_)));
    }

    public void setOwnerReference(@Nullable EntityReference<LivingEntity> p_393669_) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(p_393669_));
    }

    public void playAttackSound() {
        this.makeSound(SoundEvents.CREAKING_ATTACK);
    }

    protected SoundEvent getAmbientSound() {
        return this.isActive() ? null : SoundEvents.CREAKING_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource p_380378_) {
        return SoundEvents.CREAKING_SWAY;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CREAKING_DEATH;
    }

    protected void playStepSound(BlockPos p_379428_, BlockState p_380060_) {
        this.playSound(SoundEvents.CREAKING_STEP, 0.15f, 1.0f);
    }

    public void knockback(double p_379489_, double p_380324_, double p_379735_) {
        if (this.canMove()) {
            super.knockback(p_379489_, p_380324_, p_379735_);
        }
    }

    public void activate(Player p_382994_) {
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEvents.CREAKING_ACTIVATE);
        this.setIsActive(true);
    }

    public void deactivate() {
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.makeSound(SoundEvents.CREAKING_DEACTIVATE);
        this.setIsActive(false);
    }

    public void setIsActive(boolean p_379949_) {
        this.entityData.set(IS_ACTIVE, (Object)p_379949_);
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(IS_ACTIVE);
    }

    public float getWalkTargetValue(BlockPos p_379756_, LevelReader p_380102_) {
        return 0.0f;
    }

    static {
        DATA_OWNERUUID_ID = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
        DATA_VARIANT_ID = SynchedEntityData.defineId(CreakingGolem.class, EntityRegistry.CREAKING_GOLEM_VARIANT.get());
        CAN_MOVE = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        IS_ACTIVE = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        IS_TEARING_DOWN = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        IS_SHIELDING = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        SHIELDING_COOLDOWN = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.INT);
        HOME_POS = SynchedEntityData.defineId(CreakingGolem.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    }

    class CreakingGolemLookControl
    extends LookControl {
        public CreakingGolemLookControl(CreakingGolem p_379883_) {
            super((Mob)p_379883_);
        }

        public void tick() {
            if (CreakingGolem.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingGolemMoveControl
    extends MoveControl {
        public CreakingGolemMoveControl(CreakingGolem p_380148_) {
            super((Mob)p_380148_);
        }

        public void tick() {
            if (CreakingGolem.this.canMove()) {
                super.tick();
            }
        }
    }

    class CreakingGolemJumpControl
    extends JumpControl {
        public CreakingGolemJumpControl(CreakingGolem p_379900_) {
            super((Mob)p_379900_);
        }

        public void tick() {
            if (CreakingGolem.this.canMove()) {
                super.tick();
            } else {
                CreakingGolem.this.setJumping(false);
            }
        }
    }

    class CreakingGolemBodyRotationControl
    extends BodyRotationControl {
        public CreakingGolemBodyRotationControl(CreakingGolem p_380382_) {
            super((Mob)p_380382_);
        }

        public void clientTick() {
            if (CreakingGolem.this.canMove()) {
                super.clientTick();
            }
        }
    }

    public static class CreakingMeleeGoal
    extends MeleeAttackGoal {
        CreakingGolem creakingGolem;

        public CreakingMeleeGoal(CreakingGolem mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)mob, speedModifier, followingTargetEvenIfNotSeen);
            this.creakingGolem = mob;
        }

        public boolean canUse() {
            return this.creakingGolem.canMove();
        }

        public boolean canContinueToUse() {
            return this.creakingGolem.canMove();
        }
    }

    class CreakingGolemPathNavigation
    extends GroundPathNavigation {
        CreakingGolemPathNavigation(CreakingGolem p_389716_, Level p_389411_) {
            super((Mob)p_389716_, p_389411_);
        }

        public void tick() {
            if (CreakingGolem.this.canMove()) {
                super.tick();
            }
        }

        protected PathFinder createPathFinder(int p_389538_) {
            CreakingGolem var10003 = CreakingGolem.this;
            Objects.requireNonNull(var10003);
            this.nodeEvaluator = var10003.new HomeNodeEvaluator();
            this.nodeEvaluator.setCanPassDoors(true);
            return new PathFinder(this.nodeEvaluator, p_389538_);
        }
    }

    class HomeNodeEvaluator
    extends WalkNodeEvaluator {
        private static final int MAX_DISTANCE_TO_HOME_SQ = 1024;

        HomeNodeEvaluator() {
        }

        public PathType getPathType(PathfindingContext p_389549_, int p_389638_, int p_389512_, int p_389613_) {
            BlockPos blockpos = CreakingGolem.this.getHomePos();
            if (blockpos == null) {
                return super.getPathType(p_389549_, p_389638_, p_389512_, p_389613_);
            }
            double d0 = blockpos.distSqr(new Vec3i(p_389638_, p_389512_, p_389613_));
            return d0 > 256.0 && d0 >= blockpos.distSqr((Vec3i)p_389549_.mobPosition()) ? PathType.BLOCKED : super.getPathType(p_389549_, p_389638_, p_389512_, p_389613_);
        }
    }
}

