/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.impl.gui;

import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.api.gui.AuthScreen;
import com.mrbysco.neoauth.util.MicrosoftUtils;
import com.mrbysco.neoauth.util.SessionUtils;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.http.conn.ConnectTimeoutException;

public class MicrosoftAuthScreen
extends AuthScreen {
    public static final WidgetSprites COPY_BUTTON_TEXTURES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"neo_auth", (String)"widget/copy_button"), ResourceLocation.fromNamespaceAndPath((String)"neo_auth", (String)"widget/copy_button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"neo_auth", (String)"widget/copy_button_focused"));
    private ExecutorService executor = null;
    private CompletableFuture<Void> task = null;
    private StringWidget statusWidget = null;
    private URI authUri = null;
    private final boolean selectAccount;

    public MicrosoftAuthScreen(Screen parentScreen, Screen successScreen, boolean selectAccount) {
        super((Component)Component.translatable((String)"gui.neo_auth.microsoft.title"), parentScreen, successScreen);
        this.selectAccount = selectAccount;
        this.closeOnSuccess = true;
    }

    @Override
    protected void init() {
        super.init();
        assert (this.minecraft != null);
        StringWidget titleWidget = new StringWidget(this.width, this.height, this.title, this.font);
        titleWidget.setColor(0xFFFFFF);
        titleWidget.setPosition(this.width / 2 - titleWidget.getWidth() / 2, this.height / 2 - titleWidget.getHeight() / 2 - 27);
        this.addRenderableWidget((GuiEventListener)titleWidget);
        MutableComponent previousMessage = this.statusWidget != null ? this.statusWidget.getMessage() : Component.empty();
        this.statusWidget = new StringWidget(this.width, this.height, this.title, this.font);
        this.statusWidget.setColor(0xDDDDDD);
        this.statusWidget.setPosition(this.width / 2 - this.statusWidget.getWidth() / 2, this.height / 2 - this.statusWidget.getHeight() / 2 - 1);
        this.statusWidget.setMessage((Component)previousMessage);
        this.addRenderableWidget((GuiEventListener)this.statusWidget);
        Button cancelBtn = Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 22, 75, 20).build();
        this.addRenderableWidget((GuiEventListener)cancelBtn);
        ImageButton copyLinkBtn = new ImageButton(this.width / 2 + 30, this.height / 2 + 22, 20, 20, COPY_BUTTON_TEXTURES, button -> this.copyLinkToClipboard(), (Component)Component.translatable((String)"chat.copy"));
        this.addRenderableWidget((GuiEventListener)copyLinkBtn);
        copyLinkBtn.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.neo_auth.microsoft.button.copyLink").append("\n").append((Component)Component.translatable((String)"gui.neo_auth.microsoft.button.copyLink.tooltip").withStyle(ChatFormatting.GRAY))));
        boolean bl = copyLinkBtn.active = this.authUri != null;
        if (this.task != null) {
            return;
        }
        this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.checkBrowser"));
        this.executor = Executors.newSingleThreadExecutor();
        this.task = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)MicrosoftUtils.acquireMSAuthCode(arg_0 -> this.lambda$init$2((Button)copyLinkBtn, arg_0), success -> Component.translatable((String)"gui.neo_auth.microsoft.browser").getString(), this.executor, this.selectAccount ? MicrosoftUtils.MicrosoftPrompt.SELECT_ACCOUNT : null).thenComposeAsync(msAuthCode -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.msAccessToken"));
            return MicrosoftUtils.acquireMSAccessToken(msAuthCode, this.executor);
        })).thenComposeAsync(msAccessToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.xboxAccessToken"));
            return MicrosoftUtils.acquireXboxAccessToken(msAccessToken, this.executor);
        })).thenComposeAsync(xboxAccessToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.xboxXstsToken"));
            return MicrosoftUtils.acquireXboxXstsToken(xboxAccessToken, this.executor);
        })).thenComposeAsync(xboxXstsData -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.mcAccessToken"));
            return MicrosoftUtils.acquireMCAccessToken((String)xboxXstsData.get("Token"), (String)xboxXstsData.get("uhs"), this.executor);
        })).thenComposeAsync(mcToken -> {
            this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.mcProfile"));
            return MicrosoftUtils.login(mcToken, this.executor);
        })).thenAccept(session -> {
            SessionUtils.setSession(session);
            SystemToast.add((ToastComponent)this.minecraft.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"gui.neo_auth.toast.greeting", (Object[])new Object[]{Component.literal((String)session.getName())}), null);
            NeoAuth.LOGGER.info("Successfully logged in via Microsoft!");
            this.success = true;
        })).exceptionally(error -> {
            String key = error.getCause() instanceof ConnectTimeoutException ? "gui.neo_auth.error.timeout" : ("NOT_FOUND: Not Found".equals(error.getCause().getMessage()) ? "gui.neo_auth.error.notPurchased" : "gui.neo_auth.error.generic");
            this.statusWidget.setMessage((Component)Component.translatable((String)key).withStyle(ChatFormatting.RED));
            cancelBtn.setMessage((Component)Component.translatable((String)"gui.back"));
            return null;
        });
    }

    public void copyLinkToClipboard() {
        if (this.authUri != null && this.minecraft != null) {
            this.minecraft.keyboardHandler.setClipboard(this.authUri.toString());
            if (this.statusWidget != null) {
                this.statusWidget.setMessage((Component)Component.translatable((String)"gui.neo_auth.microsoft.status.linkCopied"));
            }
        }
    }

    @Override
    public void onClose() {
        if (this.task != null && !this.task.isDone()) {
            this.task.cancel(true);
            this.executor.shutdownNow();
        }
        super.onClose();
    }

    private /* synthetic */ void lambda$init$2(Button copyLinkBtn, URI uri) {
        this.authUri = uri;
        copyLinkBtn.active = true;
        Util.getPlatform().openUri(uri);
    }
}

