/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.time.TickUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.data.MobCapData;
import fi.dy.masa.minihud.data.ServuxDataLogger;
import fi.dy.masa.minihud.data.ServuxTickData;
import fi.dy.masa.minihud.mixin.world.IMixinServerRecipeManager;
import fi.dy.masa.minihud.network.ServuxHudHandler;
import fi.dy.masa.minihud.network.ServuxHudPacket;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.util.DataStorage;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class HudDataManager {
    private static final HudDataManager INSTANCE = new HudDataManager();
    private static final ServuxHudHandler<ServuxHudPacket.Payload> HANDLER = ServuxHudHandler.getInstance();
    private final Minecraft mc = Minecraft.getInstance();
    private boolean shouldRegister;
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion = "";
    private int servuxProtocolVersion;
    private long worldSeed = -1L;
    private int spawnChunkRadius = -1;
    private GlobalPos worldSpawn = new GlobalPos(Level.OVERWORLD, BlockPos.ZERO);
    private boolean worldSeedValid = false;
    private boolean spawnChunkRadiusValid = false;
    private boolean worldSpawnValid = false;
    private boolean isRaining = false;
    private boolean isThundering = false;
    private int clearWeatherTimer = -1;
    private int rainWeatherTimer = -1;
    private int thunderWeatherTimer = -1;
    private RecipeMap preparedRecipes = RecipeMap.EMPTY;
    private int recipeCount = 0;

    public static HudDataManager getInstance() {
        return INSTANCE;
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxHudPacket.Payload.ID, ServuxHudPacket.Payload.CODEC, 6);
    }

    public ResourceLocation getNetworkChannel() {
        return ServuxHudHandler.CHANNEL_ID;
    }

    public IPluginClientPlayHandler<ServuxHudPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.debugLog("HudDataStorage#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.servuxVersion = "";
            this.spawnChunkRadius = -1;
            this.worldSpawn = new GlobalPos(Level.OVERWORLD, BlockPos.ZERO);
            this.worldSpawnValid = false;
            this.spawnChunkRadiusValid = false;
            this.preparedRecipes = RecipeMap.EMPTY;
            this.recipeCount = 0;
        } else {
            MiniHUD.debugLog("HudDataStorage#reset() - dimension change or log-in", new Object[0]);
        }
        this.resetWeatherData();
        if (isLogout || !Configs.Generic.DONT_RESET_SEED_ON_DIMENSION_CHANGE.getBooleanValue()) {
            this.worldSeedValid = false;
            this.worldSeed = 0L;
        }
    }

    public void resetWeatherData() {
        this.isRaining = false;
        this.isThundering = false;
        this.clearWeatherTimer = -1;
        this.rainWeatherTimer = -1;
        this.thunderWeatherTimer = -1;
    }

    public void onWorldPre() {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxHudPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
        MiniHUD.debugLog("HudDataStorage#onWorldJoin()", new Object[0]);
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
                this.requestMetadata();
            } else {
                this.unregisterChannel();
            }
        }
    }

    public void onPacketFailure() {
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        if (this.hasInValidServux) {
            this.hasInValidServux = false;
        }
    }

    public void setServuxVersion(String ver, int protocol) {
        if (ver != null && !ver.isEmpty()) {
            this.servuxVersion = ver;
            this.servuxProtocolVersion = protocol;
            MiniHUD.LOGGER.info("hudDataChannel: joining Servux version {}", (Object)ver);
        } else {
            this.servuxVersion = "unknown";
            this.servuxProtocolVersion = -1;
        }
    }

    public String getServuxVersion() {
        if (this.hasServuxServer()) {
            return this.servuxVersion;
        }
        return "not_connected";
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            MiniHUD.debugLog("HudDataStorage#setWorldSeed(): set world seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
        this.worldSeedValid = true;
    }

    public void setWorldSpawn(GlobalPos spawn) {
        if (!this.worldSpawn.equals((Object)spawn)) {
            OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
            MiniHUD.debugLog("HudDataStorage#setWorldSpawn(): set world spawn [{}] -> [{}]", this.getWorldSpawnAsString(), this.getWorldSpawnAsString(spawn));
        }
        this.worldSpawn = spawn;
        this.worldSpawnValid = true;
    }

    public void setSpawnChunkRadius(int radius, boolean message) {
        if (radius > 0 && radius <= 32) {
            if (this.spawnChunkRadius != radius) {
                if (message) {
                    String strRadius = GuiBase.TXT_GREEN + String.format("%d", radius) + GuiBase.TXT_RST;
                    InfoUtils.printActionbarMessage((String)StringUtils.translate((String)"minihud.message.spawn_chunk_radius_set", (Object[])new Object[]{strRadius}), (Object[])new Object[0]);
                }
                OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
                MiniHUD.debugLog("HudDataStorage#setSpawnChunkRadius(): set spawn chunk radius [{}] -> [{}]", this.spawnChunkRadius, radius);
            }
            this.spawnChunkRadius = radius;
            this.spawnChunkRadiusValid = true;
        } else {
            this.spawnChunkRadius = -1;
            this.spawnChunkRadiusValid = false;
        }
    }

    public void setWorldSpawnIfUnknown(GlobalPos spawn) {
        if (!this.worldSpawnValid) {
            this.setWorldSpawn(spawn);
            OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
        }
    }

    public void setSpawnChunkRadiusIfUnknown(int radius) {
        if (!this.spawnChunkRadiusValid) {
            this.setSpawnChunkRadius(radius, true);
            OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate();
        }
    }

    public boolean isWorldSeedKnown(Level world) {
        if (this.worldSeedValid) {
            return true;
        }
        if (this.mc.hasSingleplayerServer()) {
            IntegratedServer server = this.mc.getSingleplayerServer();
            assert (server != null);
            ServerLevel worldTmp = server.getLevel(world.dimension());
            return worldTmp != null;
        }
        return false;
    }

    public boolean hasStoredWorldSeed() {
        return this.worldSeedValid;
    }

    public long worldSeed() {
        return this.worldSeed;
    }

    public long getWorldSeed(Level world) {
        if (!this.worldSeedValid && this.mc.hasSingleplayerServer()) {
            IntegratedServer server = this.mc.getSingleplayerServer();
            assert (server != null);
            ServerLevel worldTmp = server.getLevel(world.dimension());
            if (worldTmp != null) {
                this.setWorldSeed(worldTmp.getSeed());
            }
        }
        return this.worldSeed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        long seedTmp;
        ServerLevel worldTmp;
        if (this.mc.hasSingleplayerServer() && (worldTmp = server.overworld()) != null && (seedTmp = worldTmp.getSeed()) != this.worldSeed) {
            this.setWorldSeed(seedTmp);
        }
    }

    public boolean isWorldSpawnKnown() {
        return this.worldSpawnValid;
    }

    public GlobalPos getWorldSpawn() {
        return this.worldSpawn;
    }

    public String getWorldSpawnAsString() {
        GlobalPos pos = this.getWorldSpawn();
        return String.format("[%s: %d, %d, %d]", pos.dimension().location().toString(), pos.pos().getX(), pos.pos().getY(), pos.pos().getZ());
    }

    public String getWorldSpawnAsString(GlobalPos pos) {
        return String.format("[%s: %d, %d, %d]", pos.dimension().location().toString(), pos.pos().getX(), pos.pos().getY(), pos.pos().getZ());
    }

    public boolean isSpawnChunkRadiusKnown() {
        return this.spawnChunkRadiusValid;
    }

    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius > -1) {
            return this.spawnChunkRadius;
        }
        return -1;
    }

    public boolean hasValidWeatherCycle() {
        if (DataStorage.getInstance().hasIntegratedServer()) {
            IntegratedServer server = DataStorage.getInstance().getIntegratedServer();
            return server.overworld().getGameRules().getBoolean(GameRules.RULE_WEATHER_CYCLE);
        }
        return this.getClearTime() >= 0 || this.getRainTime() >= 0 || this.getThunderTime() >= 0;
    }

    public boolean isWeatherClear() {
        return !this.isWeatherRain() && !this.isWeatherThunder();
    }

    public int getClearTime() {
        if (this.isWeatherClear()) {
            return this.clearWeatherTimer;
        }
        return -1;
    }

    public boolean isWeatherRain() {
        return this.isRaining;
    }

    public int getRainTime() {
        if (this.isWeatherRain()) {
            return this.rainWeatherTimer;
        }
        return -1;
    }

    public boolean isWeatherThunder() {
        return this.isThundering;
    }

    public int getThunderTime() {
        if (this.isWeatherThunder()) {
            return this.thunderWeatherTimer;
        }
        return -1;
    }

    public boolean hasRecipes() {
        return !this.preparedRecipes.equals(RecipeMap.EMPTY);
    }

    @Nullable
    public RecipeMap getPreparedRecipes() {
        if (DataStorage.getInstance().hasIntegratedServer() && this.getRecipeManager() != null) {
            return ((IMixinServerRecipeManager)this.getRecipeManager()).minihud_getPreparedRecipes();
        }
        if (this.hasRecipes()) {
            return this.preparedRecipes;
        }
        return null;
    }

    public int getRecipeCount() {
        return this.recipeCount;
    }

    @Nullable
    public RecipeAccess getRecipeManager() {
        if (DataStorage.getInstance().hasIntegratedServer() && this.mc.getSingleplayerServer() != null) {
            return this.mc.getSingleplayerServer().getRecipeManager();
        }
        if (this.mc.level != null) {
            return this.mc.level.recipeAccess();
        }
        return null;
    }

    public void onClientTickPost(Minecraft mc) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (this.clearWeatherTimer > 0) {
                --this.clearWeatherTimer;
            }
            if (this.rainWeatherTimer > 0) {
                --this.rainWeatherTimer;
            }
            if (this.thunderWeatherTimer > 0) {
                --this.thunderWeatherTimer;
            }
        }
    }

    public void onServerWeatherTick(int clearTime, int rainTime, int thunderTime, boolean isRaining, boolean isThunder) {
        this.clearWeatherTimer = clearTime;
        this.rainWeatherTimer = rainTime;
        this.thunderWeatherTimer = thunderTime;
        this.isRaining = isRaining;
        this.isThundering = isThunder;
    }

    public void onHudDataSyncToggled(ConfigBoolean config) {
        if (this.hasInValidServux) {
            this.reset(true);
        }
        if (this.hasServuxServer() && !config.getBooleanValue()) {
            this.unregisterChannel();
        } else {
            this.shouldRegister = true;
            this.registerChannel();
        }
    }

    public void registerChannel() {
        this.shouldRegister = true;
        if (!(this.hasServuxServer() || DataStorage.getInstance().hasIntegratedServer() || this.hasInValidServux)) {
            this.onWorldPre();
            this.requestMetadata();
        } else {
            this.shouldRegister = false;
        }
    }

    public void requestMetadata() {
        if (!DataStorage.getInstance().hasIntegratedServer() && Configs.Generic.HUD_DATA_SYNC.getBooleanValue() && HANDLER.isPlayRegistered(HANDLER.getPayloadChannel())) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxHudPacket.MetadataRequest(nbt));
        }
    }

    public ResourceKey<Level> getWorldType(String in) {
        return switch (in) {
            case "minecraft:the_nether" -> Level.NETHER;
            case "minecraft:the_end" -> Level.END;
            default -> Level.OVERWORLD;
        };
    }

    public boolean receiveMetadata(CompoundTag data) {
        if (!this.servuxServer && !DataStorage.getInstance().hasIntegratedServer() && this.shouldRegister) {
            int ver = data.getIntOr("version", -1);
            MiniHUD.debugLog("HudDataStorage#receiveMetadata(): received METADATA from Servux", new Object[0]);
            if (ver != 2) {
                MiniHUD.LOGGER.warn("hudDataChannel: Mis-matched protocol version!");
            }
            this.setServuxVersion(data.getStringOr("servux", "?"), ver);
            this.setWorldSpawn(new GlobalPos(this.getWorldType(data.getString("spawnDimension").orElse(Level.OVERWORLD.location().toString())), new BlockPos(data.getIntOr("spawnPosX", 0), data.getIntOr("spawnPosY", 0), data.getIntOr("spawnPosZ", 0))));
            if (data.contains("worldSeed")) {
                this.setWorldSeed(data.getLongOr("worldSeed", -1L));
            }
            this.setIsServuxServer();
            if (Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
                this.requestRecipeManager();
                this.refreshDataLoggers();
                return true;
            }
            this.unregisterChannel();
        }
        return false;
    }

    public void unregisterChannel() {
        if (this.hasServuxServer() || !Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
            this.servuxServer = false;
            if (!this.hasInValidServux) {
                MiniHUD.debugLog("HudDataManager#unregisterChannel(): for {}", this.servuxVersion != null ? this.servuxVersion : "<unknown>");
                HANDLER.unregisterPlayReceiver();
                HANDLER.reset(HANDLER.getPayloadChannel());
            }
        }
        this.shouldRegister = false;
    }

    public void requestSpawnMetadata() {
        if (!DataStorage.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxHudPacket.SpawnRequest(nbt));
        }
    }

    public void receiveSpawnMetadata(CompoundTag data) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            int ver = data.getIntOr("version", -1);
            MiniHUD.debugLog("HudDataStorage#receiveSpawnMetadata(): from Servux", new Object[0]);
            this.setServuxVersion(data.getStringOr("servux", "?"), ver);
            this.setWorldSpawn(new GlobalPos(this.getWorldType(data.getString("spawnDimension").orElse(Level.OVERWORLD.location().toString())), new BlockPos(data.getIntOr("spawnPosX", 0), data.getIntOr("spawnPosY", 0), data.getIntOr("spawnPosZ", 0))));
            if (data.contains("worldSeed")) {
                this.setWorldSeed(data.getLongOr("worldSeed", -1L));
            }
            if (Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
                if (!this.hasServuxServer()) {
                    this.registerChannel();
                }
            } else {
                this.unregisterChannel();
                this.shouldRegister = false;
            }
        }
    }

    public void refreshDataLoggers() {
        if (!DataStorage.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
            if (this.servuxProtocolVersion >= 2) {
                CompoundTag nbt = new CompoundTag();
                MiniHUD.debugLog("refreshDataLoggers: TPS: [{}] / MobCaps: [{}]", InfoToggle.SERVER_TPS.getBooleanValue(), InfoToggle.MOB_CAPS.getBooleanValue());
                nbt.putBoolean(ServuxDataLogger.TPS.name(), InfoToggle.SERVER_TPS.getBooleanValue());
                nbt.putBoolean(ServuxDataLogger.MOB_CAPS.name(), InfoToggle.MOB_CAPS.getBooleanValue());
                HANDLER.encodeClientData(ServuxHudPacket.DataLoggerRequest(nbt));
            } else {
                MiniHUD.LOGGER.warn("refreshDataLoggers: Incompatible Servux version detected!");
            }
        }
    }

    public void receiveDataLogger(CompoundTag nbt) {
        if (this.hasServuxServer() && nbt != null && !nbt.isEmpty()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            block8: for (String key : nbt.keySet()) {
                CompoundTag entry;
                ServuxDataLogger type = ServuxDataLogger.fromStringStatic(key);
                if (type == null || (entry = (CompoundTag)nbt.read(key, type.codec()).orElse(null)) == null) continue;
                switch (type) {
                    case TPS: {
                        try {
                            ServuxTickData data = (ServuxTickData)((Pair)ServuxTickData.CODEC.decode((DynamicOps)mc.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)entry).getOrThrow()).getFirst();
                            if (data == null) continue block8;
                            if (!TickUtils.getInstance().isUsingDirectServerData()) {
                                TickUtils.getInstance().toggleUseDirectServerData(true);
                            }
                            TickUtils.getInstance().updateNanoTickFromServux(data.tps(), data.mspt(), data.sprintTicks(), data.frozen(), data.sprinting(), data.stepping());
                        }
                        catch (Exception err) {
                            MiniHUD.LOGGER.error("receiveDataLogger: TPS / Exception; {}", (Object)err.getLocalizedMessage());
                        }
                        break;
                    }
                    case MOB_CAPS: {
                        String dimKey = mc.level.dimension().location().toString();
                        if (!entry.contains(dimKey)) break;
                        CompoundTag nbtEntry = entry.getCompoundOrEmpty(dimKey);
                        try {
                            long worldTick = nbtEntry.getLongOr("WorldTick", mc.level.getGameTime());
                            nbtEntry.remove("WorldTick");
                            MobCapData serverData = (MobCapData)((Pair)MobCapData.CODEC.decode((DynamicOps)mc.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbtEntry).getOrThrow()).getFirst();
                            if (serverData == null) continue block8;
                            DataStorage.getInstance().getMobCapData().setFromServuxData(serverData, worldTick);
                            break;
                        }
                        catch (Exception err) {
                            MiniHUD.LOGGER.error("receiveDataLogger: MobCaps / Exception; {}", (Object)err.getLocalizedMessage());
                        }
                    }
                }
            }
        }
    }

    public void receiveWeatherData(CompoundTag data) {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (data.contains("SetRaining")) {
                this.rainWeatherTimer = data.getIntOr("SetRaining", -1);
            }
            if (data.contains("isRaining")) {
                this.isRaining = data.getBooleanOr("isRaining", false);
            }
            if (data.contains("SetThundering")) {
                this.thunderWeatherTimer = data.getIntOr("SetThundering", -1);
            }
            if (data.contains("isThundering")) {
                this.isThundering = data.getBooleanOr("isThundering", false);
            }
            if (data.contains("SetClear")) {
                this.clearWeatherTimer = data.getIntOr("SetClear", -1);
            }
            if (!this.hasServuxServer() && DataStorage.getInstance().hasServuxServer()) {
                this.isThundering = this.thunderWeatherTimer > 0 && !this.isThundering;
                boolean bl = this.isRaining = this.rainWeatherTimer > 0 && !this.isRaining;
            }
            if (Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
                if (!this.hasServuxServer()) {
                    this.registerChannel();
                }
            } else {
                this.unregisterChannel();
                this.shouldRegister = false;
            }
        }
    }

    public void requestRecipeManager() {
        if (!DataStorage.getInstance().hasIntegratedServer() && this.hasServuxServer()) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxHudPacket.RecipeManagerRequest(nbt));
        }
    }

    public void receiveRecipeManager(CompoundTag data) {
        if (!DataStorage.getInstance().hasIntegratedServer() && data.contains("RecipeManager")) {
            ArrayList<RecipeHolder> recipes = new ArrayList<RecipeHolder>();
            ListTag list = data.getListOrEmpty("RecipeManager");
            int count = 0;
            this.preparedRecipes = RecipeMap.EMPTY;
            this.recipeCount = 0;
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag item = list.getCompoundOrEmpty(i);
                ResourceLocation idReg = ResourceLocation.tryParse((String)item.getStringOr("id_reg", ""));
                ResourceLocation idValue = ResourceLocation.tryParse((String)item.getStringOr("id_value", ""));
                if (idReg == null || idValue == null) continue;
                try {
                    ResourceKey key = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)idReg), (ResourceLocation)idValue);
                    Pair pair = (Pair)Recipe.CODEC.decode((DynamicOps)DataStorage.getInstance().getWorldRegistryManager().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)item.getCompoundOrEmpty("recipe")).getOrThrow();
                    RecipeHolder entry = new RecipeHolder(key, (Recipe)pair.getFirst());
                    recipes.add(entry);
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("receiveRecipeManager: index [{}], Exception reading packet, {}", (Object)i, (Object)e.getMessage());
                }
            }
            if (!recipes.isEmpty()) {
                this.preparedRecipes = RecipeMap.create(recipes);
                this.recipeCount = count;
                MiniHUD.debugLog("HudDataStorage#receiveRecipeManager(): finished loading Recipe Manager: Read [{}] Recipes from Servux", count);
            } else {
                MiniHUD.LOGGER.warn("receiveRecipeManager: failed to read Recipe Manager from Servux (Collection was empty!)");
            }
            if (Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
                if (!this.hasServuxServer()) {
                    this.registerChannel();
                }
            } else {
                this.unregisterChannel();
                this.shouldRegister = false;
            }
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.worldSeedValid) {
            obj.add("seed", (JsonElement)new JsonPrimitive((Number)this.worldSeed));
        }
        if (this.isSpawnChunkRadiusKnown()) {
            obj.add("spawn_chunk_radius", (JsonElement)new JsonPrimitive((Number)this.spawnChunkRadius));
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        int spawnRadiusTmp;
        if (JsonUtils.hasLong((JsonObject)obj, (String)"seed")) {
            long seedTmp = JsonUtils.getLong((JsonObject)obj, (String)"seed");
            if (DataStorage.getInstance().hasIntegratedServer() && this.hasStoredWorldSeed() && this.worldSeed != seedTmp) {
                MiniHUD.debugLog("HudDataStorage#fromJson(): ignoring stale WorldSeed [{}], keeping [{}] as valid from the integrated server", seedTmp, this.worldSeed);
            } else {
                this.setWorldSeed(seedTmp);
            }
        }
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"spawn_chunk_radius") && this.spawnChunkRadius != (spawnRadiusTmp = JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"spawn_chunk_radius", (int)-1)) && spawnRadiusTmp > 0) {
            this.setSpawnChunkRadius(spawnRadiusTmp, false);
        }
    }
}

