/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.data.MobCapData;
import fi.dy.masa.minihud.util.MiscUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;

public class MobCapDataHandler {
    protected static final Pattern PATTERN_CARPET_MOBCAPS = Pattern.compile("(?<hocu>[0-9-]+)/(?<hoca>-?[0-9]+),(?<pacu>[0-9-]+)/(?<paca>-?[0-9]+),(?<amcu>[0-9-]+)/(?<amca>-?[0-9]+),(?<axcu>[0-9-]+)/(?<axca>-?[0-9]+),(?<uwccu>[0-9-]+)/(?<uwcca>-?[0-9]+),(?<wccu>[0-9-]+)/(?<wcca>-?[0-9]+),(?<wacu>[0-9-]+)/(?<waca>-?[0-9]+),(?<micu>[0-9-]+)/(?<mica>-?[0-9]+)");
    protected static final MobCapData.EntityCategory[] ENTITY_CATEGORIES = MobCapData.EntityCategory.values();
    protected final Minecraft mc = Minecraft.getInstance();
    protected final MobCapData localData = new MobCapData();
    protected final MobCapData parsedServerData = new MobCapData();
    protected final MobCapData subscribedServerData = new MobCapData();
    protected long lastSyncWorldTick = -1L;

    public void clear() {
        this.localData.clear();
        this.parsedServerData.clear();
        this.subscribedServerData.clear();
        this.lastSyncWorldTick = -1L;
    }

    public boolean getHasValidData() {
        return this.subscribedServerData.getHasValidData() || this.parsedServerData.getHasValidData() || this.localData.getHasValidData();
    }

    public boolean shouldParsePlayerListData(long worldTick) {
        return !this.subscribedServerData.getHasRecentValidData(worldTick) && !this.localData.getHasRecentValidData(worldTick);
    }

    public MobCapData getMobCapData() {
        if (this.subscribedServerData.getHasValidData()) {
            return this.subscribedServerData;
        }
        if (this.parsedServerData.getHasValidData()) {
            return this.parsedServerData;
        }
        return this.localData;
    }

    public long getLastSyncedTick() {
        return this.lastSyncWorldTick;
    }

    public void putCarpetSubscribedMobCapCurrentValue(String name, int currentValue) {
        MobCapData.EntityCategory type = MobCapData.EntityCategory.fromVanillaCategoryName(name);
        if (type != null) {
            this.putCurrentValue(this.subscribedServerData, type, currentValue);
        }
    }

    public void putCarpetSubscribedMobCapCapValue(String name, int capValue) {
        MobCapData.EntityCategory type = MobCapData.EntityCategory.fromVanillaCategoryName(name);
        if (type != null) {
            this.putCapValue(this.subscribedServerData, type, capValue);
        }
    }

    public void putServerSubscribedMobCapValues(MobCapData.EntityCategory type, int currentValue, int capValue) {
        this.putServerSubscribedMobCapCurrentValue(type, currentValue);
        this.putServerSubscribedMobCapCapValue(type, capValue);
    }

    public void putServerSubscribedMobCapCurrentValue(MobCapData.EntityCategory type, int currentValue) {
        this.putCurrentValue(this.subscribedServerData, type, currentValue);
    }

    public void putServerSubscribedMobCapCapValue(MobCapData.EntityCategory type, int capValue) {
        this.putCapValue(this.subscribedServerData, type, capValue);
    }

    protected void putCurrentValue(MobCapData data, MobCapData.EntityCategory type, int currentValue) {
        data.setCurrentValue(type, currentValue, this.getWorldTick());
    }

    protected void putCapValue(MobCapData data, MobCapData.EntityCategory type, int capValue) {
        data.setCapValue(type, capValue, this.getWorldTick());
    }

    protected long getWorldTick() {
        return this.mc.level.getGameTime();
    }

    private void setPlayerListParsedData(MobCapData.EntityCategory type, int currentValue, int capValue, long worldTick) {
        if (!this.subscribedServerData.getHasRecentValidData(worldTick)) {
            this.parsedServerData.setCurrentAndCapValues(type, currentValue, capValue, worldTick);
        }
    }

    protected void setFromServuxData(MobCapData serverData, long worldTick) {
        if (!this.subscribedServerData.getHasRecentValidData(worldTick)) {
            this.parsedServerData.setFromServuxMobCapData(serverData, worldTick);
        }
    }

    public void updateIntegratedServerMobCaps() {
        if (this.mc.hasSingleplayerServer() && this.mc.level != null) {
            IntegratedServer server = this.mc.getSingleplayerServer();
            ResourceKey dim = this.mc.level.dimension();
            if (server == null) {
                return;
            }
            server.execute(() -> this.lambda$updateIntegratedServerMobCaps$1((MinecraftServer)server, dim));
        }
    }

    public void parsePlayerListFooterMobCapData(Component textComponent) {
        if (this.mc.level == null || !InfoToggle.MOB_CAPS.getBooleanValue()) {
            return;
        }
        long worldTick = this.getWorldTick();
        if (!this.shouldParsePlayerListData(worldTick)) {
            return;
        }
        String str = textComponent.getString();
        if (!str.isEmpty()) {
            String[] lines;
            String text = ChatFormatting.stripFormatting((String)str);
            for (String line : lines = text.split("\n")) {
                Matcher matcher = PATTERN_CARPET_MOBCAPS.matcher(line);
                if (!matcher.matches()) continue;
                try {
                    int hoCu = MobCapDataHandler.parseMobCapValue(matcher, "hocu");
                    int hoCa = MobCapDataHandler.parseMobCapValue(matcher, "hoca");
                    int paCu = MobCapDataHandler.parseMobCapValue(matcher, "pacu");
                    int paCa = MobCapDataHandler.parseMobCapValue(matcher, "paca");
                    int amCu = MobCapDataHandler.parseMobCapValue(matcher, "amcu");
                    int amCa = MobCapDataHandler.parseMobCapValue(matcher, "amca");
                    int axCu = MobCapDataHandler.parseMobCapValue(matcher, "axcu");
                    int axCa = MobCapDataHandler.parseMobCapValue(matcher, "axca");
                    int uwcCu = MobCapDataHandler.parseMobCapValue(matcher, "uwccu");
                    int uwcCa = MobCapDataHandler.parseMobCapValue(matcher, "uwcca");
                    int wcCu = MobCapDataHandler.parseMobCapValue(matcher, "wccu");
                    int wcCa = MobCapDataHandler.parseMobCapValue(matcher, "wcca");
                    int waCu = MobCapDataHandler.parseMobCapValue(matcher, "wacu");
                    int waCa = MobCapDataHandler.parseMobCapValue(matcher, "waca");
                    int miCu = MobCapDataHandler.parseMobCapValue(matcher, "micu");
                    int miCa = MobCapDataHandler.parseMobCapValue(matcher, "mica");
                    this.setPlayerListParsedData(MobCapData.EntityCategory.MONSTER, hoCu, hoCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.CREATURE, paCu, paCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.AMBIENT, amCu, amCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.AXOLOTLS, axCu, axCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.UNDERGROUND_WATER_CREATURE, uwcCu, uwcCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.WATER_CREATURE, wcCu, wcCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.WATER_AMBIENT, waCu, waCa, worldTick);
                    this.setPlayerListParsedData(MobCapData.EntityCategory.MISC, miCu, miCa, worldTick);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected static int parseMobCapValue(Matcher matcher, String groupName) {
        String str = matcher.group(groupName);
        return str.equals("-") ? 0 : Integer.parseInt(str);
    }

    public String getFormattedInfoLine() {
        MobCapData data = this.getMobCapData();
        if (!data.getHasValidData()) {
            return StringUtils.translate((String)"minihud.info_line.mobcap.no_data", (Object[])new Object[0]);
        }
        return StringUtils.translate((String)"minihud.info_line.mobcap.data", (Object[])new Object[]{this.getCapString(MobCapData.EntityCategory.MONSTER, data), this.getCapString(MobCapData.EntityCategory.CREATURE, data), this.getCapString(MobCapData.EntityCategory.AMBIENT, data), this.getCapString(MobCapData.EntityCategory.AXOLOTLS, data), this.getCapString(MobCapData.EntityCategory.UNDERGROUND_WATER_CREATURE, data), this.getCapString(MobCapData.EntityCategory.WATER_CREATURE, data), this.getCapString(MobCapData.EntityCategory.WATER_AMBIENT, data), this.getCapString(MobCapData.EntityCategory.MISC, data)});
    }

    private String getCapString(MobCapData.EntityCategory type, MobCapData data) {
        MobCapData.Cap capData = data.getCap(type);
        String keyStart = "minihud.info_line.mobcap.cap.";
        String key = keyStart + type.getName() + (capData.isFull() ? ".full" : ".nonfull");
        return StringUtils.translate((String)key, (Object[])new Object[]{capData.getCurrent(), capData.getCap()});
    }

    private /* synthetic */ void lambda$updateIntegratedServerMobCaps$1(MinecraftServer server, ResourceKey dim) {
        ServerLevel world = server.getLevel(dim);
        if (world != null) {
            MobCapData.Cap[] data = MobCapData.createCapArray();
            NaturalSpawner.SpawnState info = world.getChunkSource().getLastSpawnState();
            if (info != null) {
                int spawnableChunks = MiscUtils.getSpawnableChunksCount(world);
                int divisor = 289;
                long worldTime = world.getGameTime();
                for (Object2IntMap.Entry entry : info.getMobCategoryCounts().object2IntEntrySet()) {
                    MobCapData.EntityCategory category = MobCapData.EntityCategory.fromVanillaCategory((MobCategory)entry.getKey());
                    int current = entry.getIntValue();
                    int cap = ((MobCategory)entry.getKey()).getMaxInstancesPerChunk() * spawnableChunks / divisor;
                    data[category.ordinal()].setCurrentAndCap(current, cap);
                }
                this.mc.execute(() -> {
                    for (MobCapData.EntityCategory type : ENTITY_CATEGORIES) {
                        MobCapData.Cap cap = data[type.ordinal()];
                        this.localData.setCurrentAndCapValues(type, cap.getCurrent(), cap.getCap(), worldTime);
                    }
                });
            }
        }
    }
}

