/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import com.mojang.blaze3d.pipeline.RenderTarget;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.malilib.util.nbt.NbtInventory;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.DebugDataManager;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.info.InfoLineChunkCache;
import fi.dy.masa.minihud.mixin.world.IMixinServerWorld;
import fi.dy.masa.minihud.renderer.InventoryOverlayHandler;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.IServerEntityManager;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.SpeedUnits;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final Minecraft mc;
    private final DataStorage data;
    private final HudDataManager hudData;
    private final Date date;
    private final Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    private long infoUpdateTime;
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();
    private Pair<BlockEntity, CompoundTag> lastBlockEntity = null;
    private Pair<Entity, CompoundTag> lastEntity = null;
    private Pair<Entity, CompoundTag> lastEnderItems = null;

    public RenderHandler() {
        this.mc = Minecraft.getInstance();
        this.data = DataStorage.getInstance();
        this.hudData = HudDataManager.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public HudDataManager getHudData() {
        return this.hudData;
    }

    public static void fixDebugRendererState() {
    }

    public void onRenderGameOverlayPostAdvanced(GuiGraphics drawContext, float partialTicks, ProfilerFiller profiler, Minecraft mc) {
        if (!Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue()) {
            InfoLineChunkCache.INSTANCE.onReset();
            return;
        }
        if (!(DebugDataManager.getInstance().shouldShowDebugHudFix() || mc.player == null || mc.options.hideGui || Configs.Generic.REQUIRE_SNEAK.getBooleanValue() && !mc.player.isShiftKeyDown() || !Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld())) {
            long currentTime = System.nanoTime();
            if (currentTime - this.infoUpdateTime >= 50000000L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((GuiGraphics)drawContext, (int)x, (int)y, (double)Configs.Generic.FONT_SCALE.getDoubleValue(), (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, (boolean)Configs.Generic.HUD_STATUS_EFFECTS_SHIFT.getBooleanValue(), this.lines);
        }
        if (Configs.Generic.INVENTORY_PREVIEW_ENABLED.getBooleanValue() && Configs.Generic.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
            InventoryOverlayHandler.getInstance().getRenderContext(drawContext, profiler, mc);
        }
    }

    public void onRenderWorldPreWeather(RenderTarget fb, Matrix4f posMatrix, Matrix4f projMatrix, Frustum frustum, Camera camera, RenderBuffers buffers, ProfilerFiller profiler) {
    }

    public void onRenderWorldLastAdvanced(RenderTarget fb, Matrix4f posMatrix, Matrix4f projMatrix, Frustum frustum, Camera camera, RenderBuffers buffers, ProfilerFiller profiler) {
        if (Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && this.mc.level != null && this.mc.player != null && !this.mc.options.hideGui) {
            OverlayRenderer.renderOverlays(posMatrix, projMatrix, this.mc, frustum, camera, profiler);
        }
    }

    public void onRenderTooltipLast(GuiGraphics drawContext, ItemStack stack, int x, int y) {
        Item item = stack.getItem();
        if (item instanceof MapItem) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue() && (!Configs.Generic.MAP_PREVIEW_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderMapPreview((GuiGraphics)drawContext, (ItemStack)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue(), (boolean)false);
            }
        } else if (stack.getComponents().has(DataComponents.CONTAINER) && InventoryUtils.shulkerBoxHasItems((ItemStack)stack)) {
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
                RenderUtils.renderShulkerBoxPreview((GuiGraphics)drawContext, (ItemStack)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
        } else if (stack.is(Items.ENDER_CHEST) && Configs.Generic.SHULKER_DISPLAY_ENDER_CHEST.getBooleanValue()) {
            Level world;
            Player player;
            if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue() && (!Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown()) && (player = (world = WorldUtils.getBestWorld((Minecraft)this.mc)).getPlayerByUUID(this.mc.player.getUUID())) != null) {
                PlayerEnderChestContainer inv;
                Pair<Entity, CompoundTag> pair = EntitiesDataManager.getInstance().requestEntity(world, player.getId());
                if (pair != null && pair.getRight() != null && ((CompoundTag)pair.getRight()).contains("EnderItems")) {
                    inv = InventoryUtils.getPlayerEnderItemsFromNbt((CompoundTag)((CompoundTag)pair.getRight()), (RegistryAccess)world.registryAccess());
                    this.lastEnderItems = pair;
                } else {
                    Player pe;
                    Object object;
                    inv = pair != null && (object = pair.getLeft()) instanceof Player && !(pe = (Player)object).getEnderChestInventory().isEmpty() ? pe.getEnderChestInventory() : (this.lastEnderItems != null ? InventoryUtils.getPlayerEnderItemsFromNbt((CompoundTag)((CompoundTag)this.lastEnderItems.getRight()), (RegistryAccess)world.registryAccess()) : player.getEnderChestInventory());
                }
                if (inv != null) {
                    try (NbtInventory nbtInv = NbtInventory.fromInventory((Container)inv);){
                        CompoundTag nbt = new CompoundTag();
                        ListTag list = nbtInv.toNbtList(world.registryAccess());
                        nbt.put("EnderItems", (Tag)list);
                        RenderUtils.renderNbtItemsPreview((GuiGraphics)drawContext, (ItemStack)stack, (CompoundTag)nbt, (int)x, (int)y, (boolean)false);
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (stack.getComponents().has(DataComponents.BUNDLE_CONTENTS) && InventoryUtils.bundleHasItems((ItemStack)stack) && Configs.Generic.BUNDLE_PREVIEW.getBooleanValue() && (!Configs.Generic.BUNDLE_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown())) {
            RenderUtils.renderBundlePreview((GuiGraphics)drawContext, (ItemStack)stack, (int)x, (int)y, (int)Configs.Generic.BUNDLE_DISPLAY_ROW_WIDTH.getIntegerValue(), (boolean)Configs.Generic.BUNDLE_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
        }
    }

    public Supplier<String> getProfilerSectionSupplier() {
        return () -> "minihud_renderer";
    }

    public void onRenderTooltipComponentInsertFirst(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
    }

    public void onRenderTooltipComponentInsertMiddle(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        if (Configs.Generic.BUNDLE_TOOLTIPS.getBooleanValue() && stack.getItem() instanceof BundleItem) {
            MiscUtils.addBundleTooltip(stack, list);
        }
    }

    public void onRenderTooltipComponentInsertLast(Item.TooltipContext context, ItemStack stack, Consumer<Component> list) {
        BlockItem blockItem;
        Item item;
        if (Configs.Generic.AXOLOTL_TOOLTIPS.getBooleanValue() && stack.getItem() == Items.AXOLOTL_BUCKET) {
            MiscUtils.addAxolotlTooltip(stack, list);
        }
        if (Configs.Generic.BEE_TOOLTIPS.getBooleanValue() && stack.has(DataComponents.BEES)) {
            MiscUtils.addBeeTooltip(stack, list);
        }
        if (Configs.Generic.CUSTOM_MODEL_TOOLTIPS.getBooleanValue() && stack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            MiscUtils.addCustomModelTooltip(stack, list);
        }
        if (Configs.Generic.FOOD_TOOLTIPS.getBooleanValue() && stack.has(DataComponents.FOOD)) {
            MiscUtils.addFoodTooltip(stack, list);
        }
        if (Configs.Generic.HONEY_TOOLTIPS.getBooleanValue() && (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof BeehiveBlock) {
            MiscUtils.addHoneyTooltip(stack, list);
        }
        if (Configs.Generic.LODESTONE_TOOLTIPS.getBooleanValue() && stack.has(DataComponents.LODESTONE_TRACKER)) {
            MiscUtils.addLodestoneTooltip(stack, list);
        }
    }

    public int getSubtitleOffset() {
        if (Configs.Generic.OFFSET_SUBTITLE_HUD.getBooleanValue() && Configs.Generic.MAIN_RENDERING_TOGGLE.getBooleanValue() && Configs.Generic.HUD_ALIGNMENT.getOptionListValue() == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * Configs.Generic.FONT_SCALE.getDoubleValue());
            return -(offset - 16);
        }
        return 0;
    }

    public void updateData(Minecraft mc) {
        if (mc.level != null && RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            DataStorage.getInstance().updateStructureData();
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        InfoLineChunkCache.INSTANCE.onUpdate();
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    private void processEntries(List<InfoLine.Entry> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (InfoLine.Entry entry : list) {
            if (entry.isEmpty()) continue;
            if (entry.isTranslated()) {
                this.addLine(entry.format());
                continue;
            }
            if (entry.hasArgs()) {
                this.addLineI18n(entry.format(), entry.args());
                continue;
            }
            this.addLineI18n(entry.format(), new Object[0]);
        }
    }

    public void addLine(String text) {
        this.lineWrappers.add(new StringHolder(this, text));
    }

    public void addLineI18n(String translatedName, Object ... args) {
        this.addLine(StringUtils.translate((String)translatedName, (Object[])args));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addLine(InfoToggle type) {
        Minecraft mc = this.mc;
        Entity entity = mc.getCameraEntity();
        if (entity == null) return;
        Level level = entity.level();
        Level world = level;
        if (world == null) return;
        if (mc.level == null) {
            return;
        }
        double y = entity.getY();
        BlockPos pos = BlockPos.containing((double)entity.getX(), (double)y, (double)entity.getZ());
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean isChunkLoaded = mc.level.hasChunkAt(pos);
        SpeedUnits speedUnits = (SpeedUnits)Configs.Generic.SPEED_UNITS.getOptionListValue();
        if (!isChunkLoaded) {
            return;
        }
        if (type == InfoToggle.FPS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.GPU) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.MEMORY_USAGE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_REAL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_WORLD) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_WORLD_FORMATTED) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_DAY_MODULO) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.TIME_TOTAL_MODULO) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        }
        if (type == InfoToggle.SERVER_TPS) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.SERVUX) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.WEATHER) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.MOB_CAPS) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        }
        if (type == InfoToggle.PING) {
            PlayerInfo info = mc.player.connection.getPlayerInfo(mc.player.getUUID());
            if (info == null) return;
            this.addLineI18n("minihud.info_line.ping", info.getLatency());
            return;
        }
        if (type == InfoToggle.COORDINATES || type == InfoToggle.COORDINATES_SCALED || type == InfoToggle.DIMENSION) {
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES)) return;
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES_SCALED)) return;
            if (this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            String fmtStr = Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue();
            double x = entity.getX();
            double z = entity.getZ();
            if (InfoToggle.COORDINATES.getBooleanValue()) {
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                    }
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                }
                pre = " / ";
            }
            if (InfoToggle.COORDINATES_SCALED.getBooleanValue() && (world.dimension() == Level.NETHER || world.dimension() == Level.OVERWORLD)) {
                boolean isNether = world.dimension() == Level.NETHER;
                double scale = isNether ? 8.0 : 0.125;
                x *= scale;
                z *= scale;
                str.append(pre);
                if (isNether) {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.overworld", (Object[])new Object[0]));
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates_scaled.nether", (Object[])new Object[0]));
                }
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(fmtStr, x, y, z));
                    }
                    catch (Exception e) {
                        str.append(StringUtils.translate((String)"minihud.info_line.coordinates.exception", (Object[])new Object[0]));
                    }
                } else {
                    str.append(StringUtils.translate((String)"minihud.info_line.coordinates.format", (Object[])new Object[]{x, y, z}));
                }
                pre = " / ";
            }
            if (InfoToggle.DIMENSION.getBooleanValue()) {
                String dimName = world.dimension().location().toString();
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.dimension", (Object[])new Object[0])).append(dimName);
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.COORDINATES);
            this.addedTypes.add(InfoToggle.COORDINATES_SCALED);
            this.addedTypes.add(InfoToggle.DIMENSION);
            return;
        }
        if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
            if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS)) return;
            if (this.addedTypes.contains((Object)InfoToggle.CHUNK_POS)) return;
            if (this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(256);
            if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                try {
                    String fmt = Configs.Generic.BLOCK_POS_FORMAT_STRING.getStringValue();
                    str.append(String.format(fmt, pos.getX(), pos.getY(), pos.getZ()));
                }
                catch (Exception e) {
                    str.append(StringUtils.translate((String)"minihud.info_line.block_pos.exception", (Object[])new Object[0]));
                }
                pre = " / ";
            }
            if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.chunk_pos", (Object[])new Object[]{chunkPos.x, pos.getY() >> 4, chunkPos.z}));
                pre = " / ";
            }
            if (InfoToggle.REGION_FILE.getBooleanValue()) {
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.region_file", (Object[])new Object[]{pos.getX() >> 9, pos.getZ() >> 9}));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.BLOCK_POS);
            this.addedTypes.add(InfoToggle.CHUNK_POS);
            this.addedTypes.add(InfoToggle.REGION_FILE);
            return;
        }
        if (type == InfoToggle.BLOCK_IN_CHUNK) {
            this.addLineI18n("minihud.info_line.block_in_chunk", pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF, chunkPos.x, pos.getY() >> 4, chunkPos.z);
            return;
        } else if (type == InfoToggle.BLOCK_BREAK_SPEED) {
            this.addLineI18n("minihud.info_line.block_break_speed", DataStorage.getInstance().getBlockBreakingSpeed());
            return;
        } else if (type == InfoToggle.SPRINTING && mc.player.isSprinting()) {
            this.addLineI18n("minihud.info_line.sprinting", new Object[0]);
            return;
        } else if (type == InfoToggle.DISTANCE) {
            Vec3 ref = DataStorage.getInstance().getDistanceReferencePoint();
            double dist = Math.sqrt(ref.distanceToSqr(entity.getX(), entity.getY(), entity.getZ()));
            this.addLineI18n("minihud.info_line.distance", dist, entity.getX() - ref.x, entity.getY() - ref.y, entity.getZ() - ref.z, ref.x, ref.y, ref.z);
            return;
        } else if (type == InfoToggle.FACING) {
            String str;
            Direction facing = entity.getDirection();
            String facingName = StringUtils.translate((String)("minihud.info_line.facing." + facing.name().toLowerCase() + ".name"), (Object[])new Object[0]);
            if (facingName.contains("minihud.info_line.facing." + facing.name().toLowerCase() + ".name")) {
                facingName = facing.name().toLowerCase();
                str = StringUtils.translate((String)"minihud.info_line.invalid_value", (Object[])new Object[0]);
            } else {
                str = StringUtils.translate((String)("minihud.info_line.facing." + facing.name().toLowerCase()), (Object[])new Object[0]);
            }
            this.addLineI18n("minihud.info_line.facing", facingName, str);
            return;
        } else if (type == InfoToggle.LIGHT_LEVEL) {
            LevelChunk clientChunk = InfoLineChunkCache.INSTANCE.getClientChunk(chunkPos);
            if (clientChunk.isEmpty()) return;
            LevelLightEngine lightingProvider = world.getChunkSource().getLightEngine();
            this.addLineI18n("minihud.info_line.light_level", lightingProvider.getLayerListener(LightLayer.BLOCK).getLightValue(pos));
            return;
        } else if (type == InfoToggle.BEE_COUNT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            Pair<BlockEntity, CompoundTag> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (BlockEntity)pair.getLeft(), null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.COMPARATOR_OUTPUT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            Pair<BlockEntity, CompoundTag> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (BlockEntity)pair.getLeft(), null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.HONEY_LEVEL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            BlockState state = this.getTargetedBlock(mc);
            if (state == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, null, state, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.FURNACE_XP) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            Pair<BlockEntity, CompoundTag> pair = this.getTargetedBlockEntity(bestWorld, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, (BlockEntity)pair.getLeft(), null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.HORSE_SPEED || type == InfoToggle.HORSE_JUMP) {
            InfoLine.Context ctx;
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(bestWorld, mc);
            if (mc.player.isPassenger() && pair == null) {
                ctx = new InfoLine.Context(bestWorld, mc.player.getVehicle(), null, null, null, null);
            } else {
                if (pair == null) return;
                ctx = new InfoLine.Context(bestWorld, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            }
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW)) return;
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH)) return;
            if (this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
                str.append(StringUtils.translate((String)"minihud.info_line.rotation_yaw", (Object[])new Object[]{Float.valueOf(Mth.wrapDegrees((float)entity.getYRot()))}));
                pre = " / ";
            }
            if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
                str.append(pre).append(StringUtils.translate((String)"minihud.info_line.rotation_pitch", (Object[])new Object[]{Float.valueOf(Mth.wrapDegrees((float)entity.getXRot()))}));
                pre = " / ";
            }
            if (InfoToggle.SPEED.getBooleanValue()) {
                double dx = entity.getX() - entity.xOld;
                double dy = entity.getY() - entity.yOld;
                double dz = entity.getZ() - entity.zOld;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                str.append(pre).append(StringUtils.translate((String)("minihud.info_line.speed_" + speedUnits.suffix), (Object[])new Object[]{speedUnits.convert(dist * 20.0)}));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.ROTATION_YAW);
            this.addedTypes.add(InfoToggle.ROTATION_PITCH);
            this.addedTypes.add(InfoToggle.SPEED);
            return;
        } else if (type == InfoToggle.SPEED_HV) {
            double dx = entity.getX() - entity.xOld;
            double dy = entity.getY() - entity.yOld;
            double dz = entity.getZ() - entity.zOld;
            this.addLineI18n("minihud.info_line.speed_hv_" + speedUnits.suffix, speedUnits.convert(Math.sqrt(dx * dx + dz * dz) * 20.0), speedUnits.convert(dy * 20.0));
            return;
        } else if (type == InfoToggle.SPEED_AXIS) {
            double dx = entity.getX() - entity.xOld;
            double dy = entity.getY() - entity.yOld;
            double dz = entity.getZ() - entity.zOld;
            this.addLineI18n("minihud.info_line.speed_axis_" + speedUnits.suffix, speedUnits.convert(dx * 20.0), speedUnits.convert(dy * 20.0), speedUnits.convert(dz * 20.0));
            return;
        } else if (type == InfoToggle.CHUNK_SECTIONS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.CHUNK_UPDATES) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PANDA_GENE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PARTICLE_COUNT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(null, null, null, null, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.DIFFICULTY) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.BIOME) {
            LevelChunk clientChunk = InfoLineChunkCache.INSTANCE.getClientChunk(chunkPos);
            if (clientChunk.isEmpty()) return;
            Biome biome = (Biome)mc.level.getBiome(pos).value();
            ResourceLocation id = mc.level.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome);
            String translationKey = "biome." + id.toString().replace(":", ".");
            String biomeName = StringUtils.translate((String)translationKey, (Object[])new Object[0]);
            if (biomeName.equals(translationKey)) {
                biomeName = StringUtils.prettifyRawTranslationPath((String)id.getPath());
            }
            this.addLineI18n("minihud.info_line.biome", biomeName);
            return;
        } else if (type == InfoToggle.BIOME_REG_NAME) {
            LevelChunk clientChunk = InfoLineChunkCache.INSTANCE.getClientChunk(chunkPos);
            if (clientChunk.isEmpty()) return;
            Biome biome = (Biome)mc.level.getBiome(pos).value();
            ResourceLocation rl = mc.level.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome);
            String name = rl != null ? rl.toString() : "?";
            this.addLineI18n("minihud.info_line.biome_reg_name", name);
            return;
        } else if (type == InfoToggle.ENTITIES) {
            String ent = mc.levelRenderer.getEntityStatistics();
            int p = ent.indexOf(",");
            if (p != -1) {
                ent = ent.substring(0, p);
            }
            this.addLine(ent);
            return;
        } else if (type == InfoToggle.TILE_ENTITIES) {
            this.addLineI18n("minihud.info_line.tile_entities", new Object[0]);
            return;
        } else if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
            Level serverWorld;
            int countClient = mc.level.getEntityCount();
            if (mc.hasSingleplayerServer() && (serverWorld = WorldUtils.getBestWorld((Minecraft)mc)) instanceof ServerLevel) {
                IServerEntityManager manager = (IServerEntityManager)((IMixinServerWorld)serverWorld).minihud_getEntityManager();
                int indexSize = manager.minihud$getIndexSize();
                this.addLineI18n("minihud.info_line.entities_client_world.server", countClient, indexSize);
                return;
            }
            this.addLineI18n("minihud.info_line.entities_client_world", countClient);
            return;
        } else if (type == InfoToggle.SLIME_CHUNK) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, null, null, pos, null, null);
            this.processEntries(parser.parse(ctx));
            return;
        } else if (type == InfoToggle.LOOKING_AT_ENTITY) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_VARIANT) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_HOME_POS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_COPPER_AGING) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.LOOKING_AT_EFFECTS) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ZOMBIE_CONVERSION) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.DOLPHIN_TREASURE) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.ENTITY_REG_NAME) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.PLAYER_EXPERIENCE) {
            if (mc.player == null) return;
            this.addLineI18n("minihud.info_line.player_experience", mc.player.experienceLevel, Float.valueOf(100.0f * mc.player.experienceProgress), mc.player.totalExperience);
            return;
        } else if (type == InfoToggle.LOOKING_AT_PLAYER_EXP) {
            InfoLine parser = type.initParser();
            if (parser == null) return;
            Pair<Entity, CompoundTag> pair = this.getTargetEntity(world, mc);
            if (pair == null) return;
            InfoLine.Context ctx = new InfoLine.Context(world, (Entity)pair.getLeft(), null, null, null, (CompoundTag)pair.getRight());
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else if (type == InfoToggle.LOOKING_AT_BLOCK || type == InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            BlockState state = this.getTargetedBlock(mc);
            if (state == null) return;
            BlockPos lookPos = ((BlockHitResult)mc.hitResult).getBlockPos();
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, lookPos, state, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
            return;
        } else {
            if (type != InfoToggle.BLOCK_PROPS) return;
            if (this.addedTypes.contains((Object)type)) {
                return;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            InfoLine parser = type.initParser();
            if (parser == null) return;
            BlockState state = this.getTargetedBlock(mc);
            if (state == null) return;
            BlockPos lookPos = ((BlockHitResult)mc.hitResult).getBlockPos();
            InfoLine.Context ctx = new InfoLine.Context(bestWorld, null, null, lookPos, state, null);
            this.processEntries(parser.parse(ctx));
            if (!parser.succeededType()) return;
            this.addedTypes.add(type);
        }
    }

    private boolean isEntityDataValid(@Nonnull CompoundTag nbt) {
        if (InventoryUtils.hasNbtItems((CompoundTag)nbt)) {
            return true;
        }
        Iterator iterator = nbt.keySet().iterator();
        block28: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Fire": {
                    short fire = nbt.getShortOr("Fire", (short)-1);
                    if (fire >= 0 && fire <= 0) continue block28;
                    return true;
                }
                case "Age": {
                    int age = nbt.getIntOr("Age", -1);
                    if (age != 0 && age <= 1) continue block28;
                    return true;
                }
                case "Brain": {
                    CompoundTag tag = nbt.getCompoundOrEmpty("Brain");
                    if (tag.isEmpty() || tag.getCompound("memories").isEmpty()) continue block28;
                    return true;
                }
                case "Offers": {
                    return true;
                }
                case "Recipes": {
                    return true;
                }
                case "ConversionTime": {
                    if (nbt.getIntOr("ConversionTime", -1) <= 0) break;
                    return true;
                }
                case "DrownedConversionTime": {
                    if (nbt.getIntOr("DrownedConversionTime", -1) <= 0) break;
                    return true;
                }
                case "StrayConversionTime": {
                    if (nbt.getIntOr("StrayConversionTime", -1) <= 0) break;
                    return true;
                }
                case "ConversionPlayer": {
                    return true;
                }
                case "recipeBook": {
                    return true;
                }
                case "recipes": {
                    return true;
                }
                case "active_effects": {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public Pair<Entity, CompoundTag> getTargetEntity(Level world, Minecraft mc) {
        if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.ENTITY) {
            Entity lookedEntity = ((EntityHitResult)mc.hitResult).getEntity();
            if (lookedEntity == null || lookedEntity.getId() == mc.player.getId()) {
                return null;
            }
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            Pair<Entity, CompoundTag> pair = null;
            if (bestWorld instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)bestWorld;
                Entity serverEntity = serverWorld.getEntity(lookedEntity.getId());
                CompoundTag nbt = NbtEntityUtils.invokeEntityNbtDataNoPassengers((Entity)serverEntity, (int)lookedEntity.getId());
                if (!nbt.isEmpty()) {
                    pair = Pair.of((Object)serverEntity, (Object)nbt);
                }
            } else {
                pair = EntitiesDataManager.getInstance().requestEntity(world, lookedEntity.getId());
            }
            if (pair == null && this.lastEntity != null && ((Entity)this.lastEntity.getLeft()).getId() == lookedEntity.getId()) {
                pair = this.lastEntity;
            } else if (pair != null && pair.getRight() != null && !((CompoundTag)pair.getRight()).isEmpty() && this.isEntityDataValid((CompoundTag)pair.getRight())) {
                this.lastEntity = pair;
            } else if (this.lastEntity != null && ((Entity)this.lastEntity.getLeft()).getId() == lookedEntity.getId()) {
                pair = this.lastEntity;
            }
            return pair;
        }
        return null;
    }

    @Nullable
    public Pair<BlockEntity, CompoundTag> getTargetedBlockEntity(Level world, Minecraft mc) {
        if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos posLooking = ((BlockHitResult)mc.hitResult).getBlockPos();
            Level bestWorld = WorldUtils.getBestWorld((Minecraft)mc);
            BlockState state = bestWorld.getBlockState(posLooking);
            Pair<BlockEntity, CompoundTag> pair = null;
            if (state.getBlock() instanceof EntityBlock) {
                if (bestWorld instanceof ServerLevel) {
                    BlockEntity be;
                    CompoundTag nbt = new CompoundTag();
                    pair = Pair.of((Object)be, (Object)((be = bestWorld.getChunkAt(posLooking).getBlockEntity(posLooking)) != null ? be.saveWithFullMetadata((HolderLookup.Provider)bestWorld.registryAccess()) : nbt));
                } else {
                    pair = EntitiesDataManager.getInstance().requestBlockEntity(world, posLooking);
                }
                if (pair == null && this.lastBlockEntity != null && ((BlockEntity)this.lastBlockEntity.getLeft()).getBlockPos().equals((Object)posLooking)) {
                    pair = this.lastBlockEntity;
                } else if (pair != null) {
                    this.lastBlockEntity = pair;
                }
                return pair;
            }
        }
        return null;
    }

    @Nullable
    public Pair<BlockEntity, CompoundTag> requestBlockEntityAt(Level world, BlockPos pos) {
        if (!(world instanceof ServerLevel)) {
            ChestType type;
            Pair<BlockEntity, CompoundTag> pair = EntitiesDataManager.getInstance().requestBlockEntity(world, pos);
            BlockState state = world.getBlockState(pos);
            if (state.getBlock() instanceof ChestBlock && (type = (ChestType)state.getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE) {
                return EntitiesDataManager.getInstance().requestBlockEntity(world, pos.relative(ChestBlock.getConnectedDirection((BlockState)state)));
            }
            return pair;
        }
        return null;
    }

    @Nullable
    private BlockState getTargetedBlock(Minecraft mc) {
        if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos posLooking = ((BlockHitResult)mc.hitResult).getBlockPos();
            return mc.level.getBlockState(posLooking);
        }
        return null;
    }

    private <T extends Comparable<T>> void getBlockProperties(Minecraft mc) {
        if (mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK) {
            BlockPos posLooking = ((BlockHitResult)mc.hitResult).getBlockPos();
            BlockState state = mc.level.getBlockState(posLooking);
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            this.addLine(rl != null ? rl.toString() : "<null>");
            for (String line : BlockUtils.getFormattedBlockStateProperties((BlockState)state)) {
                this.addLine(line);
            }
        }
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(@Nonnull LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(RenderHandler renderHandler, String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

