/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiRenderLayerEditBase;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.GuiTextFieldInteger;
import fi.dy.masa.malilib.gui.MaLiLibIcons;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ButtonOnOff;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetCheckBox;
import fi.dy.masa.malilib.gui.widgets.WidgetColorIndicator;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.gui.GuiConfigs;
import fi.dy.masa.minihud.gui.GuiShapeManager;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeCenteredBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircle;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeLineBlock;
import fi.dy.masa.minihud.renderer.shapes.ShapeSpawnSphere;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.ShapeRenderType;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GuiShapeEditor
extends GuiRenderLayerEditBase {
    private final ShapeBase shape;
    private final ConfigOptionList configBlockSnap;
    private int colorY;

    public GuiShapeEditor(ShapeBase shape) {
        this.shape = shape;
        this.title = StringUtils.translate((String)"minihud.gui.title.shape_editor", (Object[])new Object[]{shape.getDisplayName()});
        this.configBlockSnap = new ConfigOptionList("blockSnap", (IConfigOptionListEntry)BlockSnap.NONE, "");
    }

    public void initGui() {
        super.initGui();
        int x = 10;
        int y = 20;
        this.createShapeEditorElements(x, y);
        ButtonGeneric button = new ButtonGeneric(x, this.getScreenHeight() - 24, -1, 20, GuiConfigs.ConfigGuiTab.SHAPES.getDisplayName(), new String[0]);
        this.addButton((ButtonBase)button, new GuiShapeManager.ButtonListenerTab(GuiConfigs.ConfigGuiTab.SHAPES));
        ButtonOnOff renderThroughButton = new ButtonOnOff(this.getScreenWidth() - 224, this.getScreenHeight() - 24, -1, false, "minihud.gui.button.shape_renderer.toggle_render_through", this.shape.shouldRenderThrough(), new String[0]);
        this.addButton((ButtonBase)renderThroughButton, (b, mb) -> this.toggleRenderThrough(this.shape, renderThroughButton));
        this.createColorOutlinesInput(this.getScreenWidth() - 98, this.getScreenHeight() - 60);
        ButtonOnOff renderLinesButton = new ButtonOnOff(this.getScreenWidth() - 104, this.getScreenHeight() - 24, -1, false, "minihud.gui.button.shape_renderer.toggle_render_lines", this.shape.shouldRenderLines(), new String[0]);
        this.addButton((ButtonBase)renderLinesButton, (b, mb) -> this.toggleRenderLines(this.shape, renderLinesButton));
    }

    protected LayerRange getLayerRange() {
        return this.shape.getLayerRange();
    }

    private void createColorInput(int x, int y) {
        this.addLabel(x, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.color", (Object[])new Object[0])});
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y += 12, 70, 17, this.textRenderer);
        textField.setMaxLengthWrapper(12);
        textField.setTextWrapper(String.format("#%08X", this.shape.getColor().intValue));
        this.addTextField(textField, new TextFieldListenerColor(this.shape));
        this.nextY = y + 20;
        this.colorY = y - 1;
        this.addWidget((WidgetBase)new WidgetColorIndicator(x + 74, this.colorY, 19, 19, this.shape.getColor(), this.shape::setColor));
    }

    private void createColorOutlinesInput(int x, int y) {
        this.addLabel(x, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.outlines_color", (Object[])new Object[0])});
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y += 12, 70, 17, this.textRenderer);
        textField.setMaxLengthWrapper(12);
        textField.setTextWrapper(String.format("#%08X", this.shape.getColorLines().intValue));
        this.addTextField(textField, new TextFieldListenerColorLines(this.shape));
        this.nextY = y + 20;
        this.colorY = y - 1;
        this.addWidget((WidgetBase)new WidgetColorIndicator(x + 74, this.colorY, 19, 19, this.shape.getColorLines(), this.shape::setColorLines));
    }

    private void createShapeEditorElements(int x, int y) {
        this.addLabel(x, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.display_name_colon", (Object[])new Object[0])});
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y += 12, 240, 17, this.textRenderer);
        textField.setTextWrapper(this.shape.getDisplayName());
        this.addTextField(textField, txtFld -> {
            this.shape.setDisplayName(txtFld.getTextWrapper());
            return true;
        });
        int renderTypeX = x + 230;
        int renderTypeY = (y += 20) + 2;
        ShapeType type = this.shape.getType();
        switch (type) {
            case BOX: {
                this.createShapeEditorElementsBox(x, y);
                break;
            }
            case CENTERED_BOX: {
                this.createShapeEditorElementsBoxWithDimension(x, y);
                break;
            }
            case BLOCK_LINE: {
                this.createShapeEditorElementsBlockLine(x, y);
                break;
            }
            case ADJUSTABLE_SPAWN_SPHERE: 
            case CAN_DESPAWN_SPHERE: 
            case CAN_SPAWN_SPHERE: 
            case DESPAWN_SPHERE: {
                ShapeSpawnSphere shape = (ShapeSpawnSphere)this.shape;
                boolean isAdjustable = type == ShapeType.ADJUSTABLE_SPAWN_SPHERE;
                this.createShapeEditorElementsSphereBase(x, y, isAdjustable);
                if (!isAdjustable) {
                    this.createShapeEditorElementDoubleField(x + 150, y + 2, shape::getMargin, shape::setMargin, "minihud.gui.label.margin_colon", false);
                }
                if (!(shape instanceof ShapeSpawnSphere)) break;
                String key = "minihud.gui.button.shape_renderer.spawn_sphere.toggle_use_quadrants";
                String hover = StringUtils.translate((String)"minihud.gui.button.hover.shape_renderer.spawn_sphere.toggle_use_quadrants", (Object[])new Object[0]);
                ButtonOnOff button = new ButtonOnOff(x + 160, y + 30, -1, false, key, shape.getUseCornerQuadrants(), new String[]{hover});
                this.addButton((ButtonBase)button, (btn, mbtn) -> this.toggleUseQuadrants(shape, button));
                break;
            }
            case CIRCLE: {
                ShapeCircle shape = (ShapeCircle)this.shape;
                this.createShapeEditorElementsSphereBase(x, y, true);
                this.createShapeEditorElementIntField(x + 150, y + 36, shape::getHeight, shape::setHeight, "minihud.gui.label.height_colon", true);
                this.createDirectionButton(x + 230, y + 36, shape::getMainAxis, shape::setMainAxis, "minihud.gui.label.shape.circle.main_axis_colon");
                this.createRenderTypeButton(renderTypeX, renderTypeY, this.shape::getRenderType, this.shape::setRenderType, "minihud.gui.label.shape.render_type_colon");
                break;
            }
            case SPHERE_BLOCKY: {
                this.createShapeEditorElementsSphereBase(x, y, true);
                this.createRenderTypeButton(renderTypeX, renderTypeY, this.shape::getRenderType, this.shape::setRenderType, "minihud.gui.label.shape.render_type_colon");
            }
        }
    }

    private void createShapeEditorElementsSphereBase(int x, int y, boolean addRadiusInput) {
        ShapeCircleBase shape = (ShapeCircleBase)this.shape;
        this.addLabel(x, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.center_colon", (Object[])new Object[0])});
        if (addRadiusInput) {
            this.createShapeEditorElementDoubleField(x + 150, y + 2, shape::getRadius, shape::setRadius, "minihud.gui.label.radius_colon", true);
        }
        y += 12;
        GuiUtils.createVec3dInputsVertical((int)x, (int)y, (int)120, (Vec3)shape.getEffectiveCenter(), (ICoordinateValueModifier)new Vec3dEditor(shape::getEffectiveCenter, shape::setCenter, this), (boolean)true, (GuiBase)this);
        int btnX = x += 11;
        ButtonGeneric button = new ButtonGeneric(btnX, y += 54, -1, false, "malilib.gui.button.render_layers_gui.set_to_player", new Object[0]);
        this.addButton((ButtonBase)button, (btn, mbtn) -> this.setPositionFromCamera(shape::setCenter));
        btnX = button.getX() + button.getWidth() + 4;
        this.configBlockSnap.setOptionListValue((IConfigOptionListEntry)shape.getBlockSnap());
        String label = StringUtils.translate((String)"minihud.gui.label.shape.block_snap", (Object[])new Object[]{shape.getBlockSnap().getDisplayName()});
        int width = this.getStringWidth(label) + 10;
        ConfigButtonOptionList buttonSnap = new ConfigButtonOptionList(btnX, y, width, 20, (IConfigOptionList)this.configBlockSnap, label);
        this.addButton((ButtonBase)buttonSnap, new ButtonListenerSphereBlockSnap(shape, this));
        btnX = buttonSnap.getX() + buttonSnap.getWidth() + 4;
        ButtonOnOff combineQuadsButton = new ButtonOnOff(btnX, y, -1, false, "minihud.gui.button.shape_renderer.toggle_combine_quads", ((ShapeBlocky)this.shape).getCombineQuads(), new String[0]);
        this.addButton((ButtonBase)combineQuadsButton, (b, mb) -> this.toggleCombineQuads(shape, combineQuadsButton));
        this.createColorInput(x, y += 24);
        this.createLayerEditControls(146, y += 11, this.getLayerRange());
    }

    public void createCenteredBoxInputs(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int textFieldWidth, ShapeCenteredBox shape) {
        this.createShapeEditorElementIntField(x1, y1, shape::getHeight, shape::setHeight, "minihud.gui.label.height_colon", true);
        this.createShapeEditorElementIntField(x2, y2, shape::getWidth, shape::setWidth, "minihud.gui.label.width_colon", true);
        this.createShapeEditorElementIntField(x3, y3, shape::getDepth, shape::setDepth, "minihud.gui.label.depth_colon", true);
        this.addLabel(x4 + 12, y4, -1, 12, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.center_colon", (Object[])new Object[0])});
        y4 += 12;
        GuiUtils.createVec3dInputsVertical((int)x4, (int)y4, (int)textFieldWidth, (Vec3)shape.getCorner2(), (ICoordinateValueModifier)new Vec3dEditor(shape::getCenter, shape::setCenter, this), (boolean)true, (GuiBase)this);
        int x = x1 + 12;
        ButtonGeneric btn = new ButtonGeneric(x, y4 + 50, -1, 14, StringUtils.translate((String)"malilib.gui.button.render_layers_gui.set_to_player", (Object[])new Object[0]), new String[0]);
        btn.setRenderDefaultBackground(false);
        this.addButton((ButtonBase)btn, (b, mb) -> this.setPositionFromCamera(shape::setCenter));
    }

    private void createShapeEditorElementsBoxWithDimension(int xIn, int yIn) {
        ShapeCenteredBox shape = (ShapeCenteredBox)this.shape;
        int x = xIn;
        int y = yIn + 4;
        this.createCenteredBoxInputs(x, y, x, y + 28, x, y + 56, x, y + 84, 120, shape);
        this.createColorInput(x + 12, y += 160);
        x = xIn + 250;
        y = yIn + 4;
        this.addBoxSideToggleCheckbox(x, y, Direction.DOWN, shape);
        this.addBoxSideToggleCheckbox(x, y + 11, Direction.UP, shape);
        this.addBoxSideToggleCheckbox(x, y + 22, Direction.NORTH, shape);
        this.addBoxSideToggleCheckbox(x, y + 33, Direction.SOUTH, shape);
        this.addBoxSideToggleCheckbox(x, y + 44, Direction.WEST, shape);
        this.addBoxSideToggleCheckbox(x, y + 55, Direction.EAST, shape);
        x = xIn + 160;
        y = yIn + 4;
        if (shape.isGridEnabled()) {
            this.addLabel(x, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.grid_size", (Object[])new Object[0])});
            GuiUtils.createVec3dInputsVertical((int)x, (int)(y + 12), (int)50, (Vec3)shape.getGridSize(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridSize, shape::setGridSize, this), (boolean)true, (GuiBase)this);
            this.addLabel(x, y += 70, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.grid_start_offset", (Object[])new Object[0])});
            GuiUtils.createVec3dInputsVertical((int)x, (int)(y + 12), (int)50, (Vec3)shape.getGridStartOffset(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridStartOffset, shape::setGridStartOffset, this), (boolean)true, (GuiBase)this);
            this.addLabel(x + 100, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.grid_end_offset", (Object[])new Object[0])});
            GuiUtils.createVec3dInputsVertical((int)(x + 100), (int)(y + 12), (int)50, (Vec3)shape.getGridEndOffset(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridEndOffset, shape::setGridEndOffset, this), (boolean)true, (GuiBase)this);
        }
        y = yIn + 148;
        ButtonOnOff button = new ButtonOnOff(x, y, -1, false, "minihud.gui.label.shape.box.grid_enabled", shape.isGridEnabled(), new String[0]);
        this.addButton((ButtonBase)button, (btn, mbtn) -> this.toggleGridEnabled(shape));
    }

    private void createShapeEditorElementsBox(int xIn, int yIn) {
        ShapeBox shape = (ShapeBox)this.shape;
        int x = xIn;
        int y = yIn + 4;
        this.createBoxInputs(x, y, x, y + 82, 120, shape);
        this.createColorInput(x + 12, y += 160);
        x = xIn + 250;
        y = yIn + 4;
        this.addBoxSideToggleCheckbox(x, y, Direction.DOWN, shape);
        this.addBoxSideToggleCheckbox(x, y + 11, Direction.UP, shape);
        this.addBoxSideToggleCheckbox(x, y + 22, Direction.NORTH, shape);
        this.addBoxSideToggleCheckbox(x, y + 33, Direction.SOUTH, shape);
        this.addBoxSideToggleCheckbox(x, y + 44, Direction.WEST, shape);
        this.addBoxSideToggleCheckbox(x, y + 55, Direction.EAST, shape);
        x = xIn + 160;
        y = yIn + 4;
        if (shape.isGridEnabled()) {
            this.addLabel(x, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.grid_size", (Object[])new Object[0])});
            GuiUtils.createVec3dInputsVertical((int)x, (int)(y + 12), (int)50, (Vec3)shape.getGridSize(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridSize, shape::setGridSize, this), (boolean)true, (GuiBase)this);
            this.addLabel(x, y += 70, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.grid_start_offset", (Object[])new Object[0])});
            GuiUtils.createVec3dInputsVertical((int)x, (int)(y + 12), (int)50, (Vec3)shape.getGridStartOffset(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridStartOffset, shape::setGridStartOffset, this), (boolean)true, (GuiBase)this);
            this.addLabel(x + 100, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.grid_end_offset", (Object[])new Object[0])});
            GuiUtils.createVec3dInputsVertical((int)(x + 100), (int)(y + 12), (int)50, (Vec3)shape.getGridEndOffset(), (ICoordinateValueModifier)new Vec3dEditor(shape::getGridEndOffset, shape::setGridEndOffset, this), (boolean)true, (GuiBase)this);
        }
        y = yIn + 148;
        ButtonOnOff button = new ButtonOnOff(x, y, -1, false, "minihud.gui.label.shape.box.grid_enabled", shape.isGridEnabled(), new String[0]);
        this.addButton((ButtonBase)button, (btn, mbtn) -> this.toggleGridEnabled(shape));
    }

    private void createShapeEditorElementsBlockLine(int xIn, int yIn) {
        ShapeLineBlock shape = (ShapeLineBlock)this.shape;
        int x = xIn;
        int x2 = x + 160;
        int y = yIn + 4;
        this.addLabel(x, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.minimum_coord", (Object[])new Object[0])});
        this.addLabel(x2, y, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.maximum_coord", (Object[])new Object[0])});
        y += 14;
        GuiUtils.createVec3dInputsVertical((int)x, (int)y, (int)120, (Vec3)shape.getStartPos(), (ICoordinateValueModifier)new Vec3dEditor(shape::getStartPos, shape::setStartPos, this), (boolean)true, (GuiBase)this);
        GuiUtils.createVec3dInputsVertical((int)x2, (int)y, (int)120, (Vec3)shape.getEndPos(), (ICoordinateValueModifier)new Vec3dEditor(shape::getEndPos, shape::setEndPos, this), (boolean)true, (GuiBase)this);
        ButtonGeneric btn = new ButtonGeneric(x + 11, y += 54, -1, 20, StringUtils.translate((String)"malilib.gui.button.render_layers_gui.set_to_player", (Object[])new Object[0]), new String[0]);
        this.addButton((ButtonBase)btn, (b, mb) -> this.setPositionFromCamera(shape::setStartPos));
        btn = new ButtonGeneric(x2 + 11, y, -1, 20, StringUtils.translate((String)"malilib.gui.button.render_layers_gui.set_to_player", (Object[])new Object[0]), new String[0]);
        this.addButton((ButtonBase)btn, (b, mb) -> this.setPositionFromCamera(shape::setEndPos));
        int btnX = xIn + 11;
        this.configBlockSnap.setOptionListValue((IConfigOptionListEntry)shape.getBlockSnap());
        String label = StringUtils.translate((String)"minihud.gui.label.shape.block_snap", (Object[])new Object[]{shape.getBlockSnap().getDisplayName()});
        int width = this.getStringWidth(label) + 10;
        ConfigButtonOptionList buttonSnap = new ConfigButtonOptionList(btnX, y += 24, width, 20, (IConfigOptionList)this.configBlockSnap, label);
        this.addButton((ButtonBase)buttonSnap, new ButtonListenerSphereBlockSnap(shape, this));
        ButtonOnOff combineQuadsButton = new ButtonOnOff(btnX += buttonSnap.getWidth() + 4, y, -1, false, "minihud.gui.button.shape_renderer.toggle_combine_quads", ((ShapeBlocky)this.shape).getCombineQuads(), new String[0]);
        this.addButton((ButtonBase)combineQuadsButton, (b, mb) -> this.toggleCombineQuads(shape, combineQuadsButton));
        this.createColorInput(xIn + 12, y += 24);
        this.createLayerEditControls(xIn + 115, y += 11, this.getLayerRange());
    }

    private void toggleGridEnabled(ShapeBox shape) {
        shape.toggleGridEnabled();
        this.initGui();
    }

    private void toggleCombineQuads(ShapeBlocky shape, ButtonOnOff button) {
        shape.toggleCombineQuads();
        button.updateDisplayString(shape.getCombineQuads());
    }

    private void toggleUseQuadrants(ShapeSpawnSphere shape, ButtonOnOff button) {
        shape.toggleUseCornerQuadrants();
        button.updateDisplayString(shape.getUseCornerQuadrants());
    }

    private void addBoxSideToggleCheckbox(int x, int y, Direction side, ShapeBox shape) {
        String sideName = StringUtils.translate((String)("minihud.gui.name.box.box_side." + side.name().toLowerCase()), (Object[])new Object[0]);
        WidgetCheckBox cb = new WidgetCheckBox(x, y, (IGuiIcon)MaLiLibIcons.MINUS, (IGuiIcon)MaLiLibIcons.PLUS, this.capitalize(sideName), StringUtils.translate((String)"minihud.gui.hover.shape.box.box_side", (Object[])new Object[]{sideName}));
        cb.setChecked(shape.isSideEnabled(side));
        cb.setListener(w -> this.toggleSideEnabled(side, shape));
        this.addWidget((WidgetBase)cb);
    }

    private void toggleSideEnabled(Direction side, ShapeBox shape) {
        int mask = shape.getEnabledSidesMask();
        shape.setEnabledSidesMask(mask ^ 1 << side.get3DDataValue());
    }

    private void toggleRenderLines(ShapeBase shape, ButtonOnOff button) {
        shape.toggleRenderLines();
        button.updateDisplayString(shape.shouldRenderLines());
    }

    private void toggleRenderThrough(ShapeBase shape, ButtonOnOff button) {
        shape.toggleRenderThrough();
        button.updateDisplayString(shape.shouldRenderThrough());
    }

    public void createBoxInputs(int x1, int y1, int x2, int y2, int textFieldWidth, ShapeBox shape) {
        this.addLabel(x1, y1, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.corner_1", (Object[])new Object[0])});
        y1 += 12;
        this.addLabel(x2, y2, -1, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.shape.box.corner_2", (Object[])new Object[0])});
        y2 += 12;
        GuiUtils.createVec3dInputsVertical((int)x1, (int)y1, (int)textFieldWidth, (Vec3)shape.getCorner1(), (ICoordinateValueModifier)new Vec3dEditor(shape::getCorner1, shape::setCorner1, this), (boolean)true, (GuiBase)this);
        GuiUtils.createVec3dInputsVertical((int)x2, (int)y2, (int)textFieldWidth, (Vec3)shape.getCorner2(), (ICoordinateValueModifier)new Vec3dEditor(shape::getCorner2, shape::setCorner2, this), (boolean)true, (GuiBase)this);
        int x = x1 + 12;
        ButtonGeneric btn = new ButtonGeneric(x, y1 + 50, -1, 14, StringUtils.translate((String)"malilib.gui.button.render_layers_gui.set_to_player", (Object[])new Object[0]), new String[0]);
        btn.setRenderDefaultBackground(false);
        this.addButton((ButtonBase)btn, (b, mb) -> this.setPositionFromCamera(shape::setCorner1));
        btn = new ButtonGeneric(x, y2 + 50, -1, 14, StringUtils.translate((String)"malilib.gui.button.render_layers_gui.set_to_player", (Object[])new Object[0]), new String[0]);
        btn.setRenderDefaultBackground(false);
        this.addButton((ButtonBase)btn, (b, mb) -> this.setPositionFromCamera(shape::setCorner2));
    }

    protected void addBoxInput(int x, int y, int textFieldWidth, DoubleSupplier coordinateSource, DoubleConsumer coordinateConsumer) {
        Font textRenderer = Minecraft.getInstance().font;
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y + 1, textFieldWidth, 14, textRenderer);
        textField.setTextWrapper("" + coordinateSource.getAsDouble());
        this.addTextFieldAndButtonForBoxCoordinate(x + textFieldWidth + 4, y, textField, coordinateSource, coordinateConsumer);
    }

    protected int addLabel(int x, int y, PositionUtils.CoordinateType type) {
        String label = type.name() + ":";
        int labelWidth = 12;
        this.addLabel(x, y, labelWidth, 20, -1, new String[]{label});
        return labelWidth;
    }

    protected void addTextFieldAndButtonForBoxCoordinate(int x, int y, GuiTextFieldGeneric textField, DoubleSupplier coordinateSource, DoubleConsumer coordinateConsumer) {
        this.addTextField(textField, new TextFieldListenerDouble(coordinateConsumer));
        String hover = StringUtils.translate((String)"malilib.gui.button.hover.plus_minus_tip", (Object[])new Object[0]);
        ButtonGeneric button = new ButtonGeneric(x, y, (IGuiIcon)MaLiLibIcons.BTN_PLUSMINUS_16, new String[]{hover});
        this.addButton((ButtonBase)button, new ButtonListenerDoubleModifier(coordinateSource, v -> {
            coordinateConsumer.accept(v);
            textField.setTextWrapper("" + coordinateSource.getAsDouble());
        }));
    }

    private String capitalize(String str) {
        if (str.length() > 1) {
            return str.substring(0, 1).toUpperCase(Locale.ROOT) + str.substring(1);
        }
        return str.length() > 0 ? str.toUpperCase(Locale.ROOT) : str;
    }

    private void createShapeEditorElementDoubleField(int x, int y, DoubleSupplier supplier, DoubleConsumer consumer, String translationKey, boolean addButton) {
        this.addLabel(x + 12, y, -1, 12, -1, new String[]{translationKey});
        GuiTextFieldDouble txtField = new GuiTextFieldDouble(x + 12, y += 11, 40, 14, this.textRenderer);
        txtField.setTextWrapper(String.valueOf(supplier.getAsDouble()));
        this.addTextField((GuiTextFieldGeneric)txtField, new TextFieldListenerDouble(consumer));
        if (addButton) {
            String hover = StringUtils.translate((String)"malilib.gui.button.hover.plus_minus_tip", (Object[])new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x + 54, y - 1, (IGuiIcon)MaLiLibIcons.BTN_PLUSMINUS_16, new String[]{hover});
            this.addButton((ButtonBase)button, new ButtonListenerDoubleModifier(supplier, new ChainedDoubleConsumer(consumer, val -> txtField.setTextWrapper(String.valueOf(supplier.getAsDouble())))));
        }
    }

    private void createShapeEditorElementIntField(int x, int y, IntSupplier supplier, IntConsumer consumer, String translationKey, boolean addButton) {
        this.addLabel(x + 12, y, -1, 12, -1, new String[]{translationKey});
        GuiTextFieldInteger txtField = new GuiTextFieldInteger(x + 12, y += 11, 40, 14, this.textRenderer);
        txtField.setTextWrapper(String.valueOf(supplier.getAsInt()));
        this.addTextField((GuiTextFieldGeneric)txtField, new TextFieldListenerInteger(consumer));
        if (addButton) {
            String hover = StringUtils.translate((String)"malilib.gui.button.hover.plus_minus_tip", (Object[])new Object[0]);
            ButtonGeneric button = new ButtonGeneric(x + 54, y - 1, (IGuiIcon)MaLiLibIcons.BTN_PLUSMINUS_16, new String[]{hover});
            this.addButton((ButtonBase)button, new ButtonListenerIntModifier(supplier, new ChainedIntConsumer(consumer, val -> txtField.setTextWrapper(String.valueOf(supplier.getAsInt())))));
        }
    }

    private void createDirectionButton(int x, int y, Supplier<Direction> supplier, Consumer<Direction> consumer, String translationKey) {
        this.addLabel(x, y, -1, 12, -1, new String[]{translationKey});
        ButtonGeneric button = new ButtonGeneric(x, y += 10, 50, 20, org.apache.commons.lang3.StringUtils.capitalize((String)supplier.get().toString().toLowerCase()), new String[0]);
        this.addButton((ButtonBase)button, (btn, mouseBtn) -> {
            consumer.accept(GuiShapeEditor.cycleDirection((Direction)supplier.get(), mouseBtn == 1));
            this.initGui();
        });
    }

    private void createRenderTypeButton(int x, int y, Supplier<ShapeRenderType> supplier, Consumer<ShapeRenderType> consumer, String translationKey) {
        this.addLabel(x, y, -1, 12, -1, new String[]{translationKey});
        ButtonGeneric button = new ButtonGeneric(x, y += 10, -1, 20, supplier.get().getDisplayName(), new String[0]);
        this.addButton((ButtonBase)button, (btn, mouseBtn) -> {
            consumer.accept((ShapeRenderType)((ShapeRenderType)((Object)((Object)supplier.get()))).cycle(mouseBtn == 0));
            this.initGui();
        });
    }

    public static Direction cycleDirection(Direction direction, boolean reverse) {
        int index = direction.get3DDataValue();
        index = reverse ? (index == 0 ? 5 : index - 1) : (index >= 5 ? 0 : index + 1);
        return Direction.from3DDataValue((int)index);
    }

    protected void setPositionFromCamera(Consumer<Vec3> consumer) {
        Entity entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            consumer.accept(entity.position());
            this.initGui();
        }
    }

    protected void setBlockPosFromCamera(Consumer<BlockPos> consumer) {
        Entity entity = EntityUtils.getCameraEntity();
        if (entity != null) {
            consumer.accept(entity.blockPosition());
            this.initGui();
        }
    }

    private record TextFieldListenerColor(ShapeBase shape) implements ITextFieldListener<GuiTextFieldGeneric>
    {
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.shape.setColorFromString(textField.getTextWrapper());
            return false;
        }
    }

    private record TextFieldListenerColorLines(ShapeBase shape) implements ITextFieldListener<GuiTextFieldGeneric>
    {
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.shape.setColorLinesFromString(textField.getTextWrapper());
            return false;
        }
    }

    public record Vec3dEditor(Supplier<Vec3> supplier, Consumer<Vec3> consumer, GuiShapeEditor gui) implements ICoordinateValueModifier
    {
        public boolean modifyValue(PositionUtils.CoordinateType type, int amount) {
            this.consumer.accept(PositionUtils.modifyValue((PositionUtils.CoordinateType)type, (Vec3)this.supplier.get(), (double)amount));
            this.gui.initGui();
            return true;
        }

        public boolean setValueFromString(PositionUtils.CoordinateType type, String newValue) {
            try {
                this.consumer.accept(PositionUtils.setValue((PositionUtils.CoordinateType)type, (Vec3)this.supplier.get(), (double)Double.parseDouble(newValue)));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private record ButtonListenerSphereBlockSnap(ShapeBlocky shape, GuiShapeEditor gui) implements IButtonActionListener
    {
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            this.shape.setBlockSnap((BlockSnap)this.gui.configBlockSnap.getOptionListValue());
            this.gui.initGui();
        }
    }

    private record TextFieldListenerDouble(DoubleConsumer consumer) implements ITextFieldListener<GuiTextFieldGeneric>
    {
        public boolean onTextChange(GuiTextFieldGeneric textField) {
            try {
                this.consumer.accept(Double.parseDouble(textField.getTextWrapper()));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class ButtonListenerDoubleModifier
    implements IButtonActionListener {
        protected final DoubleSupplier supplier;
        protected final DoubleConsumer consumer;
        protected final int modifierShift;
        protected final int modifierControl;
        protected final int modifierAlt;

        public ButtonListenerDoubleModifier(DoubleSupplier supplier, DoubleConsumer consumer) {
            this(supplier, consumer, 8, 1, 4);
        }

        public ButtonListenerDoubleModifier(DoubleSupplier supplier, DoubleConsumer consumer, int modifierShift, int modifierControl, int modifierAlt) {
            this.supplier = supplier;
            this.consumer = consumer;
            this.modifierShift = modifierShift;
            this.modifierControl = modifierControl;
            this.modifierAlt = modifierAlt;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= this.modifierShift;
            }
            if (GuiBase.isCtrlDown()) {
                amount *= this.modifierControl;
            }
            if (GuiBase.isAltDown()) {
                amount *= this.modifierAlt;
            }
            this.consumer.accept(this.supplier.getAsDouble() + (double)amount);
        }
    }

    private record ChainedDoubleConsumer(DoubleConsumer consumerOne, DoubleConsumer consumerTwo) implements DoubleConsumer
    {
        @Override
        public void accept(double value) {
            this.consumerOne.accept(value);
            this.consumerTwo.accept(value);
        }
    }

    private record TextFieldListenerInteger(IntConsumer consumer) implements ITextFieldListener<GuiTextFieldInteger>
    {
        public boolean onTextChange(GuiTextFieldInteger textField) {
            try {
                this.consumer.accept(Integer.parseInt(textField.getTextWrapper()));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class ButtonListenerIntModifier
    implements IButtonActionListener {
        protected final IntSupplier supplier;
        protected final IntConsumer consumer;
        protected final int modifierShift;
        protected final int modifierControl;
        protected final int modifierAlt;

        public ButtonListenerIntModifier(IntSupplier supplier, IntConsumer consumer) {
            this(supplier, consumer, 8, 1, 4);
        }

        public ButtonListenerIntModifier(IntSupplier supplier, IntConsumer consumer, int modifierShift, int modifierControl, int modifierAlt) {
            this.supplier = supplier;
            this.consumer = consumer;
            this.modifierShift = modifierShift;
            this.modifierControl = modifierControl;
            this.modifierAlt = modifierAlt;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            int amount;
            int n = amount = mouseButton == 1 ? -1 : 1;
            if (GuiBase.isShiftDown()) {
                amount *= this.modifierShift;
            }
            if (GuiBase.isCtrlDown()) {
                amount *= this.modifierControl;
            }
            if (GuiBase.isAltDown()) {
                amount *= this.modifierAlt;
            }
            this.consumer.accept(this.supplier.getAsInt() + amount);
        }
    }

    private record ChainedIntConsumer(IntConsumer consumerOne, IntConsumer consumerTwo) implements IntConsumer
    {
        @Override
        public void accept(int value) {
            this.consumerOne.accept(value);
            this.consumerTwo.accept(value);
        }
    }

    public record BlockPosEditor(Supplier<BlockPos> supplier, Consumer<BlockPos> consumer, GuiShapeEditor gui) implements ICoordinateValueModifier
    {
        public boolean modifyValue(PositionUtils.CoordinateType type, int amount) {
            this.consumer.accept(PositionUtils.modifyValue((PositionUtils.CoordinateType)type, (BlockPos)this.supplier.get(), (int)amount));
            this.gui.initGui();
            return true;
        }

        public boolean setValueFromString(PositionUtils.CoordinateType type, String newValue) {
            try {
                this.consumer.accept(PositionUtils.setValue((PositionUtils.CoordinateType)type, (BlockPos)this.supplier.get(), (int)Integer.parseInt(newValue)));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static class MutableWrapperBox {
        protected final Consumer<AABB> boxConsumer;
        protected double minX;
        protected double minY;
        protected double minZ;
        protected double maxX;
        protected double maxY;
        protected double maxZ;

        public MutableWrapperBox(AABB box, Consumer<AABB> boxConsumer) {
            this.minX = box.minX;
            this.minY = box.minY;
            this.minZ = box.minZ;
            this.maxX = box.maxX;
            this.maxY = box.maxY;
            this.maxZ = box.maxZ;
            this.boxConsumer = boxConsumer;
        }

        public double getMinX() {
            return this.minX;
        }

        public double getMinY() {
            return this.minY;
        }

        public double getMinZ() {
            return this.minZ;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getMaxZ() {
            return this.maxZ;
        }

        public void setMinX(double minX) {
            this.minX = minX;
            this.updateBox();
        }

        public void setMinY(double minY) {
            this.minY = minY;
            this.updateBox();
        }

        public void setMinZ(double minZ) {
            this.minZ = minZ;
            this.updateBox();
        }

        public void setMaxX(double maxX) {
            this.maxX = maxX;
            this.updateBox();
        }

        public void setMaxY(double maxY) {
            this.maxY = maxY;
            this.updateBox();
        }

        public void setMaxZ(double maxZ) {
            this.maxZ = maxZ;
            this.updateBox();
        }

        public void setMinCorner(Vec3 pos) {
            this.minX = pos.x;
            this.minY = pos.y;
            this.minZ = pos.z;
            this.updateBox();
        }

        public void setMaxCorner(Vec3 pos) {
            this.maxX = pos.x;
            this.maxY = pos.y;
            this.maxZ = pos.z;
            this.updateBox();
        }

        protected void updateBox() {
            AABB box = new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            this.boxConsumer.accept(box);
        }
    }
}

