/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.hotkeys;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeyCallbackAdjustable;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.interfaces.IValueChangeCallback;
import fi.dy.masa.malilib.render.InventoryOverlayScreen;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererCallbacks;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.gui.GuiConfigs;
import fi.dy.masa.minihud.gui.GuiShapeEditor;
import fi.dy.masa.minihud.gui.GuiShapeManager;
import fi.dy.masa.minihud.renderer.InventoryOverlayHandler;
import fi.dy.masa.minihud.renderer.OverlayRendererBeaconRange;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.DebugInfoUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;

public class KeyCallbacks {
    public static void init() {
        Callbacks callback = new Callbacks();
        Configs.Generic.SET_DISTANCE_REFERENCE_POINT.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.MOVE_SHAPE_TO_PLAYER.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.OPEN_CONFIG_GUI.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.SHAPE_EDITOR.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.INVENTORY_PREVIEW_TOGGLE_SCREEN.getKeybind().setCallback((IHotkeyCallback)callback);
        Configs.Generic.ENTITY_DATA_SYNC.setValueChangeCallback(config -> EntitiesDataManager.getInstance().onEntityDataSyncToggled((ConfigBoolean)config));
        Configs.Generic.HUD_DATA_SYNC.setValueChangeCallback(config -> HudDataManager.getInstance().onHudDataSyncToggled((ConfigBoolean)config));
        Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.BEACON_RANGE_LVL3_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.setValueChangeCallback(config -> KeyCallbacks.updateBeaconOverlay());
        Configs.Colors.CONDUIT_RANGE_OVERLAY_COLOR.setValueChangeCallback(cfg -> OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate());
        Configs.Generic.LIGHT_LEVEL_RANGE.setValueChangeCallback(config -> OverlayRendererLightLevel.INSTANCE.setNeedsUpdate());
        Configs.Generic.LIGHT_LEVEL_RENDER_THROUGH.setValueChangeCallback(config -> OverlayRendererLightLevel.INSTANCE.setRenderThrough(config.getBooleanValue()));
        Configs.Generic.STRUCTURES_RENDER_THROUGH.setValueChangeCallback(config -> OverlayRendererStructures.INSTANCE.setRenderThrough(config.getBooleanValue()));
        Configs.Generic.SPAWN_PLAYER_OUTER_OVERLAY_ENABLED.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate());
        Configs.Generic.SPAWN_PLAYER_REDSTONE_OVERLAY_ENABLED.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate());
        Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate());
        Configs.Colors.SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate());
        Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate());
        Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_PLAYER.setNeedsUpdate());
        Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.setValueChangeCallback(config -> OverlayRendererSpawnChunks.INSTANCE_REAL.setNeedsUpdate());
        RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackAdjustable((IConfigBoolean)RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY, (IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY)));
        RendererToggle.OVERLAY_BEACON_RANGE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onBeaconRangeToggled));
        RendererToggle.OVERLAY_BIOME_BORDER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onBiomeBorderToggled));
        RendererToggle.OVERLAY_CONDUIT_RANGE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onConduitRangeToggled));
        RendererToggle.OVERLAY_LIGHT_LEVEL.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onLightLevelToggled));
        RendererToggle.OVERLAY_RANDOM_TICKS_FIXED.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onRandomTicksFixedToggled));
        RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onRandomTicksPlayerToggled));
        RendererToggle.OVERLAY_REGION_FILE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onRegionFileToggled));
        RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onSlimeChunksToggled));
        RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onSpawnChunksPlayerToggled));
        RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onSpawnChunksRealToggled));
        RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onStructuresToggled));
        RendererToggle.SHAPE_RENDERER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)RendererCallbacks::onShapeRendererToggled));
        RendererToggle.DEBUG_CHUNK_BORDER.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_CHUNK_INFO.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_CHUNK_OCCLUSION.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
        RendererToggle.DEBUG_OCTREEE.setValueChangeCallback((IValueChangeCallback<IConfigBoolean>)((IValueChangeCallback)DebugInfoUtils::toggleDebugRenderer));
    }

    private static void updateBeaconOverlay() {
        OverlayRendererBeaconRange.INSTANCE.setNeedsUpdate();
    }

    public static class Callbacks
    implements IHotkeyCallback {
        public boolean onKeyAction(KeyAction action, IKeybind key) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return false;
            }
            if (key == Configs.Generic.OPEN_CONFIG_GUI.getKeybind()) {
                GuiBase.openGui((Screen)new GuiConfigs());
            } else if (key == Configs.Generic.MOVE_SHAPE_TO_PLAYER.getKeybind()) {
                Entity entity = mc.getCameraEntity() != null ? mc.getCameraEntity() : mc.player;
                ShapeBase shape = ShapeManager.INSTANCE.getSelectedShape();
                if (shape != null) {
                    shape.moveToPosition(entity.position());
                }
            } else if (key == Configs.Generic.SET_DISTANCE_REFERENCE_POINT.getKeybind()) {
                Entity entity = mc.getCameraEntity() != null ? mc.getCameraEntity() : mc.player;
                DataStorage.getInstance().setDistanceReferencePoint(entity.position());
            } else if (key == Configs.Generic.SHAPE_EDITOR.getKeybind()) {
                ShapeBase shape = ShapeManager.INSTANCE.getSelectedShape();
                if (shape != null) {
                    GuiBase.openGui((Screen)new GuiShapeEditor(shape));
                } else {
                    GuiConfigs.tab = GuiConfigs.ConfigGuiTab.SHAPES;
                    GuiBase.openGui((Screen)new GuiShapeManager());
                }
            } else if (key == Configs.Generic.INVENTORY_PREVIEW_TOGGLE_SCREEN.getKeybind()) {
                if (mc.screen instanceof InventoryOverlayScreen) {
                    mc.setScreen(null);
                } else if (Configs.Generic.INVENTORY_PREVIEW_ENABLED.getBooleanValue() && Configs.Generic.INVENTORY_PREVIEW.getKeybind().isKeybindHeld()) {
                    InventoryOverlayHandler.getInstance().refreshInventoryOverlay(mc, Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
                } else {
                    return false;
                }
            }
            return true;
        }
    }
}

