/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.mixin.entity.IMixinCopperGolemEntity;
import fi.dy.masa.minihud.util.CopperAgingMode;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineCopperAging
extends InfoLine {
    private static final String COPPER_KEY = "minihud.info_line.entity_copper_aging";

    public InfoLineCopperAging(InfoToggle type) {
        super(type);
    }

    public InfoLineCopperAging() {
        super(InfoToggle.ENTITY_COPPER_AGING);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@NotNull Level world, @NotNull EntityType<?> entityType, @NotNull CompoundTag nbt) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        Pair pair = NbtEntityUtils.getWeatheringDataFromNbt((CompoundTag)nbt);
        WeatheringCopper.WeatherState level = (WeatheringCopper.WeatherState)pair.getLeft();
        long age = (Long)pair.getRight();
        if (age == -2L) {
            list.add(this.translate("minihud.info_line.entity_copper_aging.waxed", level.getSerializedName()));
        } else if (age == -1L) {
            list.add(this.translate("minihud.info_line.entity_copper_aging.not_aging", level.getSerializedName()));
        } else {
            long diff = (world.getDayTime() - age) * -1L;
            String formatted = this.formatCountdown(diff);
            if (formatted.isEmpty()) {
                list.add(this.translate("minihud.info_line.entity_copper_aging.not_aging", level.getSerializedName()));
            } else {
                list.add(this.translate("minihud.info_line.entity_copper_aging.aging", level.getSerializedName(), formatted));
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull Level world, @NotNull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof CopperGolem) {
            CopperGolem cge = (CopperGolem)ent;
            WeatheringCopper.WeatherState level = cge.getWeatherState();
            long age = ((IMixinCopperGolemEntity)cge).minihud_getNextOxidationAge();
            if (age == -2L) {
                list.add(this.translate("minihud.info_line.entity_copper_aging.waxed", level.getSerializedName()));
            } else if (age == -1L) {
                list.add(this.translate("minihud.info_line.entity_copper_aging.not_aging", level.getSerializedName()));
            } else {
                long diff = (world.getDayTime() - age) * -1L;
                String formatted = this.formatCountdown(diff);
                if (formatted.isEmpty()) {
                    list.add(this.translate("minihud.info_line.entity_copper_aging.not_aging", level.getSerializedName()));
                } else {
                    list.add(this.translate("minihud.info_line.entity_copper_aging.aging", level.getSerializedName(), formatted));
                }
            }
        }
        return list;
    }

    private String formatCountdown(long remaining) {
        if (remaining <= 0L) {
            return "";
        }
        long diffMillis = (long)((double)remaining * 3.6 * 1000.0) / 60L;
        long day = (int)(remaining / 24000L);
        int dayTicks = (int)(remaining % 24000L);
        int hour = (dayTicks / 1000 + 6) % 24;
        int min = (int)((double)dayTicks / 16.666666) % 60;
        int sec = (int)((double)dayTicks / 0.277777) % 60;
        String gameTime = this.qt("minihud.info_line.entity_copper_aging.game_time", String.format("%d", day), String.format("%02d", hour), String.format("%02d", min), String.format("%02d", sec));
        String realTime = this.qt("minihud.info_line.entity_copper_aging.real_time", MiscUtils.formatDuration(diffMillis));
        String tickTime = this.qt("minihud.info_line.entity_copper_aging.ticks", String.valueOf(remaining));
        CopperAgingMode mode = (CopperAgingMode)Configs.Generic.COPPER_AGING_MODE.getOptionListValue();
        StringBuilder result = new StringBuilder();
        switch (mode) {
            case ALL: {
                result.append(gameTime).append(" [").append(tickTime).append("] / ").append(realTime);
                break;
            }
            case REAL_TICKS: {
                result.append("[").append(tickTime).append("] / ").append(realTime);
                break;
            }
            case MC_TICKS: {
                result.append(gameTime).append(" [").append(tickTime).append("]");
                break;
            }
            case MC_REAL: {
                result.append(gameTime).append(" / ").append(realTime);
                break;
            }
            case MC_TIME: {
                result.append(gameTime);
                break;
            }
            case REAL_TIME: {
                result.append(realTime);
                break;
            }
            case TICKS: {
                result.append(tickTime);
            }
        }
        return result.toString();
    }
}

