/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineDolphinTreasure
extends InfoLine {
    private static final String DOLPHIN_KEY = "minihud.info_line.dolphin_treasure";

    public InfoLineDolphinTreasure(InfoToggle type) {
        super(type);
    }

    public InfoLineDolphinTreasure() {
        super(InfoToggle.DOLPHIN_TREASURE);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@NotNull Level world, @NotNull EntityType<?> entityType, @NotNull CompoundTag nbt) {
        Pair dolphiPair = NbtEntityUtils.getDolphinDataFromNbt((CompoundTag)nbt);
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (dolphiPair != null && entityType.equals((Object)EntityType.DOLPHIN)) {
            int dryTime = (Integer)dolphiPair.getLeft();
            if (dryTime > 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.drying_no_treasure", MiscUtils.formatDuration((long)(dryTime / 20) * 1000L)));
            } else if (dryTime < 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.dying_no_treasure", MiscUtils.formatDuration((long)(dryTime * -1 / 20) * 1000L)));
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull Level world, @NotNull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof Dolphin) {
            Dolphin dolphin = (Dolphin)ent;
            int dryTime = dolphin.getMoistnessLevel();
            if (dryTime > 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.drying_no_treasure", MiscUtils.formatDuration((long)(dryTime / 20) * 1000L)));
            } else if (dryTime < 0) {
                list.add(this.translate("minihud.info_line.dolphin_treasure.dying_no_treasure", MiscUtils.formatDuration((long)(dryTime * -1 / 20) * 1000L)));
            }
        }
        return list;
    }
}

