/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariants;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.FrogVariants;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class InfoLineEntityVariant
extends InfoLine {
    private static final String VARIANT_KEY = "minihud.info_line.entity_variant";

    public InfoLineEntityVariant(InfoToggle type) {
        super(type);
    }

    public InfoLineEntityVariant() {
        super(InfoToggle.ENTITY_VARIANT);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull Level world, @Nonnull EntityType<?> entityType, @Nonnull CompoundTag nbt) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (entityType.equals((Object)EntityType.AXOLOTL)) {
            Axolotl.Variant variant = NbtEntityUtils.getAxolotlVariantFromNbt((CompoundTag)nbt);
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.axolotl", variant.getName()));
            }
        } else if (entityType.equals((Object)EntityType.CAT)) {
            Pair catPair = NbtEntityUtils.getCatVariantFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (catPair.getLeft() != null) {
                list.add(this.translate("minihud.info_line.entity_variant.cat", ((ResourceKey)catPair.getLeft()).location().getPath(), ((DyeColor)catPair.getRight()).getName()));
            }
        } else if (entityType.equals((Object)EntityType.COW)) {
            ResourceKey variant = NbtEntityUtils.getCowVariantFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.cow", variant.location().getPath()));
            }
        } else if (entityType.equals((Object)EntityType.CHICKEN)) {
            ResourceKey variant = NbtEntityUtils.getChickenVariantFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.chicken", variant.location().getPath()));
            }
        } else if (entityType.equals((Object)EntityType.MOOSHROOM)) {
            MushroomCow.Variant mooType = NbtEntityUtils.getMooshroomVariantFromNbt((CompoundTag)nbt);
            if (mooType != null) {
                list.add(this.translate("minihud.info_line.entity_variant.mooshroom", mooType.getSerializedName()));
            }
        } else if (entityType.equals((Object)EntityType.FOX)) {
            Fox.Variant foxType = NbtEntityUtils.getFoxVariantFromNbt((CompoundTag)nbt);
            if (foxType != null) {
                list.add(this.translate("minihud.info_line.entity_variant.fox", foxType.getSerializedName()));
            }
        } else if (entityType.equals((Object)EntityType.FROG)) {
            ResourceKey variant = NbtEntityUtils.getFrogVariantFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.frog", variant.location().getPath()));
            }
        } else if (entityType.equals((Object)EntityType.HORSE)) {
            Pair horsePair = NbtEntityUtils.getHorseVariantFromNbt((CompoundTag)nbt);
            if (horsePair.getLeft() != null) {
                list.add(this.translate("minihud.info_line.entity_variant.horse", ((Variant)horsePair.getLeft()).getSerializedName(), ((Markings)horsePair.getRight()).name().toLowerCase()));
            }
        } else if (entityType.equals((Object)EntityType.LLAMA) || entityType.equals((Object)EntityType.TRADER_LLAMA)) {
            Pair llamaPair = NbtEntityUtils.getLlamaTypeFromNbt((CompoundTag)nbt);
            if (llamaPair.getLeft() != null) {
                list.add(this.translate("minihud.info_line.entity_variant.llama", ((Llama.Variant)llamaPair.getLeft()).getSerializedName(), llamaPair.getRight()));
            }
        } else if (entityType.equals((Object)EntityType.PAINTING)) {
            Pair paintingPair = NbtEntityUtils.getPaintingDataFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (paintingPair.getRight() != null) {
                Optional title = ((PaintingVariant)paintingPair.getRight()).title();
                Optional author = ((PaintingVariant)paintingPair.getRight()).author();
                if (title.isPresent() && author.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.both", ((Component)title.get()).getString(), ((Component)author.get()).getString()));
                } else if (title.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.title_only", ((Component)title.get()).getString()));
                } else {
                    author.ifPresent(text -> list.add(this.translate("minihud.info_line.entity_variant.painting.author_only", text.getString())));
                }
            }
        } else if (entityType.equals((Object)EntityType.PARROT)) {
            Parrot.Variant variant = NbtEntityUtils.getParrotVariantFromNbt((CompoundTag)nbt);
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.parrot", variant.getSerializedName()));
            }
        } else if (entityType.equals((Object)EntityType.PIG)) {
            ResourceKey variant = NbtEntityUtils.getPigVariantFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.pig", variant.location().getPath()));
            }
        } else if (entityType.equals((Object)EntityType.RABBIT)) {
            Rabbit.Variant rabbitType = NbtEntityUtils.getRabbitTypeFromNbt((CompoundTag)nbt);
            if (rabbitType != null) {
                list.add(this.translate("minihud.info_line.entity_variant.rabbit", rabbitType.getSerializedName()));
            }
        } else if (entityType.equals((Object)EntityType.SALMON)) {
            Salmon.Variant salmonVariant = NbtEntityUtils.getSalmonVariantFromNbt((CompoundTag)nbt);
            if (salmonVariant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.salmon", salmonVariant.getSerializedName()));
            }
        } else if (entityType.equals((Object)EntityType.SHEEP)) {
            DyeColor color = NbtEntityUtils.getSheepColorFromNbt((CompoundTag)nbt);
            if (color != null) {
                list.add(this.translate("minihud.info_line.entity_variant.sheep", color.getName()));
            }
        } else if (entityType.equals((Object)EntityType.TROPICAL_FISH)) {
            TropicalFish.Pattern variant = NbtEntityUtils.getFishVariantFromNbt((CompoundTag)nbt);
            if (variant != null) {
                list.add(this.translate("minihud.info_line.entity_variant.tropical_fish", variant.getSerializedName()));
            }
        } else if (entityType.equals((Object)EntityType.WOLF)) {
            Pair wolfPair = NbtEntityUtils.getWolfVariantFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            ResourceKey soundType = NbtEntityUtils.getWolfSoundTypeFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
            if (wolfPair.getLeft() != null) {
                if (soundType != null) {
                    list.add(this.translate("minihud.info_line.entity_variant.wolf.sound_type", ((ResourceKey)wolfPair.getLeft()).location().getPath(), soundType.location().getPath(), ((DyeColor)wolfPair.getRight()).getName()));
                } else {
                    list.add(this.translate("minihud.info_line.entity_variant.wolf", ((ResourceKey)wolfPair.getLeft()).location().getPath(), ((DyeColor)wolfPair.getRight()).getName()));
                }
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull Level world, @Nonnull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        Entity entity = ent;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Axolotl.class, Cat.class, Chicken.class, Cow.class, MushroomCow.class, Fox.class, Frog.class, Horse.class, Llama.class, Painting.class, Parrot.class, Pig.class, Rabbit.class, Salmon.class, Sheep.class, TropicalFish.class, Wolf.class}, (Object)entity2, n)) {
            case 0: {
                Axolotl axolotl = (Axolotl)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.axolotl", axolotl.getVariant().getName()));
                break;
            }
            case 1: {
                Cat cat = (Cat)entity2;
                ResourceKey variant = cat.getVariant().unwrapKey().orElse(CatVariants.BLACK);
                list.add(this.translate("minihud.info_line.entity_variant.cat", variant.location().getPath(), cat.getCollarColor().getName()));
                break;
            }
            case 2: {
                Chicken chicken = (Chicken)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.chicken", chicken.getVariant().unwrapKey().orElse(ChickenVariants.DEFAULT).location().getPath()));
                break;
            }
            case 3: {
                Cow cow = (Cow)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.cow", cow.getVariant().unwrapKey().orElse(CowVariants.DEFAULT).location().getPath()));
                break;
            }
            case 4: {
                MushroomCow mooshroom = (MushroomCow)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.mooshroom", mooshroom.getVariant().getSerializedName()));
                break;
            }
            case 5: {
                Fox fox = (Fox)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.fox", fox.getVariant().getSerializedName()));
                break;
            }
            case 6: {
                Frog frog = (Frog)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.frog", frog.getVariant().unwrapKey().orElse(FrogVariants.TEMPERATE).location().getPath()));
                break;
            }
            case 7: {
                Horse horse = (Horse)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.horse", horse.getVariant().getSerializedName(), horse.getMarkings().name().toLowerCase()));
                break;
            }
            case 8: {
                Llama llama = (Llama)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.llama", llama.getVariant().getSerializedName(), llama.getStrength()));
                break;
            }
            case 9: {
                Painting painting = (Painting)entity2;
                PaintingVariant paintingVariant = (PaintingVariant)painting.getVariant().value();
                if (paintingVariant == null) break;
                Optional title = paintingVariant.title();
                Optional author = paintingVariant.author();
                if (title.isPresent() && author.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.both", ((Component)title.get()).getString(), ((Component)author.get()).getString()));
                    break;
                }
                if (title.isPresent()) {
                    list.add(this.translate("minihud.info_line.entity_variant.painting.title_only", ((Component)title.get()).getString()));
                    break;
                }
                author.ifPresent(text -> list.add(this.translate("minihud.info_line.entity_variant.painting.author_only", text.getString())));
                break;
            }
            case 10: {
                Parrot parrot = (Parrot)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.parrot", parrot.getVariant().getSerializedName()));
                break;
            }
            case 11: {
                Pig pig = (Pig)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.pig", pig.getVariant().unwrapKey().orElse(PigVariants.DEFAULT).location().getPath()));
                break;
            }
            case 12: {
                Rabbit rabbit = (Rabbit)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.rabbit", rabbit.getVariant().getSerializedName()));
                break;
            }
            case 13: {
                Salmon salmon = (Salmon)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.salmon", salmon.getVariant().getSerializedName()));
                break;
            }
            case 14: {
                Sheep sheep = (Sheep)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.sheep", sheep.getColor().getName()));
                break;
            }
            case 15: {
                TropicalFish fish = (TropicalFish)entity2;
                list.add(this.translate("minihud.info_line.entity_variant.tropical_fish", fish.getPattern().getSerializedName()));
                break;
            }
            case 16: {
                Wolf wolf = (Wolf)entity2;
                Pair wolfPair = EntityUtils.getWolfVariantFromComponents((Wolf)wolf);
                ResourceKey soundType = EntityUtils.getWolfSoundTypeFromComponents((Wolf)wolf);
                if (soundType != null) {
                    list.add(this.translate("minihud.info_line.entity_variant.wolf.sound_type", ((ResourceKey)wolfPair.getLeft()).location().getPath(), soundType.location().getPath(), ((DyeColor)wolfPair.getRight()).getName()));
                    break;
                }
                list.add(this.translate("minihud.info_line.entity_variant.wolf", ((ResourceKey)wolfPair.getLeft()).location().getPath(), ((DyeColor)wolfPair.getRight()).getName()));
                break;
            }
        }
        return list;
    }
}

