/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineHomePos
extends InfoLine {
    private static final String HOME_KEY = "minihud.info_line.home_pos";

    public InfoLineHomePos(InfoToggle type) {
        super(type);
    }

    public InfoLineHomePos() {
        super(InfoToggle.ENTITY_HOME_POS);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@NotNull Level world, @NotNull EntityType<?> entityType, @NotNull CompoundTag nbt) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        Pair pair = NbtEntityUtils.getHomePosFromNbt((CompoundTag)nbt);
        if (pair.getLeft() != BlockPos.ZERO && (Integer)pair.getRight() != -1) {
            list.add(this.translate(HOME_KEY, ((BlockPos)pair.getLeft()).toShortString(), pair.getRight()));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull Level world, @NotNull Entity ent) {
        Mob mob;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof Mob && (mob = (Mob)ent).hasHome()) {
            list.add(this.translate(HOME_KEY, mob.getHomePosition().toShortString(), mob.getHomeRadius()));
        }
        return list;
    }
}

