/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLineHorseJump
extends InfoLine {
    private static final String HORSE_KEY = "minihud.info_line.horse_jump";

    public InfoLineHorseJump(InfoToggle type) {
        super(type);
    }

    public InfoLineHorseJump() {
        super(InfoToggle.HORSE_JUMP);
    }

    @Override
    public boolean succeededType() {
        return this.succeeded;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLine.Context ctx) {
        Entity vehicle;
        if (ctx.world() == null) {
            return null;
        }
        if (this.mc().player != null && (vehicle = Objects.requireNonNull(this.mc().player).getVehicle()) instanceof AbstractHorse) {
            return this.parseEnt(ctx.world(), vehicle);
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        if (ctx.ent() != null) {
            return this.parseEnt(ctx.world(), ctx.ent());
        }
        return null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@NotNull Level world, @NotNull EntityType<?> entityType, @NotNull CompoundTag nbt) {
        Pair horsePair;
        double jump;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        String horseType = entityType.getDescription().getString();
        if ((entityType.equals((Object)EntityType.CAMEL) || entityType.equals((Object)EntityType.DONKEY) || entityType.equals((Object)EntityType.HORSE) || entityType.equals((Object)EntityType.LLAMA) || entityType.equals((Object)EntityType.MULE) || entityType.equals((Object)EntityType.SKELETON_HORSE) || entityType.equals((Object)EntityType.TRADER_LLAMA) || entityType.equals((Object)EntityType.ZOMBIE_HORSE)) && (jump = ((Double)(horsePair = NbtEntityUtils.getSpeedAndJumpStrengthFromNbt((CompoundTag)nbt)).getRight()).doubleValue()) > 0.0) {
            double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
            list.add(this.translate(HORSE_KEY, horseType, calculatedJumpHeight));
            this.succeeded = true;
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull Level world, @NotNull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)ent;
            String horseType = horse.getType().getDescription().getString();
            double jump = horse.getAttributeValue(Attributes.JUMP_STRENGTH);
            if (jump > 0.0) {
                double calculatedJumpHeight = -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump + -0.343930367;
                list.add(this.translate(HORSE_KEY, horseType, calculatedJumpHeight));
                this.succeeded = true;
            }
        }
        return list;
    }
}

