/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class InfoLineLookingAtEffects
extends InfoLine {
    private static final String EFFECTS_KEY = "minihud.info_line.looking_at_effects";

    public InfoLineLookingAtEffects(InfoToggle type) {
        super(type);
    }

    public InfoLineLookingAtEffects() {
        this(InfoToggle.LOOKING_AT_EFFECTS);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull Level world, @Nonnull EntityType<?> entityType, @Nonnull CompoundTag nbt) {
        Map effects = NbtEntityUtils.getActiveStatusEffectsFromNbt((CompoundTag)nbt, (RegistryAccess)world.registryAccess());
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (effects == null || effects.isEmpty()) {
            return list;
        }
        for (Holder effectType : effects.keySet()) {
            MobEffectInstance effect = (MobEffectInstance)effects.get(effectType);
            if (!effect.isInfiniteDuration() && effect.getDuration() <= 0) continue;
            list.add(this.translate(EFFECTS_KEY, ((MobEffect)effectType.value()).getDisplayName().getString(), effect.getAmplifier() > 0 ? this.qt("minihud.info_line.looking_at_effects.amplifier", effect.getAmplifier() + 1) : "", effect.isInfiniteDuration() ? this.qt("minihud.info_line.looking_at_effects.infinite", new Object[0]) : MiscUtils.formatDuration((long)(effect.getDuration() / 20) * 1000L), this.qt("minihud.info_line.remaining", new Object[0])));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull Level world, @Nonnull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)ent;
            Collection effects = living.getActiveEffects();
            for (MobEffectInstance effect : effects) {
                if (!effect.isInfiniteDuration() && effect.getDuration() <= 0) continue;
                list.add(this.translate(EFFECTS_KEY, ((MobEffect)effect.getEffect().value()).getDisplayName().getString(), effect.getAmplifier() > 0 ? this.qt("minihud.info_line.looking_at_effects.amplifier", effect.getAmplifier() + 1) : "", effect.isInfiniteDuration() ? this.qt("minihud.info_line.looking_at_effects.infinite", new Object[0]) : MiscUtils.formatDuration((long)(effect.getDuration() / 20) * 1000L), this.qt("minihud.info_line.remaining", new Object[0])));
            }
        }
        return list;
    }
}

