/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.mixin.entity.IMixinPassiveEntity;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;

public class InfoLineLookingAtEntity
extends InfoLine {
    private static final String LOOKING_KEY = "minihud.info_line.looking_at_entity";

    public InfoLineLookingAtEntity(InfoToggle type) {
        super(type);
    }

    public InfoLineLookingAtEntity() {
        this(InfoToggle.LOOKING_AT_ENTITY);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        AgeableMob passive;
        OwnableEntity tamable;
        LivingEntity owner;
        Entity healthPair;
        if (ctx.world() == null) {
            return null;
        }
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        Entity entity = ctx.ent();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (ctx.hasNbt()) {
                Player owner2;
                healthPair = NbtEntityUtils.getHealthFromNbt((CompoundTag)ctx.nbt());
                Pair ownerPair = NbtEntityUtils.getTamableOwner((CompoundTag)ctx.nbt());
                Pair agePair = NbtEntityUtils.getAgeFromNbt((CompoundTag)ctx.nbt());
                double health = (Double)healthPair.getLeft();
                double maxHealth = (Double)healthPair.getRight();
                if ((double)living.getHealth() != health) {
                    health = living.getHealth();
                }
                Object entityLine = this.qt("minihud.info_line.looking_at_entity.livingentity", living.getName().getString(), health, maxHealth);
                if (ownerPair.getLeft() != Util.NIL_UUID && (owner2 = ctx.world().getPlayerByUUID((UUID)ownerPair.getLeft())) != null) {
                    entityLine = (String)entityLine + " - " + this.qt("minihud.info_line.looking_at_entity.owner", new Object[0]) + ": " + owner2.getName().tryCollapseToString();
                }
                if ((Integer)agePair.getLeft() < 0) {
                    int untilGrown = (Integer)agePair.getLeft() * -1;
                    entityLine = (String)entityLine + " [" + MiscUtils.formatDuration((long)untilGrown * 50L) + " " + this.qt("minihud.info_line.remaining", new Object[0]) + "]";
                }
                list.add(this.format((String)entityLine, new Object[0]));
                return list;
            }
        }
        if (!((healthPair = ctx.ent()) instanceof LivingEntity)) {
            entity = ctx.ent();
            if (!(entity instanceof Entity)) return list;
            Entity ent = entity;
            list.add(this.translate(LOOKING_KEY, ent.getName().getString()));
            return list;
        }
        LivingEntity living = (LivingEntity)healthPair;
        Object entityLine = this.qt("minihud.info_line.looking_at_entity.livingentity", living.getName().getString(), Float.valueOf(living.getHealth()), Float.valueOf(living.getMaxHealth()));
        if (living instanceof OwnableEntity && (owner = (tamable = (OwnableEntity)living).getOwner()) != null) {
            entityLine = (String)entityLine + " - " + this.qt("minihud.info_line.looking_at_entity.owner", new Object[0]) + ": " + owner.getName().tryCollapseToString();
        }
        if (living instanceof AgeableMob && (passive = (AgeableMob)living).getAge() < 0) {
            int untilGrown = ((IMixinPassiveEntity)passive).minihud_getRealBreedingAge() * -1;
            entityLine = (String)entityLine + " [" + MiscUtils.formatDuration((long)untilGrown * 50L) + " " + this.qt("minihud.info_line.remaining", new Object[0]) + "]";
        }
        list.add(this.format((String)entityLine, new Object[0]));
        return list;
    }
}

