/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;

public class InfoLineLookingAtPlayerExp
extends InfoLine {
    private static final String PLAYER_KEY = "minihud.info_line.looking_at_player_exp";

    public InfoLineLookingAtPlayerExp(InfoToggle type) {
        super(type);
    }

    public InfoLineLookingAtPlayerExp() {
        this(InfoToggle.LOOKING_AT_PLAYER_EXP);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull Level world, @Nonnull EntityType<?> entityType, @Nonnull CompoundTag nbt) {
        Triple triple;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (entityType.equals((Object)EntityType.PLAYER) && (Integer)(triple = NbtEntityUtils.getPlayerExpFromNbt((CompoundTag)nbt)).getLeft() > 0) {
            list.add(this.translate(PLAYER_KEY, triple.getLeft(), triple.getRight(), 100 * (Integer)triple.getMiddle()));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull Level world, @Nonnull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)ent;
            list.add(this.translate(PLAYER_KEY, player.experienceLevel, Float.valueOf(100.0f * player.experienceProgress), player.totalExperience));
        }
        return list;
    }
}

