/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InfoLinePandaGene
extends InfoLine {
    private static final String PANDA_KEY = "minihud.info_line.panda_gene";

    public InfoLinePandaGene(InfoToggle type) {
        super(type);
    }

    public InfoLinePandaGene() {
        super(InfoToggle.PANDA_GENE);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@NotNull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@NotNull Level world, @NotNull EntityType<?> entityType, @NotNull CompoundTag nbt) {
        Pair genes;
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (entityType.equals((Object)EntityType.PANDA) && (genes = NbtEntityUtils.getPandaGenesFromNbt((CompoundTag)nbt)).getLeft() != null && genes.getRight() != null) {
            list.add(this.translate("minihud.info_line.panda_gene.main_gene", this.qt("minihud.info_line.panda_gene.gene." + ((Panda.Gene)genes.getLeft()).getSerializedName(), new Object[0]), ((Panda.Gene)genes.getLeft()).isRecessive() ? this.qt("minihud.info_line.panda_gene.recessive_gene", new Object[0]) : this.qt("minihud.info_line.panda_gene.dominant_gene", new Object[0])));
            list.add(this.translate("minihud.info_line.panda_gene.hidden_gene", this.qt("minihud.info_line.panda_gene.gene." + ((Panda.Gene)genes.getRight()).getSerializedName(), new Object[0]), ((Panda.Gene)genes.getRight()).isRecessive() ? this.qt("minihud.info_line.panda_gene.recessive_gene", new Object[0]) : this.qt("minihud.info_line.panda_gene.dominant_gene", new Object[0])));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@NotNull Level world, @NotNull Entity ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof Panda) {
            Panda panda = (Panda)ent;
            list.add(this.translate("minihud.info_line.panda_gene.main_gene", this.qt("minihud.info_line.panda_gene.gene." + panda.getMainGene().getSerializedName(), new Object[0]), panda.getMainGene().isRecessive() ? this.qt("minihud.info_line.panda_gene.recessive_gene", new Object[0]) : this.qt("minihud.info_line.panda_gene.dominant_gene", new Object[0])));
            list.add(this.translate("minihud.info_line.panda_gene.hidden_gene", this.qt("minihud.info_line.panda_gene.gene." + panda.getHiddenGene().getSerializedName(), new Object[0]), panda.getHiddenGene().isRecessive() ? this.qt("minihud.info_line.panda_gene.recessive_gene", new Object[0]) : this.qt("minihud.info_line.panda_gene.dominant_gene", new Object[0])));
        }
        return list;
    }
}

