/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.mixin.entity.IMixinSkeletonEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieEntity;
import fi.dy.masa.minihud.mixin.entity.IMixinZombieVillagerEntity;
import fi.dy.masa.minihud.util.MiscUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class InfoLineZombieConversion
extends InfoLine {
    private static final String ZOMBIE_KEY = "minihud.info_line.zombie_conversion";

    public InfoLineZombieConversion(InfoToggle type) {
        super(type);
    }

    public InfoLineZombieConversion() {
        this(InfoToggle.ZOMBIE_CONVERSION);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasNbt()) {
            EntityType entityType = NbtEntityUtils.getEntityTypeFromNbt((CompoundTag)ctx.nbt());
            if (entityType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), entityType, ctx.nbt());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull Level world, @Nonnull EntityType<?> entityType, @Nonnull CompoundTag nbt) {
        String zombieType = entityType.getDescription().getString();
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        int conversionTimer = -1;
        if (entityType.equals((Object)EntityType.ZOMBIE_VILLAGER)) {
            Pair zombieDoctor = NbtEntityUtils.getZombieConversionTimerFromNbt((CompoundTag)nbt);
            conversionTimer = (Integer)zombieDoctor.getLeft();
        } else if (entityType.equals((Object)EntityType.ZOMBIE)) {
            Pair zombieDoctor = NbtEntityUtils.getDrownedConversionTimerFromNbt((CompoundTag)nbt);
            conversionTimer = (Integer)zombieDoctor.getLeft();
        } else if (entityType.equals((Object)EntityType.SKELETON)) {
            conversionTimer = NbtEntityUtils.getStrayConversionTimeFromNbt((CompoundTag)nbt);
        }
        if (conversionTimer > 0) {
            list.add(this.translate(ZOMBIE_KEY, zombieType, MiscUtils.formatDuration((long)(conversionTimer / 20) * 1000L)));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull Level world, @Nonnull Entity ent) {
        String zombieType = ent.getType().getDescription().getString();
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        Entity entity = ent;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        int conversionTimer = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ZombieVillager.class, Zombie.class, Skeleton.class}, (Object)entity2, n)) {
            case 0 -> {
                ZombieVillager zombie = (ZombieVillager)entity2;
                yield ((IMixinZombieVillagerEntity)zombie).minihud_conversionTimer();
            }
            case 1 -> {
                Zombie zombert = (Zombie)entity2;
                yield ((IMixinZombieEntity)zombert).minihud_ticksUntilWaterConversion();
            }
            case 2 -> {
                Skeleton skeleton = (Skeleton)entity2;
                yield ((IMixinSkeletonEntity)skeleton).minihud_conversionTime();
            }
            default -> -1;
        };
        if (conversionTimer > 0) {
            list.add(this.translate(ZOMBIE_KEY, zombieType, MiscUtils.formatDuration((long)(conversionTimer / 20) * 1000L)));
        }
        return list;
    }
}

